/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.expressions.integer;

import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.IntValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import org.jetbrains.annotations.NotNull;

public abstract class ComparisonExpression
extends BooleanExpression {
    private final ObservableValue<Integer> myValueLhs;
    private final ObservableValue<Integer> myValueRhs;

    public static ObservableBool isEqual(@NotNull ObservableValue<Integer> valueLhs, @NotNull ObservableValue<Integer> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs == valueRhs;
            }
        };
    }

    public static ObservableBool isGreaterThan(@NotNull ObservableValue<Integer> valueLhs, @NotNull ObservableValue<Integer> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs > valueRhs;
            }
        };
    }

    public static ObservableBool isGreaterThanEqual(@NotNull ObservableValue<Integer> valueLhs, @NotNull ObservableValue<Integer> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs >= valueRhs;
            }
        };
    }

    public static ObservableBool isLessThan(@NotNull ObservableValue<Integer> valueLhs, @NotNull ObservableValue<Integer> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs < valueRhs;
            }
        };
    }

    public static ObservableBool isLessThanEqual(@NotNull ObservableValue<Integer> valueLhs, @NotNull ObservableValue<Integer> valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)valueRhs){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs <= valueRhs;
            }
        };
    }

    public static ObservableBool isEqual(@NotNull ObservableValue<Integer> valueLhs, int valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new IntValueProperty(valueRhs)){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs == valueRhs;
            }
        };
    }

    public static ObservableBool isGreaterThan(@NotNull ObservableValue<Integer> valueLhs, int valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new IntValueProperty(valueRhs)){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs > valueRhs;
            }
        };
    }

    public static ObservableBool isGreaterThanEqual(@NotNull ObservableValue<Integer> valueLhs, int valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new IntValueProperty(valueRhs)){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs >= valueRhs;
            }
        };
    }

    public static ObservableBool isLessThan(@NotNull ObservableValue<Integer> valueLhs, int valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new IntValueProperty(valueRhs)){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs < valueRhs;
            }
        };
    }

    public static ObservableBool isLessThanEqual(@NotNull ObservableValue<Integer> valueLhs, int valueRhs) {
        return new ComparisonExpression((ObservableValue)valueLhs, (ObservableValue)new IntValueProperty(valueRhs)){

            @Override
            protected Boolean compare(int valueLhs, int valueRhs) {
                return valueLhs <= valueRhs;
            }
        };
    }

    protected ComparisonExpression(@NotNull ObservableValue<Integer> valueLhs, @NotNull ObservableValue<Integer> valueRhs) {
        super(valueLhs, valueRhs);
        this.myValueLhs = valueLhs;
        this.myValueRhs = valueRhs;
    }

    @Override
    @NotNull
    public final Boolean get() {
        return this.compare(this.myValueLhs.get(), this.myValueRhs.get());
    }

    protected abstract Boolean compare(int var1, int var2);
}

