/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.ui;

import com.android.tools.idea.observable.core.OptionalProperty;
import java.util.Optional;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class SelectedListValueProperty<T>
extends OptionalProperty<T>
implements ListSelectionListener {
    private final JList<T> myList;

    public SelectedListValueProperty(@NotNull JList<T> list) {
        this.myList = list;
        this.myList.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(@NotNull ListSelectionEvent event) {
        this.notifyInvalidated();
    }

    @Override
    @NotNull
    public Optional<T> get() {
        return Optional.ofNullable(this.myList.getSelectedValue());
    }

    @Override
    protected void setDirectly(@NotNull Optional<T> value) {
        this.myList.setSelectedValue(value.orElse(null), true);
    }
}

