/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AndroidProfilerToolWindowFactory
implements DumbAware,
ToolWindowFactory,
Condition<Project> {
    public static final String ID = "Android Profiler";
    private static final String ANDROID_PROFILER_ACTIVE = "android.profiler.active";

    public void createToolWindowContent(final @NotNull Project project, @NotNull ToolWindow toolWindow) {
        toolWindow.setToHideOnEmptyContent(true);
        ToolWindowManagerEx.getInstanceEx((Project)project).addToolWindowManagerListener(new ToolWindowManagerListener(){

            public void toolWindowRegistered(@NotNull String id) {
            }

            public void stateChanged() {
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidProfilerToolWindowFactory.ID);
                if (window != null && window.isVisible() && window.getContentManager().getContentCount() == 0) {
                    AndroidProfilerToolWindowFactory.createContent(project, window);
                }
            }
        });
        toolWindow.hide(null);
        toolWindow.setShowStripeButton(false);
    }

    private static void createContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        AndroidProfilerToolWindow view = new AndroidProfilerToolWindow(project);
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content = contentFactory.createContent(view.getComponent(), "", false);
        Disposer.register((Disposable)content, (Disposable)view);
        toolWindow.getContentManager().addContent(content);
        toolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)StudioIcons.Shell.ToolWindows.ANDROID_PROFILER));
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)project);
        properties.setValue(ANDROID_PROFILER_ACTIVE, true);
        toolWindow.show(null);
    }

    public static void removeContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        toolWindow.getContentManager().removeAllContents(true);
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)project);
        toolWindow.setIcon(StudioIcons.Shell.ToolWindows.ANDROID_PROFILER);
        properties.setValue(ANDROID_PROFILER_ACTIVE, false);
    }

    public boolean value(Project project) {
        return true;
    }
}

