/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.ResizableImage;
import com.android.tools.profilers.stacktrace.DataViewer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijDataViewer
implements DataViewer {
    @NotNull
    private final JComponent myComponent;
    @Nullable
    private final Dimension myDimension;

    @NotNull
    public static IntellijDataViewer createImageViewer(@NotNull BufferedImage image) {
        return new IntellijDataViewer(new ResizableImage(image), new Dimension(image.getWidth(), image.getHeight()));
    }

    @NotNull
    public static IntellijDataViewer createEditorViewer(@NotNull String content, @Nullable FileType contentType) {
        try {
            EditorFactory editorFactory = EditorFactory.getInstance();
            Document document = editorFactory.createDocument(content.toCharArray());
            document.setReadOnly(true);
            EditorEx editor = (EditorEx)editorFactory.createViewer(document);
            editor.setCaretVisible(false);
            editor.getSettings().setLineNumbersShown(false);
            editor.getSettings().setLineMarkerAreaShown(false);
            editor.getSettings().setFoldingOutlineShown(false);
            if (contentType != null) {
                editor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(null, contentType));
            }
            return new IntellijDataViewer(editor.getComponent(), null);
        }
        catch (AssertionError | Exception e) {
            return IntellijDataViewer.createInvalidViewer();
        }
    }

    @NotNull
    public static IntellijDataViewer createInvalidViewer() {
        JLabel component2 = new JLabel("No preview available", 0);
        component2.setFont(component2.getFont().deriveFont(14.0f));
        return new IntellijDataViewer(component2, null);
    }

    private IntellijDataViewer(@NotNull JComponent component2, @Nullable Dimension dimension) {
        this.myComponent = component2;
        this.myDimension = dimension;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myComponent;
    }

    @Nullable
    public Dimension getDimension() {
        return this.myDimension;
    }
}

