/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.ExportDialog;
import com.android.tools.idea.profilers.IntellijDataViewer;
import com.android.tools.idea.profilers.ResizableImage;
import com.android.tools.idea.profilers.actions.NavigateToCodeAction;
import com.android.tools.idea.profilers.stacktrace.IntelliJStackTraceView;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.android.tools.profilers.stacktrace.DataViewer;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.android.tools.profilers.stacktrace.StackTraceModel;
import com.android.tools.profilers.stacktrace.StackTraceView;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBLoadingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijProfilerComponents
implements IdeProfilerComponents {
    private static final String COMPONENT_CONTEXT_MENU = "ComponentContextMenu";
    private static final Map<String, FileType> FILE_TYPE_MAP = new ImmutableMap.Builder().put((Object)".html", (Object)StdFileTypes.HTML).put((Object)".xml", (Object)StdFileTypes.XML).put((Object)".json", (Object)FileTypeManager.getInstance().getStdFileType("JSON")).build();
    private static final ImmutableSet<String> IMAGE_EXTENSIONS = ImmutableSet.of((Object)".bmp", (Object)".gif", (Object)".jpeg", (Object)".jpg", (Object)".png");
    @NotNull
    private final Project myProject;

    public IntellijProfilerComponents(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public LoadingPanel createLoadingPanel(final int delayMs) {
        return new LoadingPanel(){
            private final JBLoadingPanel myLoadingPanel;
            {
                this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)IntellijProfilerComponents.this.myProject, delayMs);
            }

            @NotNull
            public JComponent getComponent() {
                return this.myLoadingPanel;
            }

            public void setChildComponent(@Nullable Component comp) {
                this.myLoadingPanel.getContentPanel().removeAll();
                if (comp != null) {
                    this.myLoadingPanel.add(comp);
                }
            }

            public void setLoadingText(@NotNull String loadingText) {
                this.myLoadingPanel.setLoadingText(loadingText);
            }

            public void startLoading() {
                this.myLoadingPanel.startLoading();
            }

            public void stopLoading() {
                this.myLoadingPanel.stopLoading();
            }
        };
    }

    @NotNull
    public StackTraceView createStackView(@NotNull StackTraceModel model) {
        return new IntelliJStackTraceView(this.myProject, model);
    }

    public void installNavigationContextMenu(@NotNull JComponent component2, @NotNull CodeNavigator navigator, @NotNull Supplier<CodeLocation> codeLocationSupplier) {
        DefaultActionGroup popupGroup = this.createOrGetActionGroup(component2);
        popupGroup.add((AnAction)new NavigateToCodeAction(codeLocationSupplier, navigator));
    }

    public void installContextMenu(@NotNull JComponent component2, final @NotNull ContextMenuItem contextMenuItem) {
        DefaultActionGroup popupGroup = this.createOrGetActionGroup(component2);
        popupGroup.add(new AnAction(null, null, contextMenuItem.getIcon()){

            public void update(AnActionEvent e) {
                super.update(e);
                Presentation presentation = e.getPresentation();
                presentation.setText(contextMenuItem.getText());
                presentation.setEnabled(contextMenuItem.isEnabled());
            }

            public void actionPerformed(AnActionEvent e) {
                contextMenuItem.run();
            }
        });
    }

    public void openExportDialog(@NotNull Supplier<String> dialogTitleSupplier, @NotNull Supplier<String> extensionSupplier, @NotNull Consumer<File> saveToFile) {
        ApplicationManager.getApplication().invokeLater(() -> {
            ExportDialog dialog;
            String extension = (String)extensionSupplier.get();
            if (extension != null && (dialog = new ExportDialog(this.myProject, (String)dialogTitleSupplier.get(), extension)).showAndGet()) {
                saveToFile.accept(dialog.getFile());
            }
        });
    }

    @NotNull
    private DefaultActionGroup createOrGetActionGroup(@NotNull JComponent component2) {
        DefaultActionGroup actionGroup = (DefaultActionGroup)component2.getClientProperty(COMPONENT_CONTEXT_MENU);
        if (actionGroup == null) {
            final DefaultActionGroup newActionGroup = new DefaultActionGroup();
            component2.putClientProperty(COMPONENT_CONTEXT_MENU, newActionGroup);
            component2.addMouseListener((MouseListener)new PopupHandler(){

                public void invokePopup(Component comp, int x, int y) {
                    ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)newActionGroup).getComponent().show(comp, x, y);
                }
            });
            actionGroup = newActionGroup;
        }
        return actionGroup;
    }

    @NotNull
    public DataViewer createFileViewer(@NotNull File file) {
        String extension;
        String fileName = file.getName();
        int dot = fileName.lastIndexOf(46);
        String string = extension = dot >= 0 && dot < fileName.length() ? fileName.substring(dot) : "";
        if (IMAGE_EXTENSIONS.contains((Object)extension)) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (image != null) {
                return IntellijDataViewer.createImageViewer(image);
            }
            return IntellijDataViewer.createInvalidViewer();
        }
        String content = null;
        if (file.exists()) {
            try {
                content = new String(Files.readAllBytes(file.toPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (content == null) {
            return IntellijDataViewer.createInvalidViewer();
        }
        return IntellijDataViewer.createEditorViewer(content, FILE_TYPE_MAP.getOrDefault(extension, null));
    }

    @NotNull
    public JComponent createResizableImageComponent(@NotNull BufferedImage image) {
        return new ResizableImage(image);
    }
}

