/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.analytics.StudioFeatureTracker;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilingConfigService;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilingConfigurationsDialog;
import com.android.tools.idea.profilers.stacktrace.IntellijCodeNavigator;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijProfilerServices
implements IdeProfilerServices {
    private final IntellijCodeNavigator myCodeNavigator;
    private final StudioFeatureTracker myFeatureTracker = new StudioFeatureTracker();
    @NotNull
    private final Project myProject;

    private static Logger getLogger() {
        return Logger.getInstance(IntellijProfilerServices.class);
    }

    public IntellijProfilerServices(@NotNull Project project) {
        this.myProject = project;
        this.myCodeNavigator = new IntellijCodeNavigator(project, this.myFeatureTracker);
    }

    @NotNull
    public Executor getMainExecutor() {
        return arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0);
    }

    @NotNull
    public Executor getPoolExecutor() {
        return arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0);
    }

    public void saveFile(@NotNull File file, @NotNull Consumer<FileOutputStream> fileOutputStreamConsumer, @Nullable Runnable postRunnable) {
        File parentDir = file.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    IntellijProfilerServices.getLogger().error("Could not create new file at: " + file.getPath());
                    return;
                }
            }
            catch (IOException e) {
                IntellijProfilerServices.getLogger().error((Throwable)e);
            }
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            fileOutputStreamConsumer.accept(fos);
        }
        catch (IOException e) {
            IntellijProfilerServices.getLogger().error((Throwable)e);
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        if (virtualFile != null) {
            virtualFile.refresh(true, false, postRunnable);
        }
    }

    @NotNull
    public CodeNavigator getCodeNavigator() {
        return this.myCodeNavigator;
    }

    @NotNull
    public FeatureTracker getFeatureTracker() {
        return this.myFeatureTracker;
    }

    public void enableAdvancedProfiling() {
        RunnerAndConfigurationSettings configurationSettings;
        AndroidRunConfigurationBase androidConfiguration = null;
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        if (runManager != null && (configurationSettings = runManager.getSelectedConfiguration()) != null && configurationSettings.getConfiguration() instanceof AndroidRunConfigurationBase) {
            androidConfiguration = (AndroidRunConfigurationBase)configurationSettings.getConfiguration();
            androidConfiguration.getProfilerState().setCheckAdvancedProfiling(true);
        }
        EditConfigurationsDialog dialog = new EditConfigurationsDialog(this.myProject);
        dialog.show();
        if (androidConfiguration != null) {
            androidConfiguration.getProfilerState().setCheckAdvancedProfiling(false);
        }
    }

    @NotNull
    public FeatureConfig getFeatureConfig() {
        return new FeatureConfig(){

            public boolean isJvmtiAgentEnabled() {
                return StudioFlags.PROFILER_USE_JVMTI.get();
            }

            public boolean isNetworkThreadViewEnabled() {
                return StudioFlags.PROFILER_SHOW_THREADS_VIEW.get();
            }

            public boolean isSimplePerfEnabled() {
                return StudioFlags.PROFILER_USE_SIMPLEPERF.get();
            }

            public boolean isLiveAllocationsEnabled() {
                return StudioFlags.PROFILER_USE_JVMTI.get() != false && StudioFlags.PROFILER_USE_LIVE_ALLOCATIONS.get() != false;
            }
        };
    }

    public void openCpuProfilingConfigurationsDialog(ProfilingConfiguration configuration, boolean isDeviceAtLeastO, Consumer<ProfilingConfiguration> dialogCallback) {
        CpuProfilingConfigurationsDialog dialog = new CpuProfilingConfigurationsDialog(this.myProject, isDeviceAtLeastO, configuration, dialogCallback, this.myFeatureTracker);
        dialog.show();
    }

    public void openParseLargeTracesDialog(Runnable yesCallback, Runnable noCallback) {
        int dialogResult = Messages.showYesNoDialog((Project)this.myProject, (String)"The trace file generated is large, and Android Studio may become unresponsive while it parses the data. Do you want to continue?\n\nWarning: If you select \"No\", Android Studio discards the trace data and you will need to capture a new method trace.", (String)"Trace File Too Large", (Icon)Messages.getWarningIcon());
        if (dialogResult == 0) {
            yesCallback.run();
        } else {
            noCallback.run();
        }
    }

    public List<ProfilingConfiguration> getCpuProfilingConfigurations() {
        return CpuProfilingConfigService.getInstance(this.myProject).getConfigurations();
    }
}

