/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.profiler.proto.MemoryProfiler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class LegacyAllocationConverter {
    @NotNull
    private List<Allocation> myAllocations = new ArrayList<Allocation>();
    @NotNull
    private Map<String, ClassName> myAllocatedClasses = new HashMap<String, ClassName>();
    @NotNull
    private Map<List<StackTraceElement>, CallStack> myAllocationStacks = new HashMap<List<StackTraceElement>, CallStack>();

    public int addClassName(@NotNull String className) {
        int id;
        if (!this.myAllocatedClasses.containsKey(className)) {
            id = this.myAllocatedClasses.size();
            this.myAllocatedClasses.put(className, new ClassName(className, id));
        } else {
            id = this.myAllocatedClasses.get(className).myClassId;
        }
        return id;
    }

    @NotNull
    public CallStack addCallStack(@NotNull List<StackTraceElement> stackTraceElements) {
        CallStack result;
        if (!this.myAllocationStacks.containsKey(stackTraceElements)) {
            result = new CallStack(stackTraceElements);
            this.myAllocationStacks.put(stackTraceElements, result);
        } else {
            result = this.myAllocationStacks.get(stackTraceElements);
        }
        return result;
    }

    public void prepare() {
        this.myAllocations.clear();
    }

    public void addAllocation(@NotNull Allocation allocationInfo) {
        this.myAllocations.add(allocationInfo);
    }

    public List<MemoryProfiler.LegacyAllocationEvent> getAllocationEvents(long startTime, long endTime) {
        return this.myAllocations.stream().map(allocation -> allocation.bindAllocationEventInfos(startTime, endTime)).collect(Collectors.toList());
    }

    public List<MemoryProfiler.AllocationStack> getAllocationStacks() {
        return this.myAllocationStacks.values().stream().map(CallStack::getAllocationStack).collect(Collectors.toList());
    }

    public List<MemoryProfiler.AllocatedClass> getClassNames() {
        return this.myAllocatedClasses.values().stream().map(ClassName::getAllocatedClass).collect(Collectors.toList());
    }

    public static class Allocation {
        private final int myClassId;
        private final int mySize;
        private final int myThreadId;
        private final int myCallStackId;

        public Allocation(int classId, int size, int threadId, @NotNull int callStackId) {
            this.myClassId = classId;
            this.mySize = size;
            this.myThreadId = threadId;
            this.myCallStackId = callStackId;
        }

        @NotNull
        public MemoryProfiler.LegacyAllocationEvent bindAllocationEventInfos(long startTime, long endTime) {
            return MemoryProfiler.LegacyAllocationEvent.newBuilder().setClassId(this.myClassId).setSize(this.mySize).setThreadId(this.myThreadId).setCaptureTime(startTime).setTimestamp(endTime).setStackId(this.myCallStackId).build();
        }
    }

    public static class ClassName {
        private final String myClassName;
        private final int myClassId;

        public ClassName(@NotNull String className, int classId) {
            this.myClassName = className;
            this.myClassId = classId;
        }

        @NotNull
        public MemoryProfiler.AllocatedClass getAllocatedClass() {
            return MemoryProfiler.AllocatedClass.newBuilder().setClassName(this.myClassName).setClassId(this.myClassId).build();
        }
    }

    public static class CallStack {
        @NotNull
        private final List<StackTraceElement> myCallStackFrames;

        public CallStack(@NotNull List<StackTraceElement> frames) {
            this.myCallStackFrames = frames;
        }

        public int hashCode() {
            return this.myCallStackFrames.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CallStack)) {
                return false;
            }
            return this.myCallStackFrames.equals(((CallStack)obj).myCallStackFrames);
        }

        @NotNull
        public MemoryProfiler.AllocationStack getAllocationStack() {
            MemoryProfiler.AllocationStack.Builder builder = MemoryProfiler.AllocationStack.newBuilder().setStackId(this.hashCode());
            MemoryProfiler.AllocationStack.StackFrameWrapper.Builder frameBuilder = MemoryProfiler.AllocationStack.StackFrameWrapper.newBuilder();
            for (StackTraceElement frame : this.myCallStackFrames) {
                frameBuilder.addFrames(MemoryProfiler.AllocationStack.StackFrame.newBuilder().setClassName(frame.getClassName()).setMethodName(frame.getMethodName()).setFileName(frame.getFileName()).setLineNumber(frame.getLineNumber()).build());
            }
            builder.setFullStack(frameBuilder);
            return builder.build();
        }
    }
}

