/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.run.ExecutorIconProvider;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfileRunExecutor
extends DefaultRunExecutor
implements ExecutorIconProvider {
    @NonNls
    public static final String EXECUTOR_ID = "Android Profiler";

    @NotNull
    public Icon getIcon() {
        return StudioIcons.Shell.Toolbar.PROFILER;
    }

    public Icon getDisabledIcon() {
        return StudioIcons.Shell.ToolWindows.ANDROID_PROFILER;
    }

    public String getDescription() {
        return "Profile selected configuration";
    }

    @NotNull
    public String getActionName() {
        return "Profile";
    }

    @NotNull
    public String getId() {
        return EXECUTOR_ID;
    }

    @NotNull
    public String getStartActionText() {
        return "Profile";
    }

    public String getContextActionId() {
        return "ProfileRunClass";
    }

    public String getHelpId() {
        return null;
    }

    public static Executor getProfileExecutorInstance() {
        return ExecutorRegistry.getInstance().getExecutorById(EXECUTOR_ID);
    }

    @Override
    @Nullable
    public Icon getExecutorIcon(@NotNull Project project, @NotNull Executor executor) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(EXECUTOR_ID);
        if (toolWindow != null && toolWindow.getContentManager().getContentCount() > 0) {
            return ExecutionUtil.getLiveIndicator((Icon)this.getIcon());
        }
        return this.getIcon();
    }
}

