/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.idea.profilers.StudioProfilerDeviceManager;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.profilers.ProfilerClient;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

public class ProfilerService
implements Disposable {
    private static final String DATASTORE_NAME = "DataStoreService";
    @NotNull
    private final StudioProfilerDeviceManager myManager;
    @NotNull
    private final ProfilerClient myClient;

    public static ProfilerService getInstance(@NotNull Project project) {
        ProfilerService service = (ProfilerService)ServiceManager.getService(ProfilerService.class);
        service.myManager.initialize(project);
        return service;
    }

    private ProfilerService() {
        String datastoreDirectory = Paths.get(System.getProperty("user.home"), ".android").toString() + File.separator;
        DataStoreService dataStoreService = new DataStoreService(DATASTORE_NAME, datastoreDirectory, arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0));
        this.myManager = new StudioProfilerDeviceManager(dataStoreService);
        this.myClient = new ProfilerClient(DATASTORE_NAME);
        IdeSdks.subscribe(this.myManager, this);
    }

    public void dispose() {
        this.myManager.dispose();
    }

    @NotNull
    public ProfilerClient getProfilerClient() {
        return this.myClient;
    }
}

