/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.AllocationsParser;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.datastore.poller.MemoryDataPoller;
import com.android.tools.idea.profilers.LegacyAllocationConverter;
import com.android.tools.idea.profilers.LegacyAllocationTracker;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class StudioLegacyAllocationTracker
implements LegacyAllocationTracker {
    private IDevice myDevice;
    private Client myClient;
    private final LegacyAllocationConverter myConverter = new LegacyAllocationConverter();
    private boolean myOngoingTracking;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryDataPoller.class);
    }

    public StudioLegacyAllocationTracker(@NotNull IDevice device, int processId) {
        this.myDevice = device;
        this.myClient = this.getClient(processId);
        if (this.myClient == null) {
            StudioLegacyAllocationTracker.getLogger().info("StudioLegacyAllocationTracker unable to find application with process Id: " + processId);
        }
    }

    @Override
    public boolean trackAllocations(long startTime, long endTime, boolean enabled, Executor executor, LegacyAllocationTracker.LegacyAllocationTrackingCallback allocationConsumer) {
        if (this.myClient == null) {
            return false;
        }
        if (enabled == this.myOngoingTracking) {
            return false;
        }
        this.myOngoingTracking = enabled;
        if (!enabled) {
            assert (executor != null);
            this.getAllocationTrackingDump(executor, data -> {
                assert (allocationConsumer != null);
                if (data == null) {
                    allocationConsumer.accept(null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
                } else {
                    LegacyAllocationConverter converter = this.parseDump((byte[])data);
                    allocationConsumer.accept((byte[])data, converter.getClassNames(), converter.getAllocationStacks(), converter.getAllocationEvents(startTime, endTime));
                }
            });
        }
        this.myClient.enableAllocationTracker(enabled);
        return true;
    }

    private void getAllocationTrackingDump(final @NotNull Executor executor, final @NotNull Consumer<byte[]> consumer) {
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)new AndroidDebugBridge.IClientChangeListener(){

            public void clientChanged(Client client, int changeMask) {
                if (StudioLegacyAllocationTracker.this.myClient == client && (changeMask & 0x200) != 0) {
                    byte[] data = client.getClientData().getAllocationsData();
                    executor.execute(() -> consumer.accept(data));
                    AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
                }
            }
        });
        this.myClient.requestAllocationDetails();
    }

    @NotNull
    private LegacyAllocationConverter parseDump(@NotNull byte[] dumpData) {
        AllocationInfo[] rawInfos;
        this.myConverter.prepare();
        for (AllocationInfo info : rawInfos = AllocationsParser.parse((ByteBuffer)ByteBuffer.wrap(dumpData))) {
            List<StackTraceElement> stackTraceElements = Arrays.asList(info.getStackTrace());
            LegacyAllocationConverter.CallStack callStack = this.myConverter.addCallStack(stackTraceElements);
            int classId = this.myConverter.addClassName(info.getAllocatedClass());
            this.myConverter.addAllocation(new LegacyAllocationConverter.Allocation(classId, info.getSize(), info.getThreadId(), callStack.hashCode()));
        }
        return this.myConverter;
    }

    private Client getClient(int processId) {
        if (!this.myDevice.isOnline()) {
            return null;
        }
        return this.myDevice.getClient(this.myDevice.getClientName(processId));
    }
}

