/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.actions;

import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class NavigateToCodeAction
extends AnAction {
    @NotNull
    private final Supplier<CodeLocation> myLocationSupplier;
    @NotNull
    private final CodeNavigator myCodeNavigator;

    public NavigateToCodeAction(@NotNull Supplier<CodeLocation> locationSupplier, @NotNull CodeNavigator codeNavigator) {
        this.myLocationSupplier = locationSupplier;
        this.myCodeNavigator = codeNavigator;
        String title = ActionsBundle.actionText((String)"EditSource");
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(title);
        presentation.setIcon(AllIcons.Actions.EditSource);
        presentation.setDescription(ActionsBundle.actionDescription((String)"EditSource"));
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(this.myLocationSupplier.get() != null);
    }

    public void actionPerformed(AnActionEvent e) {
        CodeLocation location = this.myLocationSupplier.get();
        if (location != null) {
            this.myCodeNavigator.navigate(location);
        }
    }
}

