/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfd;

import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public abstract class PerfdProxyService {
    private final ServiceDescriptor myServiceDescriptor;

    public PerfdProxyService(@NotNull ServiceDescriptor serviceDescriptor) {
        this.myServiceDescriptor = serviceDescriptor;
    }

    public abstract ServerServiceDefinition getServiceDefinition();

    public void disconnect() {
    }

    final ServerServiceDefinition generatePassThroughDefinitions(@NotNull Map<MethodDescriptor, ServerCallHandler> overrides, @NotNull AbstractStub blockingStub) {
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((ServiceDescriptor)this.myServiceDescriptor);
        overrides.forEach((method, handler) -> builder.addMethod(method, handler));
        this.myServiceDescriptor.getMethods().forEach(descriptor -> {
            if (overrides.containsKey(descriptor)) {
                return;
            }
            switch (descriptor.getType()) {
                case UNARY: {
                    builder.addMethod(descriptor, ServerCalls.asyncUnaryCall((request, observer) -> this.invokeAsyncUnaryCalls((MethodDescriptor)descriptor, blockingStub, (Object)request, (StreamObserver)observer)));
                    break;
                }
                case CLIENT_STREAMING: 
                case SERVER_STREAMING: 
                case BIDI_STREAMING: 
                case UNKNOWN: {
                    throw new NotImplementedException();
                }
            }
        });
        return builder.build();
    }

    private <Req, Resp> void invokeAsyncUnaryCalls(@NotNull MethodDescriptor descriptor, @NotNull AbstractStub stubInstance, Req request, @NotNull StreamObserver<Resp> observer) {
        ClientCalls.asyncUnaryCall((ClientCall)stubInstance.getChannel().newCall(descriptor, stubInstance.getCallOptions()), request, observer);
    }
}

