/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfd;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.profilers.perfd.PerfdProxyService;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ProfilerServiceProxy
extends PerfdProxyService
implements AndroidDebugBridge.IClientChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    private static final String EMULATOR = "Emulator";
    private final ProfilerServiceGrpc.ProfilerServiceBlockingStub myServiceStub;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final Profiler.Device myProfilerDevice;
    private final Map<Client, Profiler.Process> myCachedProcesses = Collections.synchronizedMap(new HashMap());
    private final boolean myIsDeviceApiSupported;

    private static Logger getLog() {
        return Logger.getInstance(ProfilerServiceProxy.class);
    }

    public ProfilerServiceProxy(@NotNull IDevice device, @NotNull ManagedChannel channel) {
        super(ProfilerServiceGrpc.getServiceDescriptor());
        this.myIsDeviceApiSupported = device.getVersion().getApiLevel() >= 21;
        this.myDevice = device;
        this.myServiceStub = ProfilerServiceGrpc.newBlockingStub((Channel)channel);
        if (this.myIsDeviceApiSupported) {
            Profiler.GetDevicesResponse devices = this.myServiceStub.getDevices(Profiler.GetDevicesRequest.getDefaultInstance());
            assert (devices.getDeviceList().size() == 1);
            this.myProfilerDevice = ProfilerServiceProxy.profilerDeviceFromIDevice(device, devices.getDevice(0).toBuilder());
        } else {
            this.myProfilerDevice = ProfilerServiceProxy.profilerDeviceFromIDevice(device, Profiler.Device.newBuilder().setBootId(String.valueOf(device.getSerialNumber().hashCode())));
        }
        this.updateProcesses();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
    }

    private static Profiler.Device profilerDeviceFromIDevice(IDevice device, Profiler.Device.Builder builder) {
        return builder.setSerial(device.getSerialNumber()).setModel(ProfilerServiceProxy.getDeviceModel(device)).setVersion(StringUtil.notNullize((String)device.getProperty("ro.build.version.release"))).setCodename(StringUtil.notNullize((String)device.getVersion().getCodename())).setApiLevel(device.getVersion().getApiLevel()).setFeatureLevel(device.getVersion().getFeatureLevel()).setManufacturer(DevicePropertyUtil.getManufacturer(device, device.isEmulator() ? EMULATOR : "")).setIsEmulator(device.isEmulator()).setState(ProfilerServiceProxy.convertState(device.getState())).build();
    }

    public static Profiler.Device profilerDeviceFromIDevice(IDevice device) {
        return ProfilerServiceProxy.profilerDeviceFromIDevice(device, Profiler.Device.newBuilder());
    }

    private static Profiler.Device.State convertState(IDevice.DeviceState state) {
        switch (state) {
            case OFFLINE: {
                return Profiler.Device.State.OFFLINE;
            }
            case ONLINE: {
                return Profiler.Device.State.ONLINE;
            }
            case DISCONNECTED: {
                return Profiler.Device.State.DISCONNECTED;
            }
        }
        return Profiler.Device.State.UNSPECIFIED;
    }

    private static String getDeviceModel(@NotNull IDevice device) {
        return device.isEmulator() ? StringUtil.notNullize((String)device.getAvdName(), (String)"Unknown") : DevicePropertyUtil.getModel(device, "Unknown");
    }

    @Override
    public void disconnect() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
    }

    public void getDevices(Profiler.GetDevicesRequest request, StreamObserver<Profiler.GetDevicesResponse> responseObserver) {
        Profiler.GetDevicesResponse response = Profiler.GetDevicesResponse.newBuilder().addDevice(this.myProfilerDevice).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getCurrentTime(Profiler.TimeRequest request, StreamObserver<Profiler.TimeResponse> responseObserver) {
        Profiler.TimeResponse response = this.myIsDeviceApiSupported ? this.myServiceStub.getCurrentTime(request) : Profiler.TimeResponse.getDefaultInstance();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getProcesses(Profiler.GetProcessesRequest request, StreamObserver<Profiler.GetProcessesResponse> responseObserver) {
        Profiler.GetProcessesResponse response = Profiler.GetProcessesResponse.newBuilder().addAllProcess(this.myCachedProcesses.values()).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceDisconnected(IDevice device) {
    }

    public void deviceChanged(IDevice device, int changeMask) {
        if (device == this.myDevice && (changeMask & 2) != 0) {
            this.updateProcesses();
        }
    }

    public void clientChanged(Client client, int changeMask) {
        if ((changeMask & 1) != 0 && client.getDevice() == this.myDevice && client.getClientData().getClientDescription() != null) {
            this.updateProcesses(Collections.singletonList(client));
        }
    }

    @Override
    public ServerServiceDefinition getServiceDefinition() {
        HashMap overrides = Maps.newHashMap();
        overrides.put(ProfilerServiceGrpc.METHOD_GET_DEVICES, ServerCalls.asyncUnaryCall((request, observer) -> this.getDevices((Profiler.GetDevicesRequest)request, (StreamObserver<Profiler.GetDevicesResponse>)observer)));
        overrides.put(ProfilerServiceGrpc.METHOD_GET_PROCESSES, ServerCalls.asyncUnaryCall((request, observer) -> this.getProcesses((Profiler.GetProcessesRequest)request, (StreamObserver<Profiler.GetProcessesResponse>)observer)));
        overrides.put(ProfilerServiceGrpc.METHOD_GET_CURRENT_TIME, ServerCalls.asyncUnaryCall((request, observer) -> this.getCurrentTime((Profiler.TimeRequest)request, (StreamObserver<Profiler.TimeResponse>)observer)));
        return this.generatePassThroughDefinitions(overrides, (AbstractStub)this.myServiceStub);
    }

    private void updateProcesses() {
        if (!this.myIsDeviceApiSupported) {
            return;
        }
        Set updatedClients = Arrays.stream(this.myDevice.getClients()).filter(c -> c.getClientData().getClientDescription() != null).collect(Collectors.toSet());
        Set<Client> existingClients = this.myCachedProcesses.keySet();
        ImmutableSet removedClients = Sets.difference(existingClients, updatedClients).immutableCopy();
        ImmutableSet addedClients = Sets.difference(updatedClients, existingClients).immutableCopy();
        if (!addedClients.isEmpty()) {
            this.updateProcesses((Collection<Client>)addedClients);
        }
        for (Client client : removedClients) {
            this.myCachedProcesses.remove(client);
        }
    }

    private void updateProcesses(@NotNull Collection<Client> clients) {
        Profiler.TimeResponse times;
        if (!this.myIsDeviceApiSupported) {
            return;
        }
        assert (this.myDevice.isOnline());
        try {
            times = this.myServiceStub.getCurrentTime(Profiler.TimeRequest.getDefaultInstance());
        }
        catch (Exception e) {
            ProfilerServiceProxy.getLog().info((Throwable)e);
            return;
        }
        for (Client client : clients) {
            String description = client.getClientData().getClientDescription();
            if (description == null) continue;
            String abi = client.getClientData().getAbi();
            String abiCpuArch = abi != null && abi.contains(")") ? abi.substring(abi.indexOf("(") + 1, abi.indexOf(")")) : Abi.getEnum((String)((String)this.myDevice.getAbis().get(0))).getCpuArch();
            this.myCachedProcesses.put(client, Profiler.Process.newBuilder().setName(client.getClientData().getClientDescription()).setPid(client.getClientData().getPid()).setState(Profiler.Process.State.ALIVE).setStartTimestampNs(times.getTimestampNs()).setAbiCpuArch(abiCpuArch).build());
        }
    }

    @NotNull
    Map<Client, Profiler.Process> getCachedProcesses() {
        return this.myCachedProcesses;
    }
}

