/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.stacktrace;

import com.android.tools.idea.profilers.stacktrace.CodeElement;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntelliJCodeElement
implements CodeElement {
    private static final VirtualFile UNRESOLVED_CLASS_FILE = new StubVirtualFile();
    @NotNull
    private final Project myProject;
    @NotNull
    private final CodeLocation myCodeLocation;
    @NotNull
    private String myPackageName;
    @NotNull
    private String mySimpleClassName;
    @Nullable
    private VirtualFile myCachedClassFile = UNRESOLVED_CLASS_FILE;

    public IntelliJCodeElement(@NotNull Project project, @NotNull CodeLocation codeLocation) {
        this.myProject = project;
        this.myCodeLocation = codeLocation;
        String className = this.myCodeLocation.getClassName();
        if (className == null) {
            this.myPackageName = "<unknown package>";
            this.mySimpleClassName = "<unkonwn class>";
        } else {
            int dot = className.lastIndexOf(46);
            this.myPackageName = dot <= 0 ? "<no package>" : className.substring(0, dot);
            this.mySimpleClassName = dot + 1 < className.length() ? className.substring(dot + 1) : "<unkonwn class>";
        }
    }

    @Override
    @NotNull
    public CodeLocation getCodeLocation() {
        return this.myCodeLocation;
    }

    @Override
    @NotNull
    public String getPackageName() {
        return this.myPackageName;
    }

    @Override
    @NotNull
    public String getSimpleClassName() {
        return this.mySimpleClassName;
    }

    @Override
    @NotNull
    public String getMethodName() {
        return this.myCodeLocation.getMethodName() == null ? "<unknown method>" : this.myCodeLocation.getMethodName();
    }

    @Override
    public boolean isInUserCode() {
        VirtualFile classFile = this.findClassFile();
        return classFile != null && ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isInSource(classFile);
    }

    @Nullable
    VirtualFile findClassFile() {
        PsiClass psiClass;
        if (this.myCachedClassFile != UNRESOLVED_CLASS_FILE) {
            return this.myCachedClassFile;
        }
        String className = this.myCodeLocation.getClassName();
        if (className == null) {
            this.myCachedClassFile = null;
            return null;
        }
        int innerClassSymboldIndex = className.indexOf(36);
        if (innerClassSymboldIndex > 0) {
            className = className.substring(0, innerClassSymboldIndex);
        }
        if ((psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(className, GlobalSearchScope.allScope((Project)this.myProject))) == null) {
            this.myCachedClassFile = null;
            return null;
        }
        this.myCachedClassFile = psiClass.getContainingFile().getVirtualFile();
        return this.myCachedClassFile;
    }
}

