/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.stacktrace;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.idea.profilers.stacktrace.CodeElement;
import com.android.tools.idea.profilers.stacktrace.IntelliJCodeElement;
import com.android.tools.idea.profilers.stacktrace.StackElement;
import com.android.tools.idea.profilers.stacktrace.ThreadElement;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.StackTraceModel;
import com.android.tools.profilers.stacktrace.StackTraceView;
import com.android.tools.profilers.stacktrace.ThreadId;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class IntelliJStackTraceView
extends AspectObserver
implements StackTraceView {
    @NotNull
    private final Project myProject;
    @NotNull
    private final StackTraceModel myModel;
    @NotNull
    private final BiFunction<Project, CodeLocation, CodeElement> myGenerator;
    @NotNull
    private final JBScrollPane myScrollPane;
    @NotNull
    private final DefaultListModel<StackElement> myListModel;
    @NotNull
    private final JBList myListView;

    public IntelliJStackTraceView(@NotNull Project project, @NotNull StackTraceModel model) {
        this(project, model, IntelliJCodeElement::new);
    }

    @VisibleForTesting
    IntelliJStackTraceView(@NotNull Project project, @NotNull StackTraceModel model, @NotNull BiFunction<Project, CodeLocation, CodeElement> stackNavigationGenerator) {
        this.myProject = project;
        this.myModel = model;
        this.myGenerator = stackNavigationGenerator;
        this.myListModel = new DefaultListModel();
        this.myListView = new JBList(this.myListModel);
        this.myListView.setSelectionMode(0);
        this.myListView.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myListView.setCellRenderer((ListCellRenderer)((Object)new StackElementRenderer()));
        this.myScrollPane = new JBScrollPane((Component)this.myListView);
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.setVerticalScrollBarPolicy(20);
        this.myListView.addListSelectionListener(e -> {
            if (this.myListView.getSelectedValue() == null) {
                this.myModel.clearSelection();
            }
        });
        final Supplier<Boolean> navigationHandler = () -> {
            int index = this.myListView.getSelectedIndex();
            if (index >= 0 && index < this.myListView.getItemsCount()) {
                this.myModel.setSelectedIndex(index);
                return true;
            }
            return false;
        };
        this.myListView.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = KeyEvent.getExtendedKeyCodeForChar(e.getKeyChar());
                if (keyCode == 10 && ((Boolean)navigationHandler.get()).booleanValue()) {
                    e.consume();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                return (Boolean)navigationHandler.get();
            }
        }.installOn((Component)this.myListView);
        this.myModel.addDependency((AspectObserver)this).onChange((Enum)StackTraceModel.Aspect.STACK_FRAMES, () -> {
            List stackFrames = this.myModel.getCodeLocations();
            this.myListModel.removeAllElements();
            this.myListView.clearSelection();
            stackFrames.forEach(stackFrame -> this.myListModel.addElement(this.myGenerator.apply(this.myProject, (CodeLocation)stackFrame)));
            ThreadId threadId = this.myModel.getThreadId();
            if (!threadId.equals((Object)ThreadId.INVALID_THREAD_ID)) {
                this.myListModel.addElement(new ThreadElement(threadId));
            }
        }).onChange((Enum)StackTraceModel.Aspect.SELECTED_LOCATION, () -> {
            int index = this.myModel.getSelectedIndex();
            if (this.myModel.getSelectedType() == StackTraceModel.Type.INVALID) {
                if (this.myListView.getSelectedIndex() != -1) {
                    this.myListView.clearSelection();
                }
            } else if (index >= 0 && index < this.myListView.getItemsCount()) {
                if (this.myListView.getSelectedIndex() != index) {
                    this.myListView.setSelectedIndex(index);
                }
            } else {
                throw new IndexOutOfBoundsException("View has " + this.myListView.getItemsCount() + " elements while aspect is changing to index " + index);
            }
        });
    }

    @NotNull
    public StackTraceModel getModel() {
        return this.myModel;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myScrollPane;
    }

    @VisibleForTesting
    @NotNull
    JBList getListView() {
        return this.myListView;
    }

    private static final class StackElementRenderer
    extends ColoredListCellRenderer<StackElement> {
        private StackElementRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list, StackElement value, int index, boolean selected, boolean hasFocus) {
            if (UIUtil.isUnderGTKLookAndFeel()) {
                Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                UIUtil.changeBackGround((Component)((Object)this), (Color)background);
            }
            if (value == null) {
                return;
            }
            this.setIpad(ProfilerLayout.LIST_ROW_INSETS);
            if (value instanceof CodeElement) {
                this.renderStackNavigation((CodeElement)value, selected);
            } else if (value instanceof ThreadElement) {
                this.renderThreadElement((ThreadElement)value, selected);
            } else {
                this.append(value.toString(), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }

        private void renderStackNavigation(@NotNull CodeElement codeElement, boolean selected) {
            this.setIcon(PlatformIcons.METHOD_ICON);
            SimpleTextAttributes textAttribute = selected || codeElement.isInUserCode() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
            CodeLocation location = codeElement.getCodeLocation();
            StringBuilder methodBuilder = new StringBuilder(codeElement.getMethodName());
            if (location.getLineNumber() != -1) {
                methodBuilder.append(":");
                methodBuilder.append(location.getLineNumber() + 1);
            }
            methodBuilder.append(", ");
            methodBuilder.append(codeElement.getSimpleClassName());
            String methodName = methodBuilder.toString();
            this.append(methodName, textAttribute, methodName);
            String packageName = " (" + codeElement.getPackageName() + ")";
            this.append(packageName, selected ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES, packageName);
        }

        private void renderThreadElement(@NotNull ThreadElement threadElement, boolean selected) {
            this.setIcon(AllIcons.Debugger.ThreadSuspended);
            String text = threadElement.getThreadId().toString();
            this.append(text, selected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES, text);
        }
    }
}

