/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.stacktrace;

import com.android.tools.idea.profilers.TraceSignatureConverter;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.ClassUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntellijCodeNavigator
extends CodeNavigator {
    private final Project myProject;

    public IntellijCodeNavigator(@NotNull Project project, @NotNull FeatureTracker featureTracker) {
        super(featureTracker);
        this.myProject = project;
    }

    protected void handleNavigate(@NotNull CodeLocation location) {
        Navigatable nav = this.getNavigatable(location);
        if (nav != null) {
            nav.navigate(true);
        }
    }

    @Nullable
    private Navigatable getNavigatable(@NotNull CodeLocation location) {
        PsiClass psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)location.getClassName());
        if (psiClass == null && location.getLineNumber() >= 0) {
            psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)location.getOuterClassName());
        }
        if (psiClass == null) {
            return null;
        }
        if (location.getLineNumber() >= 0) {
            return new OpenFileDescriptor(this.myProject, psiClass.getNavigationElement().getContainingFile().getVirtualFile(), location.getLineNumber(), 0);
        }
        if (location.getMethodName() != null && location.getSignature() != null) {
            PsiMethod method = IntellijCodeNavigator.findMethod(psiClass, location.getMethodName(), location.getSignature());
            return method != null ? method : psiClass;
        }
        return psiClass;
    }

    @Nullable
    private static PsiMethod findMethod(@NotNull PsiClass psiClass, @NotNull String methodName, @NotNull String signature) {
        for (PsiMethod method : psiClass.findMethodsByName(methodName, true)) {
            if (!signature.equals(TraceSignatureConverter.getTraceSignature(method))) continue;
            return method;
        }
        return null;
    }
}

