/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.apk.ApkFacet;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectInfo {
    @NotNull
    private final Project myProject;

    @NotNull
    public static AndroidProjectInfo getInstance(@NotNull Project project) {
        return (AndroidProjectInfo)ServiceManager.getService((Project)project, AndroidProjectInfo.class);
    }

    public AndroidProjectInfo(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<Module> getAllModulesOfProjectType(int projectType) {
        return Stream.of(ModuleManager.getInstance((Project)this.myProject).getModules()).filter(module -> {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            return facet != null && facet.getProjectType() == projectType;
        }).collect(Collectors.toList());
    }

    public boolean requiresAndroidModel() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet == null || !androidFacet.requiresAndroidModel()) continue;
            return true;
        }
        return false;
    }

    public boolean isApkProject() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            if (ApkFacet.getInstance(module) == null) continue;
            return true;
        }
        return false;
    }

    public boolean requiredAndroidModelMissing() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || !facet.requiresAndroidModel() || facet.getAndroidModel() != null) continue;
            return true;
        }
        return false;
    }

    public boolean isLegacyIdeaAndroidProject() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            if (!AndroidProjectInfo.isLegacyIdeaAndroidModule(module)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLegacyIdeaAndroidModule(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null && !facet.requiresAndroidModel();
    }
}

