/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class IndexingSuspender
extends DumbModeTask {
    private static final Logger LOG = Logger.getInstance(GradleBuildState.class);
    @NotNull
    private final Object myIndexingLock;
    @NotNull
    private final String myContextDescription;
    @NotNull
    private final Supplier<Boolean> myShouldWait;
    private final int myWaitTimeoutMillis;

    public static void queue(@NotNull Project project, @NotNull String contextDescription, @NotNull Object indexingLock, @NotNull Supplier<Boolean> shouldWait, int waitTimeoutMillis) {
        DumbService.getInstance((Project)project).queueTask((DumbModeTask)new IndexingSuspender(contextDescription, indexingLock, shouldWait, waitTimeoutMillis));
    }

    private IndexingSuspender(@NotNull String contextDescription, @NotNull Object indexingLock, @NotNull Supplier<Boolean> shouldWait, int waitTimeoutMillis) {
        this.myContextDescription = contextDescription;
        this.myIndexingLock = indexingLock;
        this.myShouldWait = shouldWait;
        this.myWaitTimeoutMillis = waitTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
        String message = String.format("Indexing suspended (context: %1$s)", this.myContextDescription);
        LOG.info(message);
        indicator.setText(message);
        Object object = this.myIndexingLock;
        synchronized (object) {
            while (this.myShouldWait.get().booleanValue()) {
                try {
                    this.myIndexingLock.wait(this.myWaitTimeoutMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        LOG.info(String.format("Indexing released (context: %1$s)", this.myContextDescription));
    }
}

