/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project.messages;

import com.android.tools.idea.gradle.notification.QuickFixNotificationListener;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.SyncMessage;
import com.intellij.ide.errorTreeView.NewEditableErrorTreeViewPanel;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.MessageView;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSyncMessages {
    private static final NotificationSource NOTIFICATION_SOURCE = NotificationSource.PROJECT_SYNC;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalSystemNotificationManager myNotificationManager;

    protected AbstractSyncMessages(@NotNull Project project, @NotNull ExternalSystemNotificationManager manager) {
        this.myProject = project;
        this.myNotificationManager = manager;
    }

    public int getErrorCount() {
        return this.getMessageCount(NotificationCategory.ERROR);
    }

    public int getMessageCount(@NotNull String groupName) {
        return this.myNotificationManager.getMessageCount(groupName, NOTIFICATION_SOURCE, null, this.getProjectSystemId());
    }

    public boolean isEmpty() {
        return this.getMessageCount((NotificationCategory)null) == 0;
    }

    private int getMessageCount(@Nullable NotificationCategory category) {
        return this.myNotificationManager.getMessageCount(NOTIFICATION_SOURCE, category, this.getProjectSystemId());
    }

    public void removeMessages(String ... groupNames) {
        for (String groupName : groupNames) {
            this.myNotificationManager.clearNotifications(groupName, NOTIFICATION_SOURCE, this.getProjectSystemId());
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
        if (toolWindow != null) {
            MessageView messageView = (MessageView)ServiceManager.getService((Project)this.myProject, MessageView.class);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                NewEditableErrorTreeViewPanel messagesView = this.findMessagesView(messageView);
                if (messagesView != null) {
                    messagesView.updateTree();
                }
            });
        }
    }

    @Nullable
    private NewEditableErrorTreeViewPanel findMessagesView(@NotNull MessageView messageView) {
        NewEditableErrorTreeViewPanel messagesView = null;
        for (Content content : messageView.getContentManager().getContents()) {
            JComponent component2;
            String displayName;
            if (content.isPinned() || (displayName = content.getDisplayName()) == null || !displayName.startsWith(this.getProjectSystemId().getReadableName()) || !((component2 = content.getComponent()) instanceof NewEditableErrorTreeViewPanel)) continue;
            messagesView = (NewEditableErrorTreeViewPanel)component2;
            break;
        }
        return messagesView;
    }

    public void report(@NotNull SyncMessage message) {
        String title = message.getGroup();
        String text = StringUtil.join((String[])message.getText(), (String)"\n");
        NotificationCategory category = message.getType().convertToCategory();
        PositionInFile position = message.getPosition();
        NotificationData notification = this.createNotification(title, text, category, position);
        Navigatable navigatable = message.getNavigatable();
        notification.setNavigatable(navigatable);
        List<NotificationHyperlink> quickFixes = message.getQuickFixes();
        if (!quickFixes.isEmpty()) {
            this.updateNotification(notification, text, quickFixes);
        }
        this.report(notification);
    }

    @NotNull
    public NotificationData createNotification(@NotNull String title, @NotNull String text, @NotNull NotificationCategory category, @Nullable PositionInFile position) {
        NotificationSource source = NotificationSource.PROJECT_SYNC;
        if (position != null) {
            String filePath = VfsUtilCore.virtualToIoFile((VirtualFile)position.file).getPath();
            return new NotificationData(title, text, category, source, filePath, position.line, position.column, false);
        }
        return new NotificationData(title, text, category, source);
    }

    public void updateNotification(@NotNull NotificationData notification, @NotNull String text, @NotNull List<NotificationHyperlink> quickFixes) {
        String message = text;
        int hyperlinkCount = quickFixes.size();
        if (hyperlinkCount > 0) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < hyperlinkCount; ++i) {
                b.append(quickFixes.get(i).toHtml());
                if (i >= hyperlinkCount - 1) continue;
                b.append("<br>");
            }
            message = message + '\n' + b.toString();
        }
        notification.setMessage(message);
        this.addNotificationListener(notification, quickFixes);
    }

    public void addNotificationListener(@NotNull NotificationData notification, @NotNull List<NotificationHyperlink> quickFixes) {
        for (NotificationHyperlink quickFix : quickFixes) {
            notification.setListener(quickFix.getUrl(), (NotificationListener)new QuickFixNotificationListener(this.myProject, quickFix));
        }
    }

    public void report(@NotNull NotificationData notification) {
        this.myNotificationManager.showNotification(this.getProjectSystemId(), notification);
    }

    @NotNull
    protected abstract ProjectSystemId getProjectSystemId();

    @NotNull
    protected Project getProject() {
        return this.myProject;
    }
}

