/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project.messages;

import com.android.tools.idea.gradle.util.PositionInFile;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncMessage {
    public static final String DEFAULT_GROUP = "Gradle Sync Issues";
    @NotNull
    private final String myGroup;
    @NotNull
    private final MessageType myType;
    @NotNull
    private final String[] myText;
    @NotNull
    private final Navigatable myNavigatable;
    @Nullable
    private final PositionInFile myPosition;
    @NotNull
    private final List<NotificationHyperlink> myQuickFixes = new ArrayList<NotificationHyperlink>();

    public SyncMessage(@NotNull String group, @NotNull MessageType type, String ... text) {
        this(group, type, NonNavigatable.INSTANCE, text);
    }

    public SyncMessage(@NotNull Project project, @NotNull String group, @NotNull MessageType type, @NotNull PositionInFile position, String ... text) {
        this(group, type, (Navigatable)new OpenFileDescriptor(project, position.file, position.line, position.column), text, position);
    }

    public SyncMessage(@NotNull String group, @NotNull MessageType type, @NotNull Navigatable navigatable, String ... text) {
        this(group, type, navigatable, text, (PositionInFile)null);
    }

    private SyncMessage(@NotNull String group, @NotNull MessageType type, @NotNull Navigatable navigatable, @NotNull String[] text, @Nullable PositionInFile position) {
        this.myGroup = group;
        this.myType = type;
        this.myNavigatable = navigatable;
        this.myText = text;
        this.myPosition = position;
    }

    @NotNull
    public String getGroup() {
        return this.myGroup;
    }

    @NotNull
    public MessageType getType() {
        return this.myType;
    }

    @NotNull
    public String[] getText() {
        return this.myText;
    }

    @NotNull
    public Navigatable getNavigatable() {
        return this.myNavigatable;
    }

    @Nullable
    public PositionInFile getPosition() {
        return this.myPosition;
    }

    public void add(@NotNull Collection<NotificationHyperlink> quickFixes) {
        for (NotificationHyperlink quickFix : quickFixes) {
            this.add(quickFix);
        }
    }

    public void add(@NotNull NotificationHyperlink quickFix) {
        this.myQuickFixes.add(quickFix);
    }

    @NotNull
    public List<NotificationHyperlink> getQuickFixes() {
        return ImmutableList.copyOf(this.myQuickFixes);
    }

    @NotNull
    public String toString() {
        return Joiner.on((char)'\n').join((Object[])this.myText);
    }
}

