/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.refactoring.modularize.AndroidModularizeHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModularizeAction
extends BaseRefactoringAction {
    protected boolean isAvailableInEditorOnly() {
        return false;
    }

    protected boolean isAvailableForFile(PsiFile file) {
        return file != null && file.getFileType() == StdFileTypes.JAVA;
    }

    protected boolean isEnabledOnDataContext(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && GradleSyncState.getInstance(project).lastSyncFailedOrHasIssues()) {
            return false;
        }
        for (PsiElement element : AndroidModularizeAction.getPsiElementArray((DataContext)dataContext)) {
            if (this.isAvailableForFile(element.getContainingFile())) continue;
            return false;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        return file == null || this.isAvailableForFile(file);
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        Project project = file.getProject();
        return !GradleSyncState.getInstance(project).lastSyncFailedOrHasIssues();
    }

    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        return false;
    }

    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        return new AndroidModularizeHandler();
    }
}

