/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.android.tools.idea.refactoring.modularize.AndroidModularizeProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.CollectionComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModularizeDialog
extends RefactoringDialog {
    private final List<Module> myTargetModules;
    private final AndroidModularizeProcessor myProcessor;
    private ComboBox<Module> myModuleCombo;

    protected AndroidModularizeDialog(@NotNull Project project, @NotNull List<Module> targetModules, AndroidModularizeProcessor processor) {
        super(project, true);
        this.myTargetModules = targetModules;
        this.myProcessor = processor;
        this.setTitle("Modularize");
        this.init();
    }

    protected void doAction() {
        this.myProcessor.setTargetModule((Module)this.myModuleCombo.getSelectedItem());
        this.myProcessor.setPreviewUsages(this.isPreviewUsages());
        this.close(0);
        this.myProcessor.run();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(String.format("Move %1$d classes and %2$d resources to:", this.myProcessor.getClassesCount(), this.myProcessor.getResourcesCount())), "North");
        CollectionComboBoxModel model = new CollectionComboBoxModel(this.myTargetModules);
        this.myModuleCombo = new ComboBox((ComboBoxModel)model);
        panel.add((Component)this.myModuleCombo, "Center");
        return panel;
    }
}

