/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.refactoring.modularize.AndroidCodeAndResourcesGraph;
import com.android.tools.idea.refactoring.modularize.AndroidModularizePreviewPanel;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.android.AndroidFileTemplateProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModularizeProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOGGER = Logger.getInstance(AndroidModularizeProcessor.class);
    private final PsiElement[] myRoots;
    private final Set<PsiClass> myClasses;
    private final Set<ResourceItem> myResources;
    private final Set<PsiElement> myManifestEntries;
    private final AndroidCodeAndResourcesGraph myReferenceGraph;
    private Module myTargetModule;
    private boolean myShouldSelectAllReferences;

    protected AndroidModularizeProcessor(@NotNull Project project, @NotNull PsiElement[] roots, @NotNull Set<PsiClass> classes, @NotNull Set<ResourceItem> resources, @NotNull Set<PsiElement> manifestEntries, @NotNull AndroidCodeAndResourcesGraph referenceGraph) {
        super(project);
        this.myRoots = roots;
        this.myClasses = classes;
        this.myResources = resources;
        this.myManifestEntries = manifestEntries;
        this.myReferenceGraph = referenceGraph;
    }

    public void setTargetModule(@NotNull Module module) {
        this.myTargetModule = module;
        this.myShouldSelectAllReferences = true;
        for (PsiElement root : this.myRoots) {
            AndroidFacet facet = AndroidFacet.getInstance(root);
            if (facet == null || AndroidModularizeProcessor.collectModulesClosure(facet.getModule(), Sets.newHashSet()).contains(this.myTargetModule)) continue;
            this.myShouldSelectAllReferences = false;
            break;
        }
    }

    private static Set<Module> collectModulesClosure(@NotNull Module module, Set<Module> result) {
        if (result.add(module)) {
            for (Module depModule : ModuleRootManager.getInstance((Module)module).getDependencies()) {
                AndroidModularizeProcessor.collectModulesClosure(depModule, result);
            }
        }
        return result;
    }

    public int getClassesCount() {
        return this.myClasses.size();
    }

    public int getResourcesCount() {
        return this.myResources.size();
    }

    AndroidCodeAndResourcesGraph getReferenceGraph() {
        return this.myReferenceGraph;
    }

    boolean shouldSelectAllReferences() {
        return this.myShouldSelectAllReferences;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(final @NotNull UsageInfo[] usages) {
        return new UsageViewDescriptor(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] result = new PsiElement[usages.length];
                for (int i = 0; i < usages.length; ++i) {
                    result[i] = usages[i].getElement();
                }
                return result;
            }

            public String getProcessedElementsHeader() {
                return "Items to be moved";
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return String.format("%1$d resources in %2$d files", usagesCount, filesCount);
            }

            @Nullable
            public String getCommentReferencesText(int usagesCount, int filesCount) {
                return null;
            }
        };
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (PsiElement psiElement : this.myClasses) {
            result.add(new UsageInfo(psiElement));
        }
        for (PsiElement psiElement : this.myManifestEntries) {
            result.add(new UsageInfo(psiElement));
        }
        for (ResourceItem resourceItem : this.myResources) {
            PsiFile psiFile = LocalResourceRepository.getItemPsiFile(this.myProject, resourceItem);
            if (ResourceHelper.getFolderType(psiFile) == ResourceFolderType.VALUES) {
                XmlTag xmlTag = LocalResourceRepository.getItemTag(this.myProject, resourceItem);
                if (xmlTag == null) continue;
                result.add(new ResourceXmlUsageInfo((PsiElement)xmlTag, resourceItem));
                continue;
            }
            if (psiFile instanceof PsiBinaryFile) {
                SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
                SmartPsiElementPointer smartPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)psiFile);
                SmartPsiFileRange smartFileRange = smartPointerManager.createSmartPsiFileRangePointer(psiFile, TextRange.EMPTY_RANGE);
                result.add(new ResourceXmlUsageInfo(smartPointer, smartFileRange, resourceItem){

                    public boolean isValid() {
                        return true;
                    }

                    @Nullable
                    public Segment getSegment() {
                        return null;
                    }
                });
                continue;
            }
            if (psiFile == null) continue;
            result.add(new ResourceXmlUsageInfo((PsiElement)psiFile, resourceItem));
        }
        return UsageViewUtil.removeDuplicatedUsages((UsageInfo[])result.toArray(new UsageInfo[result.size()]));
    }

    protected void previewRefactoring(@NotNull UsageInfo[] usages) {
        PreviewDialog previewDialog = new PreviewDialog(this.myProject, this.myReferenceGraph, usages, this.myShouldSelectAllReferences);
        if (previewDialog.showAndGet()) {
            TransactionGuard.getInstance().submitTransactionAndWait(() -> this.execute(previewDialog.getSelectedUsages()));
        }
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        AndroidFacet facet = AndroidFacet.getInstance(this.myTargetModule);
        assert (facet != null);
        ArrayList javaSourceFolders = Lists.newArrayList();
        for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
            javaSourceFolders.addAll(provider.getJavaDirectories());
        }
        VirtualFile javaTargetDir = (VirtualFile)javaSourceFolders.get(0);
        VirtualFile resDir = facet.getAllResourceDirectories().get(0);
        ResourceFolderRepository repo = ResourceFolderRegistry.get(facet, resDir);
        final HashSet<XmlFile> touchedXmlFiles = new HashSet<XmlFile>();
        for (UsageInfo usage : usages) {
            final PsiElement element = usage.getElement();
            if (usage instanceof ResourceXmlUsageInfo) {
                XmlTag rootTag;
                XmlFile resourceFile;
                ResourceItem resource = ((ResourceXmlUsageInfo)usage).getResourceItem();
                if (element instanceof PsiFile) {
                    PsiDirectory targetDir = this.getOrCreateTargetDirectory(repo, resource);
                    if (targetDir == null || targetDir.findFile(((PsiFile)element).getName()) != null) continue;
                    MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)((PsiFile)element), (PsiDirectory)targetDir);
                    continue;
                }
                if (!(element instanceof XmlTag) || (resourceFile = (XmlFile)this.getOrCreateTargetValueFile(repo, resource)) == null || (rootTag = resourceFile.getRootTag()) == null || !"resources".equals(rootTag.getName())) continue;
                rootTag.addSubTag((XmlTag)element.copy(), false);
                element.delete();
                touchedXmlFiles.add(resourceFile);
                continue;
            }
            if (element instanceof XmlTag) {
                final XmlFile manifest = (XmlFile)this.getOrCreateTargetManifestFile(facet);
                if (manifest == null) continue;
                manifest.acceptChildren((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        if ("manifest".equals(tag.getName())) {
                            XmlTag applicationTag = null;
                            for (PsiElement child : tag.getChildren()) {
                                if (!(child instanceof XmlTag) || !"application".equals(((XmlTag)child).getName())) continue;
                                applicationTag = (XmlTag)child;
                                applicationTag.addSubTag((XmlTag)element.copy(), false);
                                element.delete();
                                break;
                            }
                            if (applicationTag == null) {
                                applicationTag = XmlElementFactory.getInstance((Project)AndroidModularizeProcessor.this.myProject).createTagFromText((CharSequence)"<application/>");
                                applicationTag.addSubTag((XmlTag)element.copy(), false);
                                element.delete();
                                tag.addSubTag(applicationTag, true);
                            }
                            touchedXmlFiles.add(manifest);
                        } else {
                            super.visitXmlTag(tag);
                        }
                    }
                });
                continue;
            }
            if (!(element instanceof PsiClass)) continue;
            String packageName = ((PsiJavaFile)element.getContainingFile()).getPackageName();
            MoveClassesOrPackagesUtil.doMoveClass((PsiClass)((PsiClass)element), (PsiDirectory)RefactoringUtil.createPackageDirectoryInSourceRoot((PackageWrapper)new PackageWrapper(PsiManager.getInstance((Project)this.myProject), packageName), (VirtualFile)javaTargetDir), (boolean)true);
        }
        for (XmlFile touchedFile : touchedXmlFiles) {
            CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)touchedFile);
        }
    }

    @Nullable
    private PsiDirectory getOrCreateTargetDirectory(ResourceFolderRepository base, ResourceItem resourceItem) {
        ResourceFolderType folderType;
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        if (resourceItem.getSource() != null && (folderType = ResourceHelper.getFolderType((ResourceFile)resourceItem.getSource())) != null) {
            try {
                return manager.findDirectory(VfsUtil.createDirectoryIfMissing((VirtualFile)base.getResourceDir(), (String)resourceItem.getConfiguration().getFolderName(folderType)));
            }
            catch (Exception ex) {
                LOGGER.debug((Throwable)ex);
            }
        }
        LOGGER.warn("Couldn't determine target folder for resource " + resourceItem);
        return null;
    }

    @Nullable
    private PsiFile getOrCreateTargetValueFile(ResourceFolderRepository base, ResourceItem resourceItem) {
        if (resourceItem.getSource() != null) {
            try {
                String name = ((ResourceFile)resourceItem.getSource()).getFile().getName();
                PsiDirectory dir = this.getOrCreateTargetDirectory(base, resourceItem);
                if (dir != null) {
                    PsiFile result = dir.findFile(name);
                    if (result != null) {
                        return result;
                    }
                    return (PsiFile)AndroidFileTemplateProvider.createFromTemplate("valueResourceFile.xml", name, dir);
                }
            }
            catch (Exception ex) {
                LOGGER.debug((Throwable)ex);
            }
        }
        LOGGER.warn("Couldn't determine target file for resource " + resourceItem);
        return null;
    }

    @Nullable
    private PsiFile getOrCreateTargetManifestFile(AndroidFacet facet) {
        PsiDirectory targetDirectory;
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        VirtualFile manifestFile = VfsUtil.findFileByIoFile((File)facet.getMainSourceProvider().getManifestFile(), (boolean)false);
        if (manifestFile != null) {
            return manager.findFile(manifestFile);
        }
        VirtualFile directory = VfsUtil.findFileByIoFile((File)facet.getMainSourceProvider().getManifestFile().getParentFile(), (boolean)false);
        if (directory != null && (targetDirectory = manager.findDirectory(directory)) != null) {
            try {
                return (PsiFile)AndroidFileTemplateProvider.createFromTemplate("AndroidManifest.xml", "AndroidManifest.xml", targetDirectory);
            }
            catch (Exception ex) {
                LOGGER.debug((Throwable)ex);
            }
        }
        LOGGER.warn("Couldn't determine manifest file for module " + this.myTargetModule);
        return null;
    }

    @NotNull
    protected String getCommandName() {
        return "Moving " + RefactoringUIUtil.calculatePsiElementDescriptionList((PsiElement[])this.myRoots);
    }

    static class PreviewDialog
    extends DialogWrapper {
        private final AndroidModularizePreviewPanel myPanel;

        protected PreviewDialog(@Nullable Project project, @NotNull AndroidCodeAndResourcesGraph graph, @NotNull UsageInfo[] infos, boolean shouldSelectAllReferences) {
            super(project, true);
            this.myPanel = new AndroidModularizePreviewPanel(graph, infos, shouldSelectAllReferences);
            this.setTitle("Modularize: Preview Classes and Resources to Be Moved");
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myPanel.getPanel();
        }

        @NotNull
        public UsageInfo[] getSelectedUsages() {
            return this.myPanel.getSelectedUsages();
        }
    }

    public static class ResourceXmlUsageInfo
    extends UsageInfo {
        private final ResourceItem myResourceItem;

        public ResourceXmlUsageInfo(@NotNull PsiElement element, @NotNull ResourceItem resourceItem) {
            super(element);
            this.myResourceItem = resourceItem;
        }

        public ResourceXmlUsageInfo(@NotNull SmartPsiElementPointer<?> smartPointer, @Nullable SmartPsiFileRange psiFileRange, @NotNull ResourceItem resourceItem) {
            super(smartPointer, psiFileRange, false, false);
            this.myResourceItem = resourceItem;
        }

        @NotNull
        public ResourceItem getResourceItem() {
            return this.myResourceItem;
        }
    }
}

