/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public abstract class DependencyTreeNode
extends CheckedTreeNode {
    private static final SimpleTextAttributes STRIKEOUT_ATTRIBUTES = new SimpleTextAttributes(6, null);
    private final int myReferenceCount;

    public DependencyTreeNode(Object userObject) {
        this(userObject, 0);
    }

    public DependencyTreeNode(Object userObject, int referenceCount) {
        super(userObject);
        this.myReferenceCount = referenceCount;
    }

    public int getReferenceCount() {
        return this.myReferenceCount;
    }

    public abstract void render(@NotNull ColoredTreeCellRenderer var1);

    @NotNull
    public SimpleTextAttributes getTextAttributes() {
        return this.isChecked() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : STRIKEOUT_ATTRIBUTES;
    }

    public void renderReferenceCount(@NotNull ColoredTreeCellRenderer renderer, SimpleTextAttributes inheritedAttributes) {
        if (this.myReferenceCount > 1) {
            SimpleTextAttributes derivedAttributes = new SimpleTextAttributes(inheritedAttributes.getStyle() | 2 | 0x80, inheritedAttributes.getFgColor());
            renderer.append(" (" + this.myReferenceCount + " usages)", derivedAttributes);
        }
    }

    public void sort(Comparator<DependencyTreeNode> comparator) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            DependencyTreeNode node = (DependencyTreeNode)((Object)this.getChildAt(i));
            node.sort(comparator);
        }
        if (this.children != null) {
            Collections.sort(this.children, comparator);
        }
    }
}

