/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.tools.idea.refactoring.modularize.DependencyTreeNode;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class UsageInfoTreeNode
extends DependencyTreeNode {
    private final PsiElement myPsiElement;

    public UsageInfoTreeNode(@NotNull UsageInfo usageInfo, int referenceCount) {
        super(usageInfo, referenceCount);
        this.myPsiElement = usageInfo.getElement();
    }

    public PsiElement getPsiElement() {
        return this.myPsiElement;
    }

    @Override
    public void render(@NotNull ColoredTreeCellRenderer renderer) {
        renderer.setIcon((Icon)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Icon>(){

            public Icon compute() {
                return UsageInfoTreeNode.this.myPsiElement.getIcon(3);
            }
        }));
        SimpleTextAttributes inheritedAttributes = this.getTextAttributes();
        if (this.myPsiElement instanceof PsiFile) {
            renderer.append(((PsiFile)this.myPsiElement).getName(), inheritedAttributes);
            UsageInfoTreeNode.renderQualifiers(ResourceHelper.getFolderConfiguration((PsiFile)this.myPsiElement), renderer, inheritedAttributes);
            this.renderReferenceCount(renderer, inheritedAttributes);
        } else if (this.myPsiElement instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)this.myPsiElement;
            renderer.append(psiClass.getName() == null ? "<unknown>" : psiClass.getName(), inheritedAttributes);
            this.renderReferenceCount(renderer, inheritedAttributes);
        } else if (this.myPsiElement instanceof XmlTag) {
            renderer.append(this.myPsiElement.getText(), inheritedAttributes);
        } else {
            throw new IllegalArgumentException("Unknown psiElement " + this.myPsiElement);
        }
    }

    private static void renderQualifiers(FolderConfiguration folderConfig, ColoredTreeCellRenderer renderer, SimpleTextAttributes inheritedAttributes) {
        String config = folderConfig.getQualifierString();
        if (!StringUtil.isEmptyOrSpaces((String)config)) {
            SimpleTextAttributes derivedAttributes = new SimpleTextAttributes(inheritedAttributes.getStyle() | 0x80, inheritedAttributes.getFgColor());
            renderer.append(" (" + config + ")", derivedAttributes);
        }
    }
}

