/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.rendering.GutterIconFactory;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconCache {
    private static final Logger LOG = Logger.getInstance(GutterIconCache.class);
    private static final Icon NONE = AndroidIcons.Android;
    static final int MAX_WIDTH = JBUI.scale((int)16);
    static final int MAX_HEIGHT = JBUI.scale((int)16);
    private static final GutterIconCache ourInstance = new GutterIconCache();
    private Map<String, Icon> myThumbnailCache = Maps.newHashMap();
    private Map<String, Long> myTimestampCache = Maps.newHashMap();
    private boolean myRetina;

    @NotNull
    public static GutterIconCache getInstance() {
        return ourInstance;
    }

    boolean isIconUpToDate(@NotNull String path) {
        VirtualFile file;
        if (this.myTimestampCache.containsKey(path) && (file = LocalFileSystem.getInstance().findFileByPath(path)) != null) {
            return this.myTimestampCache.get(path).longValue() == file.getTimeStamp() && !FileDocumentManager.getInstance().isFileModified(file);
        }
        return false;
    }

    @Nullable
    public Icon getIcon(@NotNull String path, @Nullable ResourceResolver resolver) {
        Icon myIcon;
        boolean isRetina = UIUtil.isRetina();
        if (this.myRetina != isRetina) {
            this.myRetina = isRetina;
            this.myThumbnailCache.clear();
        }
        if ((myIcon = this.myThumbnailCache.get(path)) == null || !this.isIconUpToDate(path)) {
            myIcon = GutterIconFactory.createIcon(path, resolver, MAX_WIDTH, MAX_HEIGHT);
            if (myIcon == null) {
                myIcon = NONE;
            }
            this.myThumbnailCache.put(path, myIcon);
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            if (file != null) {
                this.myTimestampCache.put(path, file.getTimeStamp());
            }
        }
        return myIcon != NONE ? myIcon : null;
    }
}

