/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.vectordrawable.VdPreview;
import com.android.resources.ResourceUrl;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.res.ResourceHelper;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.Gray;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GutterIconFactory {
    private static final Logger LOG = Logger.getInstance(GutterIconCache.class);

    @Nullable
    public static Icon createIcon(@NotNull String path, @Nullable ResourceResolver resolver, int maxWidth, int maxHeight) {
        if (path.endsWith(".xml")) {
            return GutterIconFactory.createXmlIcon(path, resolver, maxWidth);
        }
        return GutterIconFactory.createBitmapIcon(path, maxWidth, maxHeight);
    }

    private static String getXmlContent(@NotNull String path) throws IOException {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null) {
            return Files.toString((File)new File(path), (Charset)Charsets.UTF_8);
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document == null) {
            return new String(file.contentsToByteArray());
        }
        return document.getText();
    }

    @Nullable
    private static Icon createXmlIcon(@NotNull String path, @Nullable ResourceResolver resolver, int maxWidth) {
        try {
            VdPreview.TargetSize imageTargetSize = VdPreview.TargetSize.createSizeFromWidth((int)(GutterIconFactory.isRetinaEnabled() ? 2 * maxWidth : maxWidth));
            String xml = GutterIconFactory.getXmlContent(path);
            if (xml.contains("<vector")) {
                org.w3c.dom.Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document == null) {
                    return null;
                }
                Element root = document.getDocumentElement();
                if (root == null) {
                    return null;
                }
                if (resolver != null) {
                    GutterIconFactory.replaceResourceReferences(root, resolver);
                }
                StringBuilder builder = new StringBuilder(100);
                BufferedImage image = VdPreview.getPreviewFromVectorDocument((VdPreview.TargetSize)imageTargetSize, (org.w3c.dom.Document)document, (StringBuilder)builder);
                if (builder.length() > 0) {
                    LOG.warn("Problems rendering " + path + ": " + builder);
                }
                if (image != null) {
                    RetinaImageIcon retinaIcon;
                    if (GutterIconFactory.isRetinaEnabled() && (retinaIcon = GutterIconFactory.getRetinaIcon(image)) != null) {
                        return retinaIcon;
                    }
                    return new ImageIcon(image);
                }
            }
        }
        catch (Throwable e) {
            LOG.warn(String.format("Could not read/render icon image %1$s", path), e);
        }
        return null;
    }

    private static boolean isRetinaEnabled() {
        return UIUtil.isRetina();
    }

    static boolean isReference(String attributeValue) {
        return ResourceUrl.parse((String)attributeValue) != null;
    }

    static void replaceResourceReferences(Node node, ResourceResolver resolver) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            NamedNodeMap attributes = element.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String resolvedValue;
                Node attribute = attributes.item(i);
                String value = attribute.getNodeValue();
                if (!GutterIconFactory.isReference(value) || GutterIconFactory.isReference(resolvedValue = ResourceHelper.resolveStringValue((RenderResources)resolver, value))) continue;
                attribute.setNodeValue(resolvedValue);
            }
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            GutterIconFactory.replaceResourceReferences(node, resolver);
        }
    }

    @Nullable
    private static Icon createBitmapIcon(@NotNull String path, int maxWidth, int maxHeight) {
        try {
            Icon icon = GutterIconFactory.createBitmapIcon(ImageIO.read(new File(path)), maxWidth, maxHeight);
            if (icon != null) {
                return icon;
            }
        }
        catch (Throwable e) {
            LOG.warn(String.format("Could not read icon image %1$s", path), e);
        }
        return null;
    }

    @Nullable
    private static Icon createBitmapIcon(BufferedImage image, int maxWidth, int maxHeight) {
        if (image != null) {
            double scale;
            BufferedImage scaled;
            RetinaImageIcon retinaIcon;
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            if (GutterIconFactory.isRetinaEnabled() && (imageWidth > 2 * maxWidth || imageHeight > 2 * maxHeight) && (retinaIcon = GutterIconFactory.getRetinaIcon(scaled = ImageUtils.scale((BufferedImage)image, (double)(scale = 2.0 * Math.min((double)maxWidth / (double)imageWidth, (double)maxHeight / (double)imageHeight)), (double)scale))) != null) {
                return retinaIcon;
            }
            if (imageWidth > maxWidth || imageHeight > maxHeight) {
                scale = Math.min((double)maxWidth / (double)imageWidth, (double)maxHeight / (double)imageHeight);
                if (image.getType() == 13) {
                    BufferedImage bg = UIUtil.createImage((int)imageWidth, (int)imageHeight, (int)2);
                    Graphics g = bg.getGraphics();
                    g.setColor(Gray.TRANSPARENT);
                    g.fillRect(0, 0, bg.getWidth(), bg.getHeight());
                    UIUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
                    g.dispose();
                    image = bg;
                }
                image = ImageUtils.scale((BufferedImage)image, (double)scale, (double)scale);
            }
            return new ImageIcon(image);
        }
        return null;
    }

    @Nullable
    private static RetinaImageIcon getRetinaIcon(BufferedImage image) {
        BufferedImage hdpiImage;
        if (GutterIconFactory.isRetinaEnabled() && (hdpiImage = ImageUtils.convertToRetina((BufferedImage)image)) != null) {
            return new RetinaImageIcon((Image)hdpiImage);
        }
        return null;
    }

    private static class RetinaImageIcon
    extends ImageIcon {
        private RetinaImageIcon(Image image) {
            super(image, "");
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            UIUtil.drawImage((Graphics)g, (Image)this.getImage(), (int)x, (int)y, null);
        }
    }
}

