/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ForwardingQueue;
import com.google.common.collect.Sets;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImagePool {
    public static final Image NULL_POOLED_IMAGE = new Image(){

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public int getHeight() {
            return 0;
        }

        @Override
        public void drawImageTo(@NotNull Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        }

        @Override
        public void paint(Consumer<Graphics2D> command) {
        }

        @Override
        @Nullable
        public BufferedImage getCopy(int x, int y, int w, int h) {
            return null;
        }

        @Override
        public void dispose() {
        }
    };
    private static final boolean DEBUG = false;
    private static final Bucket NULL_BUCKET = new Bucket(0, 0, 0);
    private final int[] myBucketSizes;
    private final HashMap<String, Bucket> myPool = new HashMap();
    private final BiFunction<Integer, Integer, Function<Integer, Integer>> myBucketSizingPolicy;
    private final FinalizableReferenceQueue myFinalizableReferenceQueue = new FinalizableReferenceQueue();
    private final Set<Reference<?>> myReferences = Sets.newConcurrentHashSet();
    private boolean isDisposed = false;

    public ImagePool(@NotNull int[] bucketSizes, @NotNull BiFunction<Integer, Integer, Function<Integer, Integer>> bucketSizingPolicy) {
        this.myBucketSizes = bucketSizes;
        Arrays.sort(this.myBucketSizes);
        this.myBucketSizingPolicy = bucketSizingPolicy;
    }

    @NotNull
    private static String getPoolKey(int w, int h, int type) {
        return String.format("%dx%d-%d", w, h, type);
    }

    public ImagePool() {
        this(new int[]{50, 500, 1000, 1500, 2000, 5000}, (w, h) -> type -> {
            if (w * h < 1000) {
                return 0;
            }
            return 50000000 / (w * h);
        });
    }

    @NotNull
    private Bucket getTypeBucket(int w, int h, int type) {
        if (this.myBucketSizingPolicy.apply(w, h).apply(type) == 0) {
            return NULL_BUCKET;
        }
        int widthBucket = -1;
        int heightBucket = -1;
        for (int bucketMinSize : this.myBucketSizes) {
            if (widthBucket == -1 && w < bucketMinSize) {
                widthBucket = bucketMinSize;
                if (heightBucket != -1) break;
            }
            if (heightBucket != -1 || h >= bucketMinSize) continue;
            heightBucket = bucketMinSize;
            if (widthBucket != -1) break;
        }
        if (widthBucket == -1 || heightBucket == -1) {
            return NULL_BUCKET;
        }
        String poolKey = ImagePool.getPoolKey(widthBucket, heightBucket, type);
        int finalWidthBucket = widthBucket;
        int finalHeightBucket = heightBucket;
        return this.myPool.computeIfAbsent(poolKey, k -> {
            int size = this.myBucketSizingPolicy.apply(finalWidthBucket, finalHeightBucket).apply(type);
            if (size == 0) {
                return NULL_BUCKET;
            }
            return new Bucket(finalWidthBucket, finalHeightBucket, size);
        });
    }

    @NotNull
    ImageImpl create(final int w, final int h, final int type, final @Nullable Consumer<BufferedImage> freedCallback) {
        BufferedImage image;
        assert (!this.isDisposed) : "ImagePool already disposed";
        final Bucket bucket = this.getTypeBucket(w, h, type);
        try {
            SoftReference imageRef = (SoftReference)bucket.remove();
            while ((image = (BufferedImage)imageRef.get()) == null) {
                imageRef = (SoftReference)bucket.remove();
            }
            Graphics2D g = image.createGraphics();
            g.setComposite(AlphaComposite.Clear);
            g.fillRect(0, 0, w, h);
            g.dispose();
        }
        catch (NoSuchElementException e) {
            image = new BufferedImage(Math.max(bucket.myMinWidth, w), Math.max(bucket.myMinHeight, h), type);
        }
        ImageImpl pooledImage = new ImageImpl(w, h, image);
        final BufferedImage imagePointer = image;
        FinalizablePhantomReference<Image> reference = new FinalizablePhantomReference<Image>((Image)pooledImage, this.myFinalizableReferenceQueue){

            public void finalizeReferent() {
                if (ImagePool.this.myReferences.remove((Object)this)) {
                    boolean accepted = bucket.offer(new SoftReference<BufferedImage>(imagePointer));
                    if (freedCallback != null) {
                        freedCallback.accept(imagePointer);
                    }
                }
            }
        };
        pooledImage.myOwnReference = (FinalizablePhantomReference)reference;
        this.myReferences.add((Reference<?>)reference);
        return pooledImage;
    }

    @NotNull
    public Image create(int w, int h, int type) {
        return this.create(w, h, type, null);
    }

    @NotNull
    public Image copyOf(@Nullable BufferedImage origin) {
        if (origin == null) {
            return NULL_POOLED_IMAGE;
        }
        int w = origin.getWidth();
        int h = origin.getHeight();
        int type = origin.getType();
        ImageImpl image = this.create(w, h, type, null);
        image.drawFrom(origin);
        return image;
    }

    public void dispose() {
        this.isDisposed = true;
        this.myFinalizableReferenceQueue.close();
        this.myReferences.clear();
        this.myPool.clear();
    }

    public static class ImageImpl
    implements Image {
        private FinalizablePhantomReference<Image> myOwnReference = null;
        @Nullable
        BufferedImage myBuffer;
        final int myWidth;
        final int myHeight;

        private ImageImpl(int w, int h, @NotNull BufferedImage image) {
            assert (w <= image.getWidth() && h <= image.getHeight());
            this.myWidth = w;
            this.myHeight = h;
            this.myBuffer = image;
        }

        @Override
        public int getWidth() {
            assert (this.myBuffer != null) : "Image was already disposed";
            return this.myWidth;
        }

        @Override
        public int getHeight() {
            assert (this.myBuffer != null) : "Image was already disposed";
            return this.myHeight;
        }

        @Override
        public void drawImageTo(@NotNull Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
            assert (this.myBuffer != null) : "Image was already disposed";
            g.drawImage(this.myBuffer, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
        }

        @Override
        public void paint(@NotNull Consumer<Graphics2D> command) {
            assert (this.myBuffer != null) : "Image was already disposed";
            Graphics2D g = this.myBuffer.createGraphics();
            try {
                command.accept(g);
            }
            finally {
                g.dispose();
            }
        }

        @Override
        @NotNull
        public BufferedImage getCopy(int x, int y, int w, int h) {
            assert (this.myBuffer != null) : "Image was already disposed";
            if (x + w > this.myWidth) {
                throw new IndexOutOfBoundsException(String.format("x + y is out bounds (image width is = %d)", h));
            }
            if (y + h > this.myHeight) {
                throw new IndexOutOfBoundsException(String.format("y + h is out bounds (image height is = %d)", h));
            }
            WritableRaster raster = this.myBuffer.copyData(this.myBuffer.getRaster().createCompatibleWritableRaster(x, y, w, h));
            return new BufferedImage(this.myBuffer.getColorModel(), raster, this.myBuffer.isAlphaPremultiplied(), null);
        }

        @Override
        @NotNull
        public BufferedImage getCopy() {
            assert (this.myBuffer != null) : "Image was already disposed";
            WritableRaster raster = this.myBuffer.copyData(this.myBuffer.getRaster().createCompatibleWritableRaster(0, 0, this.myWidth, this.myHeight));
            return new BufferedImage(this.myBuffer.getColorModel(), raster, this.myBuffer.isAlphaPremultiplied(), null);
        }

        @Override
        public void dispose() {
            assert (this.myBuffer != null) : "Image was already disposed";
            this.myBuffer = null;
            if (this.myOwnReference != null) {
                this.myOwnReference.finalizeReferent();
            }
        }

        void drawFrom(@NotNull BufferedImage origin) {
            assert (this.myBuffer != null) : "Image was already disposed";
            Graphics g = this.myBuffer.getGraphics();
            try {
                g.drawImage(origin, 0, 0, null);
            }
            finally {
                g.dispose();
            }
        }
    }

    public static interface Image {
        public int getWidth();

        public int getHeight();

        public void drawImageTo(@NotNull Graphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

        public void paint(Consumer<Graphics2D> var1);

        default public void drawImageTo(@NotNull Graphics g, int x, int y, int w, int h) {
            this.drawImageTo(g, x, y, x + w, y + h, 0, 0, this.getWidth(), this.getHeight());
        }

        default public void drawImageTo(@NotNull BufferedImage destination) {
            Graphics g = destination.getGraphics();
            try {
                this.drawImageTo(g, 0, 0, destination.getWidth(), destination.getHeight());
            }
            finally {
                g.dispose();
            }
        }

        @Nullable
        public BufferedImage getCopy(int var1, int var2, int var3, int var4);

        @Nullable
        default public BufferedImage getCopy() {
            return this.getCopy(0, 0, this.getWidth(), this.getHeight());
        }

        public void dispose();
    }

    private static class Bucket
    extends ForwardingQueue<SoftReference<BufferedImage>> {
        private final Queue<SoftReference<BufferedImage>> myDelegate;
        private final AtomicLong myLastAccess = new AtomicLong(System.currentTimeMillis());
        private final int myMinWidth;
        private final int myMinHeight;

        public Bucket(int minWidth, int minHeight, int maxSize) {
            this.myMinWidth = minWidth;
            this.myMinHeight = minHeight;
            this.myDelegate = maxSize == 0 ? EvictingQueue.create((int)0) : new ArrayBlockingQueue(maxSize);
        }

        protected Queue<SoftReference<BufferedImage>> delegate() {
            this.myLastAccess.set(System.currentTimeMillis());
            return this.myDelegate;
        }
    }
}

