/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.idea.rendering.SetAttributeFix;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludeReference {
    public static final IncludeReference NONE = new IncludeReference(null, null, null);
    @NotNull
    private final VirtualFile myFromFile;
    @Nullable
    private final VirtualFile myToFile;
    @NotNull
    private final Module myModule;

    private IncludeReference(Module module, VirtualFile fromFile, @Nullable VirtualFile toFile) {
        this.myModule = module;
        this.myFromFile = fromFile;
        this.myToFile = toFile;
    }

    public static IncludeReference create(Module module, VirtualFile fromFile, @Nullable VirtualFile toFile) {
        return new IncludeReference(module, fromFile, toFile);
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public VirtualFile getFromFile() {
        return this.myFromFile;
    }

    @NotNull
    public File getFromPath() {
        return VfsUtilCore.virtualToIoFile((VirtualFile)this.myFromFile);
    }

    @Nullable
    public VirtualFile getToFile() {
        return this.myToFile;
    }

    @Nullable
    public File getToPath() {
        return this.myToFile != null ? VfsUtilCore.virtualToIoFile((VirtualFile)this.myToFile) : null;
    }

    @NotNull
    public String getFromDisplayName() {
        if (this.myToFile != null && this.myToFile.getParent() != null && this.myToFile.getParent().equals(this.myFromFile.getParent())) {
            return this.myFromFile.getName();
        }
        return this.myFromFile.getParent().getName() + '/' + this.myFromFile.getName();
    }

    @NotNull
    public String getFromResourceName() {
        return ResourceHelper.getResourceName(this.myFromFile);
    }

    @NotNull
    public String getFromResourceUrl() {
        return "@layout/" + this.getFromResourceName();
    }

    @Nullable
    public static String getIncludingLayout(@NotNull XmlFile file) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (String)ApplicationManager.getApplication().runReadAction(() -> IncludeReference.getIncludingLayout(file));
        }
        XmlTag rootTag = file.getRootTag();
        if (rootTag != null && rootTag.isValid()) {
            return rootTag.getAttributeValue("showIn", "http://schemas.android.com/tools");
        }
        return null;
    }

    public static void setIncludingLayout(@NotNull Project project, @NotNull XmlFile xmlFile, @Nullable String layout) {
        XmlTag tag = xmlFile.getRootTag();
        if (tag != null) {
            SetAttributeFix fix = new SetAttributeFix(project, tag, "showIn", "http://schemas.android.com/tools", layout);
            fix.execute();
        }
    }

    @NotNull
    public static IncludeReference get(@NotNull Module module, @NotNull XmlFile file, @NotNull RenderResources resolver) {
        VirtualFile source;
        File path;
        ResourceValue resValue;
        String layout;
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (IncludeReference)ApplicationManager.getApplication().runReadAction(() -> IncludeReference.get(module, file, resolver));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XmlTag rootTag = file.getRootTag();
        if (rootTag != null && (layout = rootTag.getAttributeValue("showIn", "http://schemas.android.com/tools")) != null && (resValue = resolver.findResValue(layout, false)) != null && (path = ResourceHelper.resolveLayout(resolver, resValue)) != null && (source = LocalFileSystem.getInstance().findFileByIoFile(path)) != null) {
            VirtualFile target = file.getVirtualFile();
            return IncludeReference.create(module, source, target);
        }
        return NONE;
    }
}

