/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.tools.idea.rendering.LayoutMetadata;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutFilePullParser
extends KXmlParser
implements ILayoutPullParser {
    private final LayoutlibCallback myLayoutlibCallback;
    private String myFragmentLayout = null;

    public static LayoutFilePullParser create(@NotNull LayoutlibCallback layoutlibCallback, @NotNull File xml) throws XmlPullParserException, IOException {
        String xmlText = Files.toString((File)xml, (Charset)Charsets.UTF_8);
        return LayoutFilePullParser.create(layoutlibCallback, xmlText);
    }

    @NotNull
    public static LayoutFilePullParser create(@NotNull LayoutlibCallback layoutlibCallback, @NotNull String xmlText) throws XmlPullParserException {
        LayoutFilePullParser parser = new LayoutFilePullParser(layoutlibCallback);
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        parser.setInput(new StringReader(xmlText));
        return parser;
    }

    private LayoutFilePullParser(LayoutlibCallback layoutlibCallback) {
        this.myLayoutlibCallback = layoutlibCallback;
    }

    @Deprecated
    public ILayoutPullParser getParser(String layoutName) {
        return this.myLayoutlibCallback.getParser(layoutName);
    }

    @Nullable
    public Object getViewCookie() {
        String name = super.getName();
        if (name == null) {
            return null;
        }
        if ("ListView".equals(name) || "ExpandableListView".equals(name) || "GridView".equals(name) || "Spinner".equals(name)) {
            HashMap map = null;
            int count = this.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                String attribute;
                String namespace = this.getAttributeNamespace(i);
                if (namespace == null || !namespace.equals("http://schemas.android.com/tools") || (attribute = this.getAttributeName(i)).equals("ignore")) continue;
                if (map == null) {
                    map = Maps.newHashMapWithExpectedSize((int)4);
                }
                map.put(attribute, this.getAttributeValue(i));
            }
            return map;
        }
        return null;
    }

    public String getName() {
        String name = super.getName();
        if (name.equals("fragment")) {
            this.myFragmentLayout = LayoutMetadata.getProperty((XmlPullParser)this, "layout");
            if (this.myFragmentLayout != null) {
                return "include";
            }
        } else {
            this.myFragmentLayout = null;
        }
        return name;
    }

    @Nullable
    public String getAttributeValue(String namespace, String localName) {
        if ("layout".equals(localName) && this.myFragmentLayout != null) {
            return this.myFragmentLayout;
        }
        String value = super.getAttributeValue(namespace, localName);
        if ("match_parent".equals(value) && ("layout_width".equals(localName) || "layout_height".equals(localName)) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
            return "fill_parent";
        }
        if (namespace != null) {
            if (namespace.equals("http://schemas.android.com/apk/res/android")) {
                String designValue = super.getAttributeValue("http://schemas.android.com/tools", localName);
                if (designValue != null) {
                    value = value != null && designValue.isEmpty() ? null : designValue;
                }
            } else if (value == null) {
                value = super.getAttributeValue("http://schemas.android.com/apk/res-auto", localName);
            }
        }
        if (value != null) {
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                char c = value.charAt(i);
                if (c != '&' && c != '\\') continue;
                value = ValueXmlHelper.unescapeResourceString((String)value, (boolean)true, (boolean)false);
                break;
            }
        }
        return value;
    }
}

