/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.fonts.ProjectFonts;
import com.android.tools.idea.rendering.DomPullParser;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.LayoutPsiPullParser;
import com.android.tools.idea.rendering.MenuLayoutParserFactory;
import com.android.tools.idea.rendering.MenuPreviewRenderer;
import com.android.tools.idea.rendering.NavigationViewMenuLayoutPullParserFactory;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.ResourceHelper;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.emmet.generators.LoremGenerator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class LayoutPullParsers {
    static final boolean DEBUG = false;
    private static final String[] VALID_XML_TAGS = new String[]{"appwidget-provider", "PreferenceScreen"};
    private static final String[] ADAPTIVE_ICON_TAGS = new String[]{"adaptive-icon", "maskable-icon"};
    private static final String[] FONT_FAMILY_TAGS = new String[]{"font-family"};
    private static final EnumSet<ResourceFolderType> FOLDER_NEEDS_READ_ACCESS = EnumSet.of(ResourceFolderType.DRAWABLE, ResourceFolderType.MENU, ResourceFolderType.XML, ResourceFolderType.FONT);

    private LayoutPullParsers() {
    }

    private static boolean isXmlWithRootTag(@NotNull PsiFile file, @NotNull String[] rootTags) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XmlTag rootTag = ((XmlFile)file).getRootTag();
        if (rootTag == null) {
            return false;
        }
        String tag = rootTag.getName();
        for (String validRootTags : rootTags) {
            if (!validRootTags.equals(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupported(@NotNull PsiFile file) {
        ResourceFolderType folderType = ResourceHelper.getFolderType(file);
        if (folderType == null) {
            return false;
        }
        switch (folderType) {
            case LAYOUT: 
            case DRAWABLE: 
            case MENU: {
                return true;
            }
            case MIPMAP: {
                return LayoutPullParsers.isXmlWithRootTag(file, ADAPTIVE_ICON_TAGS);
            }
            case XML: {
                return LayoutPullParsers.isXmlWithRootTag(file, VALID_XML_TAGS);
            }
            case FONT: {
                return LayoutPullParsers.isXmlWithRootTag(file, FONT_FAMILY_TAGS);
            }
        }
        return false;
    }

    @Nullable
    public static ILayoutPullParser create(@NotNull RenderTask renderTask) {
        ResourceFolderType folderType = renderTask.getFolderType();
        if (folderType == null) {
            return null;
        }
        if (FOLDER_NEEDS_READ_ACCESS.contains(folderType) && !ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (ILayoutPullParser)ApplicationManager.getApplication().runReadAction(() -> LayoutPullParsers.create(renderTask));
        }
        XmlFile file = renderTask.getPsiFile();
        if (file == null) {
            throw new IllegalArgumentException("RenderTask always should always have PsiFile when it has ResourceFolderType");
        }
        switch (folderType) {
            case LAYOUT: {
                IRenderLogger logger = renderTask.getLogger();
                HardwareConfig hardwareConfig = renderTask.getHardwareConfigHelper().getConfig();
                return LayoutPsiPullParser.create(file, logger, Collections.emptySet(), hardwareConfig.getDensity());
            }
            case DRAWABLE: 
            case MIPMAP: {
                renderTask.setDecorations(false);
                return LayoutPullParsers.createDrawableParser(file);
            }
            case MENU: {
                return LayoutPullParsers.createMenuParser(file, renderTask);
            }
            case XML: {
                XmlTag rootTag = file.getRootTag();
                if (rootTag != null) {
                    String tag = rootTag.getName();
                    if (tag.equals("appwidget-provider")) {
                        renderTask.setDecorations(false);
                        return LayoutPullParsers.createWidgetParser(rootTag);
                    }
                    if (tag.equals("PreferenceScreen")) {
                        IRenderLogger logger = renderTask.getLogger();
                        HardwareConfig hardwareConfig = renderTask.getHardwareConfigHelper().getConfig();
                        return LayoutPsiPullParser.create(file, logger, Collections.emptySet(), hardwareConfig.getDensity());
                    }
                }
                return null;
            }
            case FONT: {
                renderTask.setOverrideBgColor(UIUtil.TRANSPARENT_COLOR.getRGB());
                renderTask.setDecorations(false);
                renderTask.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
                return LayoutPullParsers.createFontFamilyParser(file, fontName -> renderTask.getResourceResolver() != null ? new ProjectFonts(renderTask.getResourceResolver()).getFont((String)fontName) : null);
            }
        }
        assert (false) : folderType;
        return null;
    }

    private static ILayoutPullParser createDrawableParser(XmlFile file) {
        String scaleType;
        org.w3c.dom.Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element imageView = LayoutPullParsers.addRootElement(document, "ImageView");
        LayoutPullParsers.setAndroidAttr(imageView, "layout_width", "fill_parent");
        LayoutPullParsers.setAndroidAttr(imageView, "layout_height", "fill_parent");
        ResourceFolderType type = ResourceHelper.getFolderType((PsiFile)file);
        assert (type != null);
        LayoutPullParsers.setAndroidAttr(imageView, "src", file.getVirtualFile().getPath());
        String background = AndroidPsiUtils.getRootTagAttributeSafely(file, "background", "http://schemas.android.com/tools");
        if (background != null && !background.isEmpty()) {
            LayoutPullParsers.setAndroidAttr(imageView, "background", background);
        }
        if ((scaleType = AndroidPsiUtils.getRootTagAttributeSafely(file, "scaleType", "http://schemas.android.com/tools")) != null && !scaleType.isEmpty()) {
            LayoutPullParsers.setAndroidAttr(imageView, "scaleType", scaleType);
        }
        return new DomPullParser(document.getDocumentElement());
    }

    @NotNull
    private static ILayoutPullParser createMenuParser(@NotNull XmlFile file, @NotNull RenderTask task) {
        XmlTag tag = file.getRootTag();
        if (tag != null && Objects.equals(tag.getAttributeValue("showIn", "http://schemas.android.com/tools"), "navigation_view")) {
            task.setDecorations(false);
            return new NavigationViewMenuLayoutPullParserFactory(task).render();
        }
        if (task.supportsCapability(12)) {
            return new MenuLayoutParserFactory(task).render();
        }
        task.setDecorations(false);
        task.setRenderingMode(SessionParams.RenderingMode.FULL_EXPAND);
        return new MenuPreviewRenderer(task, file).render();
    }

    @Nullable
    private static ILayoutPullParser createWidgetParser(XmlTag rootTag) {
        String layout = rootTag.getAttributeValue("initialLayout", "http://schemas.android.com/apk/res/android");
        String preview = rootTag.getAttributeValue("previewImage", "http://schemas.android.com/apk/res/android");
        if (layout == null && preview == null) {
            return null;
        }
        org.w3c.dom.Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element root = LayoutPullParsers.addRootElement(document, layout != null ? "include" : "ImageView");
        if (layout != null) {
            root.setAttribute("layout", layout);
            LayoutPullParsers.setAndroidAttr(root, "layout_width", "fill_parent");
            LayoutPullParsers.setAndroidAttr(root, "layout_height", "fill_parent");
        } else {
            root.setAttribute("src", preview);
            LayoutPullParsers.setAndroidAttr(root, "layout_width", "wrap_content");
            LayoutPullParsers.setAndroidAttr(root, "layout_height", "wrap_content");
        }
        return new DomPullParser(document.getDocumentElement());
    }

    @VisibleForTesting
    @Nullable
    static ILayoutPullParser createFontFamilyParser(XmlFile file, @NotNull Function<String, FontFamily> getDownloadableFont) {
        Stream<String> stylesStream;
        XmlTag rootTag = file.getRootTag();
        if (rootTag == null || !"font-family".equals(rootTag.getName())) {
            return null;
        }
        org.w3c.dom.Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element rootLayout = LayoutPullParsers.addRootElement(document, "LinearLayout");
        LayoutPullParsers.setAndroidAttr(rootLayout, "layout_width", "fill_parent");
        LayoutPullParsers.setAndroidAttr(rootLayout, "layout_height", "wrap_content");
        LayoutPullParsers.setAndroidAttr(rootLayout, "orientation", "vertical");
        String loremText = new LoremGenerator().generate(8, true);
        ResourceFolderType type = ResourceHelper.getFolderType((PsiFile)file);
        assert (type != null);
        String fontRefName = "@" + type.getName() + "/" + ResourceHelper.getResourceName((PsiFile)file);
        XmlTag[] fontSubTags = rootTag.getSubTags();
        if (fontSubTags.length == 0) {
            FontFamily downloadedFont = getDownloadableFont.apply(fontRefName);
            DownloadableFontCacheService fontCacheService = DownloadableFontCacheService.getInstance();
            Predicate<FontDetail> exists = font -> fontCacheService.getCachedFontFile((FontDetail)font).exists();
            stylesStream = downloadedFont != null ? downloadedFont.getFonts().stream().filter(exists).map(FontDetail::getFontStyle) : Stream.empty();
        } else {
            stylesStream = Arrays.stream(fontSubTags).map(font -> font.getAttributeValue("fontStyle", "http://schemas.android.com/apk/res/android")).filter(StringUtil::isNotEmpty);
        }
        boolean[] hasElements = new boolean[1];
        String fontColor = '#' + ColorUtil.toHex((Color)UIUtil.getLabelForeground());
        stylesStream.forEach(styleName -> {
            hasElements[0] = true;
            Element fontElement = document.createElement("TextView");
            LayoutPullParsers.setAndroidAttr(fontElement, "layout_width", "wrap_content");
            LayoutPullParsers.setAndroidAttr(fontElement, "layout_height", "wrap_content");
            LayoutPullParsers.setAndroidAttr(fontElement, "text", loremText);
            LayoutPullParsers.setAndroidAttr(fontElement, "fontFamily", fontRefName);
            LayoutPullParsers.setAndroidAttr(fontElement, "textSize", "30sp");
            LayoutPullParsers.setAndroidAttr(fontElement, "textColor", fontColor);
            LayoutPullParsers.setAndroidAttr(fontElement, "paddingBottom", "20dp");
            LayoutPullParsers.setAndroidAttr(fontElement, "textStyle", styleName);
            rootLayout.appendChild(fontElement);
        });
        if (!hasElements[0]) {
            return null;
        }
        return new DomPullParser(document.getDocumentElement());
    }

    public static boolean needSave(@Nullable ResourceFolderType type) {
        return type != ResourceFolderType.LAYOUT;
    }

    public static void saveFileIfNecessary(PsiFile psiFile) {
        if (!LayoutPullParsers.needSave(ResourceHelper.getFolderType(psiFile.getVirtualFile()))) {
            return;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return;
        }
        FileDocumentManager fileManager = FileDocumentManager.getInstance();
        if (!fileManager.isFileModified(file)) {
            return;
        }
        Document document = fileManager.getCachedDocument(file);
        if (document == null || !fileManager.isDocumentUnsaved(document)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> application.runWriteAction(() -> fileManager.saveDocument(document)));
    }

    protected static Element addRootElement(@NotNull org.w3c.dom.Document document, @NotNull String tag) {
        Element root = document.createElement(tag);
        Attr attr = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:android");
        attr.setValue("http://schemas.android.com/apk/res/android");
        root.getAttributes().setNamedItemNS(attr);
        document.appendChild(root);
        return root;
    }

    protected static Element setAndroidAttr(Element element, String name, String value) {
        element.setAttributeNS("http://schemas.android.com/apk/res/android", name, value);
        return element;
    }

    public static ILayoutPullParser createEmptyParser() {
        org.w3c.dom.Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element root = LayoutPullParsers.addRootElement(document, "FrameLayout");
        LayoutPullParsers.setAndroidAttr(root, "layout_width", "fill_parent");
        LayoutPullParsers.setAndroidAttr(root, "layout_height", "fill_parent");
        return new DomPullParser(document.getDocumentElement());
    }
}

