/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.resources.ResourceResolver;
import com.android.layoutlib.bridge.impl.RenderSessionImpl;
import com.android.resources.Density;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.AddMissingAttributesFix;
import com.android.tools.idea.rendering.ClassConverter;
import com.android.tools.idea.rendering.HtmlBuilderHelper;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.SetAttributeFix;
import com.android.tools.idea.rendering.ShowExceptionFix;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.HtmlBuilder;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

public class RenderErrorContributor {
    private static final String RENDER_SESSION_IMPL_FQCN = RenderSessionImpl.class.getCanonicalName();
    protected static final int HIGH_PRIORITY = 100;
    protected static final int MEDIUM_PRIORITY = 10;
    protected static final int LOW_PRIORITY = 10;
    protected static final Logger LOG = Logger.getInstance(RenderErrorContributor.class);
    private static final String APP_COMPAT_REQUIRED_MSG = "You need to use a Theme.AppCompat";
    private final List<RenderErrorModel.Issue> myIssues = new ArrayList<RenderErrorModel.Issue>();
    private final HtmlLinkManager myLinkManager;
    private final HyperlinkListener myLinkHandler;
    private final RenderResult myResult;
    private final DataContext myDataContext;

    protected RenderErrorContributor(@NotNull RenderResult result, @Nullable DataContext dataContext) {
        this.myResult = result;
        this.myLinkManager = this.myResult.getLogger().getLinkManager();
        this.myLinkHandler = e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                    return;
                }
                this.performClick(this.myResult, e.getDescription());
            }
        };
        this.myDataContext = dataContext;
    }

    private static boolean isHiddenFrame(@NotNull StackTraceElement frame) {
        String className = frame.getClassName();
        return className.startsWith("sun.reflect.") || className.equals("android.view.BridgeInflater") || className.startsWith("com.android.tools.") || className.startsWith("org.jetbrains.");
    }

    private static boolean isInterestingFrame(@NotNull StackTraceElement frame) {
        String className = frame.getClassName();
        return !className.startsWith("android.") && !className.startsWith("org.jetbrains.") && !className.startsWith("com.android.") && !className.startsWith("java.") && !className.startsWith("javax.") && !className.startsWith("sun.");
    }

    private static boolean isFramework(@NotNull StackTraceElement frame) {
        String className = frame.getClassName();
        return className.startsWith("android.") || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.");
    }

    private static boolean isVisible(@NotNull StackTraceElement frame) {
        String className = frame.getClassName();
        return !RenderErrorContributor.isFramework(frame) && !className.startsWith("sun.");
    }

    @NotNull
    private static Collection<PsiClass> findInheritors(final @NotNull Module module, final @NotNull String name) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiClass>>(){

                @NotNull
                public Collection<PsiClass> compute() {
                    return RenderErrorContributor.findInheritors(module, name);
                }
            });
        }
        Project project = module.getProject();
        try {
            PsiClass base = JavaPsiFacade.getInstance((Project)project).findClass(name, GlobalSearchScope.allScope((Project)project));
            if (base != null) {
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
                return ClassInheritorsSearch.search((PsiClass)base, (SearchScope)scope, (boolean)true).findAll();
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    @NotNull
    private static Collection<String> getAllViews(final @Nullable Module module) {
        if (module == null) {
            return Collections.emptyList();
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<String>>(){

                @NotNull
                public Collection<String> compute() {
                    return RenderErrorContributor.getAllViews(module);
                }
            });
        }
        HashSet<String> names = new HashSet<String>();
        for (PsiClass psiClass : RenderErrorContributor.findInheritors(module, "android.view.View")) {
            String name = psiClass.getQualifiedName();
            if (name == null) continue;
            names.add(name);
        }
        return names;
    }

    static boolean isBuiltByJdk7OrHigher(@NotNull Module module) {
        Sdk jdk;
        AndroidSdkAdditionalData data;
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null) {
            return false;
        }
        AndroidSdks androidSdks = AndroidSdks.getInstance();
        if (androidSdks.isAndroidSdk(sdk) && (data = androidSdks.getAndroidSdkAdditionalData(sdk)) != null && (jdk = data.getJavaSdk()) != null) {
            sdk = jdk;
        }
        return sdk.getSdkType() instanceof JavaSdk && JavaSdk.getInstance().isOfVersionOrHigher(sdk, JavaSdkVersion.JDK_1_7);
    }

    private static void collectProblemModules(@NotNull Module module, @NotNull Set<Module> visited, @NotNull Collection<Module> result) {
        if (!visited.add(module)) {
            return;
        }
        if (RenderErrorContributor.isBuiltByJdk7OrHigher(module)) {
            result.add(module);
        }
        for (Module depModule : ModuleRootManager.getInstance((Module)module).getDependencies(false)) {
            RenderErrorContributor.collectProblemModules(depModule, visited, result);
        }
    }

    @NotNull
    private static Set<String> getSdkNamesFromModules(@NotNull Collection<Module> modules) {
        HashSet<String> result = new HashSet<String>();
        for (Module module : modules) {
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk == null) continue;
            result.add(sdk.getName());
        }
        return result;
    }

    @NotNull
    private static List<Module> getProblemModules(@NotNull Module root) {
        ArrayList<Module> result = new ArrayList<Module>();
        RenderErrorContributor.collectProblemModules(root, new HashSet<Module>(), result);
        return result;
    }

    private static void askAndRebuild(Project project) {
        int r = Messages.showYesNoDialog((Project)project, (String)"You have to rebuild project to see the fixed preview. Would you like to do it?", (String)"Rebuild Project", (Icon)Messages.getQuestionIcon());
        if (r == 0) {
            CompilerManager.getInstance((Project)project).rebuild(null);
        }
    }

    protected RenderErrorModel.Issue.Builder addIssue() {
        return new RenderErrorModel.Issue.Builder(){

            @Override
            @NotNull
            public RenderErrorModel.Issue build() {
                RenderErrorModel.Issue built = super.build();
                RenderErrorContributor.this.myIssues.add(built);
                return built;
            }
        }.setLinkHandler(this.myLinkHandler);
    }

    private void reportMissingStyles(@NotNull RenderLogger logger) {
        if (logger.seenTagPrefix("project.building")) {
            this.addIssue().setSummary("Project Still Building: May cause rendering errors until the build is done").build();
        } else if (logger.seenTagPrefix("resources.resolve.theme")) {
            this.addIssue().setSummary("Missing styles").setHtmlContent(new HtmlBuilder().addBold("Missing styles. Is the correct theme chosen for this layout?").newline().addIcon(HtmlBuilderHelper.getTipIconPath()).add("Use the Theme combo box above the layout to choose a different layout, or fix the theme style references.")).build();
        }
    }

    private void reportOldNinePathRenderLib(@NotNull RenderLogger logger, @NotNull RenderTask renderTask) {
        if (renderTask.getConfiguration().getDensity() != Density.TV) {
            return;
        }
        logger.getTraces().stream().map(Object::toString).filter(s -> s.contains("java.lang.IndexOutOfBoundsException: Index: 2, Size: 2")).findAny().ifPresent(s -> this.addIssue().setSummary("tvdpi not supported").setHtmlContent(new HtmlBuilder().addBold("It looks like you are using a render target where the layout library does not support the tvdpi density.").newline().newline().add("Please try either updating to the latest available version (using the SDK manager), or if no updated version is available for this specific version of Android, try using a more recent render target version.").newline().newline()).build());
    }

    private void reportMissingSize(@NotNull HtmlBuilder builder, @NotNull RenderLogger logger, @NotNull String fill2, @NotNull XmlTag tag, @NotNull String id, @NotNull String attribute) {
        Module module = logger.getModule();
        if (module == null) {
            return;
        }
        Project project = module.getProject();
        String wrapUrl = this.myLinkManager.createCommandLink(new SetAttributeFix(project, tag, attribute, "http://schemas.android.com/apk/res/android", "wrap_content"));
        String fillUrl = this.myLinkManager.createCommandLink(new SetAttributeFix(project, tag, attribute, "http://schemas.android.com/apk/res/android", fill2));
        builder.add(String.format("%1$s does not set the required %2$s attribute: ", id, attribute)).newline().addNbsps(4).addLink("Set to wrap_content", wrapUrl).add(", ").addLink("Set to " + fill2, fillUrl).newline();
    }

    private void reportMissingSizeAttributes(@NotNull RenderLogger logger, @NotNull RenderTask renderTask) {
        Module module = logger.getModule();
        if (module == null) {
            return;
        }
        Project project = module.getProject();
        if (logger.isMissingSize()) {
            HtmlBuilder builder = new HtmlBuilder();
            builder.addBold("NOTE: One or more layouts are missing the layout_width or layout_height attributes. These are required in most layouts.").newline();
            ResourceResolver resourceResolver = renderTask.getResourceResolver();
            XmlFile psiFile = renderTask.getPsiFile();
            if (psiFile == null) {
                LOG.error("PsiFile is missing in RenderTask used in RenderErrorPanel!");
                return;
            }
            AddMissingAttributesFix fix = new AddMissingAttributesFix(project, psiFile, resourceResolver);
            List<XmlTag> missing = fix.findViewsMissingSizes();
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(module);
            String fill2 = moduleInfo == null || moduleInfo.getBuildSdkVersion() == null || moduleInfo.getBuildSdkVersion().getApiLevel() >= 8 ? "match_parent" : "fill_parent";
            for (XmlTag tag : missing) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    boolean missingHeight;
                    boolean missingWidth = !AddMissingAttributesFix.definesWidth(tag, resourceResolver);
                    boolean bl = missingHeight = !AddMissingAttributesFix.definesHeight(tag, resourceResolver);
                    assert (missingWidth || missingHeight);
                    String id = tag.getAttributeValue("id");
                    id = id == null || id.isEmpty() ? '<' + tag.getName() + '>' : '\"' + LintUtils.stripIdPrefix((String)id) + '\"';
                    if (missingWidth) {
                        this.reportMissingSize(builder, logger, fill2, tag, id, "layout_width");
                    }
                    if (missingHeight) {
                        this.reportMissingSize(builder, logger, fill2, tag, id, "layout_height");
                    }
                });
            }
            builder.newline().add("Or: ").addLink("Automatically add all missing attributes", this.myLinkManager.createCommandLink(fix)).newline().newline().newline();
            this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("One or more layouts are missing the layout_width or layout_height attributes").setHtmlContent(builder).build();
        }
    }

    private static void addHtmlForIssue164378(@NotNull Throwable throwable, Module module, HtmlLinkManager linkManager, HtmlBuilder builder, boolean addShowExceptionLink) {
        builder.add("Rendering failed with a known bug. ");
        if (module == null) {
            builder.add("Please rebuild the project and then clear the cache by clicking the refresh icon above the preview.").newline();
            return;
        }
        builder.addLink("Please try a ", "rebuild", ".", linkManager.createBuildProjectUrl());
        builder.newline().newline();
        if (!addShowExceptionLink) {
            return;
        }
        ShowExceptionFix showExceptionFix = new ShowExceptionFix(module.getProject(), throwable);
        builder.addLink("Show Exception", linkManager.createRunnableLink(showExceptionFix));
    }

    public void performClick(@NotNull RenderResult result, @NotNull String url) {
        Module module = result.getModule();
        PsiFile file = result.getFile();
        this.myLinkManager.handleUrl(url, module, file, this.myDataContext, result);
    }

    private void reportRelevantCompilationErrors(@NotNull RenderLogger logger, @NotNull RenderTask renderTask) {
        boolean hasJavaErrors;
        Module module = logger.getModule();
        if (module == null) {
            return;
        }
        Project project = module.getProject();
        WolfTheProblemSolver wolfgang = WolfTheProblemSolver.getInstance((Project)project);
        if (!wolfgang.hasProblemFilesBeneath(module)) {
            return;
        }
        HtmlBuilder builder = new HtmlBuilder();
        String summary = null;
        if (logger.seenTagPrefix("resources.")) {
            boolean haveResourceErrors = wolfgang.hasProblemFilesBeneath(virtualFile -> virtualFile.getFileType() == StdFileTypes.XML);
            if (haveResourceErrors) {
                summary = "Resource errors";
                builder.addBold("This project contains resource errors, so aapt did not succeed, which can cause rendering failures. Fix resource problems first.").newline().newline();
            }
        } else if (renderTask.getLayoutlibCallback().isUsed() && (hasJavaErrors = wolfgang.hasProblemFilesBeneath(virtualFile -> virtualFile.getFileType() == StdFileTypes.JAVA))) {
            summary = "Compilation errors";
            builder.addBold("This project contains Java compilation errors, which can cause rendering failures for custom views. Fix compilation problems first.").newline().newline();
        }
        if (summary == null) {
            return;
        }
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary(summary).setHtmlContent(builder).build();
    }

    private boolean reportSandboxError(@NotNull Throwable throwable, boolean newlineBefore, boolean newlineAfter) {
        int version;
        if (!(throwable instanceof SecurityException)) {
            return false;
        }
        HtmlBuilder builder = new HtmlBuilder();
        if (newlineBefore) {
            builder.newline();
        }
        builder.addLink("Turn off custom view rendering sandbox", this.myLinkManager.createDisableSandboxUrl());
        String lastFailedPath = RenderSecurityManager.getLastFailedPath();
        if (lastFailedPath != null) {
            builder.newline().newline().add("Diagnostic info for Studio bug report:").newline().add("Failed path: ").add(lastFailedPath).newline();
            String tempDir = System.getProperty("java.io.tmpdir");
            builder.add("Normal temp dir: ").add(tempDir).newline();
            File normalized = new File(tempDir);
            builder.add("Normalized temp dir: ").add(normalized.getPath()).newline();
            try {
                builder.add("Canonical temp dir: ").add(normalized.getCanonicalPath()).newline();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            builder.add("os.name: ").add(SystemInfo.OS_NAME).newline().add("os.version: ").add(SystemInfo.OS_VERSION).newline().add("java.runtime.version: ").add(SystemInfo.JAVA_RUNTIME_VERSION);
        }
        if (throwable.getMessage().equals("Unable to create temporary file") && SystemInfo.JAVA_VERSION.startsWith("1.7.0_") && (version = Integer.parseInt(SystemInfo.JAVA_VERSION.substring(SystemInfo.JAVA_VERSION.indexOf(95) + 1))) > 0 && version < 45) {
            builder.newline().addIcon(HtmlBuilderHelper.getTipIconPath()).add("Tip: This may be caused by using an older version of JDK 1.7.0; try using at least 1.7.0_45 (you are using " + SystemInfo.JAVA_VERSION + ")");
        }
        if (newlineAfter) {
            builder.newline().newline();
        }
        this.reportThrowable(builder, throwable, false);
        this.addRefreshAction(builder);
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("Rendering sandbox error").setHtmlContent(builder).build();
        return true;
    }

    private boolean reportThrowable(@NotNull HtmlBuilder builder, @NotNull Throwable throwable, boolean hideIfIrrelevant) {
        StackTraceElement frame;
        int i;
        StackTraceElement[] frames = throwable.getStackTrace();
        int end = -1;
        boolean haveInterestingFrame = false;
        for (i = 0; i < frames.length; ++i) {
            String className;
            frame = frames[i];
            if (RenderErrorContributor.isInterestingFrame(frame)) {
                haveInterestingFrame = true;
            }
            if (!(className = frame.getClassName()).equals(RENDER_SESSION_IMPL_FQCN)) continue;
            end = i;
            break;
        }
        if (end == -1 || !haveInterestingFrame) {
            if (hideIfIrrelevant) {
                if (RenderLogger.isLoggingAllErrors()) {
                    ShowExceptionFix detailsFix = new ShowExceptionFix(this.myResult.getModule().getProject(), throwable);
                    builder.addLink("Show Exception", this.myLinkManager.createRunnableLink(detailsFix));
                }
                return true;
            }
            block1: for (i = 0; i < frames.length; ++i) {
                frame = frames[i];
                if (RenderErrorContributor.isVisible(frame)) continue;
                end = i;
                if (end != 0) break;
                for (int j = 0; j < frames.length; ++j) {
                    frame = frames[j];
                    String className = frame.getClassName();
                    if (!className.equals(RENDER_SESSION_IMPL_FQCN)) continue;
                    end = j;
                    break block1;
                }
                break;
            }
        }
        builder.addHtml(StringUtil.replace((String)throwable.toString(), (String)"\n", (String)"<BR/>")).newline();
        boolean wasHidden = false;
        int indent = 2;
        File platformSource = null;
        boolean platformSourceExists = true;
        for (int i2 = 0; i2 < end; ++i2) {
            String url;
            StackTraceElement frame2 = frames[i2];
            if (RenderErrorContributor.isHiddenFrame(frame2)) {
                wasHidden = true;
                continue;
            }
            String className = frame2.getClassName();
            String methodName = frame2.getMethodName();
            builder.addNbsps(indent);
            builder.add("at ").add(className).add(".").add(methodName);
            String fileName = frame2.getFileName();
            if (fileName == null || fileName.isEmpty()) continue;
            int lineNumber = frame2.getLineNumber();
            String location = fileName + ':' + lineNumber;
            if (RenderErrorContributor.isInterestingFrame(frame2)) {
                if (wasHidden) {
                    builder.addNbsps(indent).add("    ...").newline();
                    wasHidden = false;
                }
                url = this.myLinkManager.createOpenStackUrl(className, methodName, fileName, lineNumber);
                builder.add("(").addLink(location, url).add(")");
            } else {
                url = null;
                if (RenderErrorContributor.isFramework(frame2) && platformSourceExists) {
                    if (platformSource == null) {
                        IAndroidTarget target = this.myResult.getRenderTask() != null ? this.myResult.getRenderTask().getConfiguration().getRealTarget() : null;
                        platformSource = target != null ? AndroidSdks.getInstance().findPlatformSources(target) : null;
                        boolean bl = platformSourceExists = platformSource != null;
                    }
                    if (platformSourceExists) {
                        File parentFile;
                        File classFile = new File(platformSource, frame2.getClassName().replace('.', File.separatorChar) + ".java");
                        if (!classFile.exists() && !(classFile = new File((parentFile = classFile.getParentFile()).getParentFile(), parentFile.getName() + ".java")).exists()) {
                            classFile = null;
                        }
                        if (classFile != null) {
                            url = HtmlLinkManager.createFilePositionUrl(classFile, lineNumber, 0);
                        }
                    }
                }
                if (url != null) {
                    builder.add("(").addLink(location, url).add(")");
                } else {
                    builder.add("(").add(location).add(")");
                }
            }
            builder.newline();
        }
        builder.addLink("Copy stack to clipboard", this.myLinkManager.createRunnableLink(() -> {
            String text = Throwables.getStackTraceAsString((Throwable)throwable);
            try {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
                HtmlLinkManager.showNotification("Stack trace copied to clipboard");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        return false;
    }

    private void addRefreshAction(@NotNull HtmlBuilder builder) {
        builder.newlineIfNecessary().newline().addIcon(HtmlBuilderHelper.getRefreshIconPath()).addLink("Tip: Try to ", "refresh", " the layout.", this.myLinkManager.createRefreshRenderUrl()).newline();
    }

    private void reportRtlNotEnabled(@NotNull RenderLogger logger, @Nullable RenderTask task) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Application application;
            Project project = logger.getProject();
            if (project == null || project.isDisposed()) {
                return;
            }
            Module module = logger.getModule();
            if (module == null) {
                return;
            }
            AndroidFacet facet = AndroidFacet.getInstance(module);
            Manifest manifest = facet != null ? facet.getManifest() : null;
            Application application2 = application = manifest != null ? manifest.getApplication() : null;
            if (application == null) {
                return;
            }
            XmlTag applicationTag = application.getXmlTag();
            if (applicationTag == null) {
                return;
            }
            HtmlBuilder builder = new HtmlBuilder();
            builder.add("(").addLink("Add android:supportsRtl=\"true\" to the manifest", logger.getLinkManager().createRunnableLink(() -> {
                EditorDesignSurface surface;
                new SetAttributeFix(project, applicationTag, "supportsRtl", "http://schemas.android.com/apk/res/android", "true").execute();
                EditorDesignSurface editorDesignSurface = surface = task != null ? task.getDesignSurface() : null;
                if (surface != null) {
                    surface.forceUserRequestedRefresh();
                }
            })).add(")");
            this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("RTL support requires android:supportsRtl=\"true\" in the manifest").setHtmlContent(builder).build();
        });
    }

    private void reportTagResourceFormat(@NotNull RenderResult result, @NotNull RenderProblem message) {
        String[] values;
        Object clientData = message.getClientData();
        if (!(clientData instanceof String[])) {
            return;
        }
        String[] strings = (String[])clientData;
        if (strings.length != 2) {
            return;
        }
        RenderTask renderTask = result.getRenderTask();
        if (renderTask == null) {
            return;
        }
        IAndroidTarget target = renderTask.getConfiguration().getRealTarget();
        if (target == null) {
            return;
        }
        AndroidPlatform platform = renderTask.getPlatform();
        if (platform == null) {
            return;
        }
        AndroidTargetData targetData = platform.getSdkData().getTargetData(target);
        AttributeDefinitions definitionLookup = targetData.getPublicAttrDefs(result.getFile().getProject());
        String attributeName = strings[0];
        String currentValue = strings[1];
        if (definitionLookup == null) {
            return;
        }
        AttributeDefinition definition = definitionLookup.getAttrDefByName(attributeName);
        if (definition == null) {
            return;
        }
        Set<AttributeFormat> formats = definition.getFormats();
        if ((formats.contains((Object)AttributeFormat.Flag) || formats.contains((Object)AttributeFormat.Enum)) && (values = definition.getValues()).length > 0) {
            HtmlBuilder builder = new HtmlBuilder();
            builder.add("Change ").add(currentValue).add(" to: ");
            boolean first = true;
            for (String value : values) {
                if (first) {
                    first = false;
                } else {
                    builder.add(", ");
                }
                builder.addLink(value, this.myLinkManager.createReplaceAttributeValueUrl(attributeName, currentValue, value));
            }
            this.addRefreshAction(builder);
            this.addIssue().setSummary("Incorrect resource value format").setHtmlContent(builder).build();
        }
    }

    private void reportOtherProblems(@NotNull RenderLogger logger, RenderTask task) {
        List<RenderProblem> messages = logger.getMessages();
        if (messages == null || messages.isEmpty()) {
            return;
        }
        HashSet seenTags = Sets.newHashSet();
        for (RenderProblem message : messages) {
            String tag = message.getTag();
            if (tag != null && seenTags.contains(tag)) continue;
            seenTags.add(tag);
            if (tag != null) {
                if ("resources.format".equals(tag)) {
                    this.reportTagResourceFormat(this.myResult, message);
                    continue;
                }
                if ("rtl-not-enabled".equals(tag)) {
                    this.reportRtlNotEnabled(logger, task);
                    continue;
                }
                if ("rtl-not-supported".equals(tag)) {
                    this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("RTL support requires API level >= 17").setHtmlContent(new HtmlBuilder().addHtml(message.getHtml())).build();
                    continue;
                }
            }
            HtmlBuilder builder = new HtmlBuilder();
            String html = message.getHtml();
            Throwable throwable = message.getThrowable();
            String summary = "Render problem";
            if (throwable != null) {
                if (this.reportSandboxError(throwable, false, true)) continue;
                if (this.reportThrowable(builder, throwable, !html.isEmpty() || !message.isDefaultHtml())) {
                    if (!html.isEmpty()) {
                        builder.getStringBuilder().append(html);
                        builder.newlineIfNecessary();
                    }
                    summary = throwable.getLocalizedMessage() != null ? throwable.getLocalizedMessage() : summary;
                }
            } else {
                if (html.contains("has been edited more recently")) {
                    summary = "Build out-of-date";
                }
                builder.getStringBuilder().append(html);
                builder.newlineIfNecessary();
            }
            this.addRefreshAction(builder);
            this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary(summary).setHtmlContent(builder).build();
        }
    }

    private boolean addTypoSuggestions(@NotNull HtmlBuilder builder, @NotNull String actual, @Nullable Collection<String> views, boolean compareWithPackage) {
        int maxDistance;
        if (views == null || views.isEmpty()) {
            return false;
        }
        String actualBase = actual.substring(actual.lastIndexOf(46) + 1);
        String match = compareWithPackage ? actual : actualBase;
        int n = maxDistance = actualBase.length() >= 4 ? 2 : 1;
        if (!views.isEmpty()) {
            for (String suggested : views) {
                String matchWith;
                String suggestedBase = suggested.substring(suggested.lastIndexOf(46) + 1);
                String string = matchWith = compareWithPackage ? suggested : suggestedBase;
                if (Math.abs(actualBase.length() - suggestedBase.length()) > maxDistance) continue;
                boolean sameBase = actualBase.equals(suggestedBase);
                if (!compareWithPackage && sameBase) continue;
                if (compareWithPackage) {
                    if (!sameBase) continue;
                    if (actualBase.equals(actual) && !actualBase.equals(suggested) && ResourceHelper.isViewPackageNeeded(suggested, -1)) {
                        builder.addLink(String.format("Change to %1$s", suggested), this.myLinkManager.createReplaceTagsUrl(actual, suggested));
                        builder.add(", ");
                        continue;
                    }
                }
                if (compareWithPackage && Math.abs(match.length() - matchWith.length()) > maxDistance) continue;
                if (match.equals(matchWith)) {
                    return true;
                }
                if (LintUtils.editDistance((String)match, (String)matchWith) > maxDistance) continue;
                String labelClass = suggestedBase.equals(actual) || actual.indexOf(46) != -1 ? suggested : suggestedBase;
                builder.addLink(String.format("Change to %1$s", labelClass), this.myLinkManager.createReplaceTagsUrl(actual, ResourceHelper.isViewPackageNeeded(suggested, -1) ? suggested : suggestedBase));
                builder.add(", ");
            }
        }
        return false;
    }

    private void reportRenderingFidelityProblems(@NotNull RenderLogger logger, @NotNull RenderTask renderTask) {
        List<RenderProblem> fidelityWarnings = logger.getFidelityWarnings();
        if (fidelityWarnings.isEmpty()) {
            return;
        }
        HtmlBuilder builder = new HtmlBuilder();
        builder.add("The graphics preview in the layout editor may not be accurate:").newline();
        builder.beginList();
        int count = 0;
        for (RenderProblem warning : fidelityWarnings) {
            int remaining;
            builder.listItem();
            warning.appendHtml(builder.getStringBuilder());
            Object clientData = warning.getClientData();
            if (clientData != null) {
                builder.addLink(" (Ignore for this session)", this.myLinkManager.createRunnableLink(() -> {
                    RenderLogger.ignoreFidelityWarning(clientData);
                    EditorDesignSurface surface = renderTask.getDesignSurface();
                    if (surface != null) {
                        surface.forceUserRequestedRefresh();
                    }
                }));
            }
            builder.newline();
            if (++count != 3 || (remaining = fidelityWarnings.size() - count) <= 0) continue;
            builder.add("(").addHtml(Integer.toString(remaining)).add(" additional render fidelity issues hidden)");
            break;
        }
        builder.endList();
        builder.addLink("Ignore all fidelity warnings for this session", this.myLinkManager.createRunnableLink(() -> {
            RenderLogger.ignoreAllFidelityWarnings();
            EditorDesignSurface surface = renderTask.getDesignSurface();
            if (surface != null) {
                surface.forceUserRequestedRefresh();
            }
        }));
        builder.newline();
        this.addIssue().setSeverity(HighlightSeverity.WEAK_WARNING).setSummary("Layout fidelity warning").setHtmlContent(builder).build();
    }

    private void reportMissingClasses(@NotNull RenderLogger logger) {
        Collection<String> views;
        Set<String> missingClasses = logger.getMissingClasses();
        if (missingClasses.isEmpty()) {
            return;
        }
        HtmlBuilder builder = new HtmlBuilder();
        if (missingClasses.contains("CalendarView")) {
            builder.add("The ").addBold("CalendarView").add(" widget does not work correctly with this render target. As a workaround, try using the API 15 (Android 4.0.3) render target library by selecting it from the toolbar menu above.");
            if (missingClasses.size() == 1) {
                this.addIssue().setSeverity(HighlightSeverity.WARNING).setSummary("CalendarView does not work correctly with this render target").setHtmlContent(builder).build();
                return;
            }
        }
        boolean missingResourceClass = logger.isMissingResourceClass() && logger.getResourceClass() != null && logger.hasLoadedClasses();
        builder.add("The following classes could not be found:");
        builder.beginList();
        ArrayList customViews = null;
        ArrayList androidViewClassNames = null;
        Module module = logger.getModule();
        if (module != null && !(views = RenderErrorContributor.getAllViews(module)).isEmpty()) {
            customViews = Lists.newArrayListWithExpectedSize((int)Math.max(10, views.size() - 80));
            androidViewClassNames = Lists.newArrayListWithExpectedSize((int)views.size());
            for (String fqcn : views) {
                if (fqcn.startsWith("android.") && !ResourceHelper.isViewPackageNeeded(fqcn, -1)) {
                    androidViewClassNames.add(fqcn);
                    continue;
                }
                customViews.add(fqcn);
            }
        }
        if (missingResourceClass) {
            builder.listItem();
            builder.add(logger.getResourceClass());
        }
        boolean foundCustomView = false;
        for (String className : missingClasses) {
            builder.listItem();
            builder.add(className);
            builder.add(" (");
            foundCustomView |= this.addTypoSuggestions(builder, className, customViews, false);
            this.addTypoSuggestions(builder, className, customViews, true);
            this.addTypoSuggestions(builder, className, androidViewClassNames, false);
            if (this.myLinkManager == null) {
                return;
            }
            if ("android.support.constraint.ConstraintLayout".equals(className)) {
                builder.newline().addNbsps(3);
                builder.addLink("Add constraint-layout library dependency to the project", this.myLinkManager.createAddDependencyUrl("com.android.support.constraint:constraint-layout"));
                builder.add(", ");
            }
            if ("com.google.android.flexbox.FlexboxLayout".equals(className)) {
                builder.newline().addNbsps(3);
                builder.addLink("Add flexbox layout library dependency to the project", this.myLinkManager.createAddDependencyUrl("com.google.android:flexbox"));
                builder.add(", ");
            }
            builder.addLink("Fix Build Path", this.myLinkManager.createEditClassPathUrl());
            builder.add(", ");
            builder.addLink("Edit XML", this.myLinkManager.createShowTagUrl(className));
            if (className.indexOf(46) != -1) {
                builder.add(", ");
                builder.addLink("Create Class", this.myLinkManager.createNewClassUrl(className));
            }
            builder.add(")");
        }
        builder.endList();
        builder.addIcon(HtmlBuilderHelper.getTipIconPath());
        builder.addLink("Tip: Try to ", "build", " the project.", this.myLinkManager.createBuildProjectUrl());
        this.addRefreshAction(builder);
        if (foundCustomView) {
            builder.newline().add("One or more missing custom views were found in the project, but does not appear to have been compiled yet.");
        }
        builder.newline().newline();
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("Missing classes").setHtmlContent(builder).build();
    }

    private void reportBrokenClasses(@NotNull RenderLogger logger) {
        Map<String, Throwable> brokenClasses = logger.getBrokenClasses();
        if (brokenClasses.isEmpty()) {
            return;
        }
        HtmlBuilder builder = new HtmlBuilder();
        Module module = logger.getModule();
        for (Throwable throwable : brokenClasses.values()) {
            if (!RenderLogger.isIssue164378(throwable)) continue;
            RenderErrorContributor.addHtmlForIssue164378(throwable, module, this.myLinkManager, builder, false);
            break;
        }
        builder.add("The following classes could not be instantiated:");
        boolean listContainsElements = false;
        Throwable firstThrowable = null;
        builder.beginList();
        for (Map.Entry<String, Throwable> entry : brokenClasses.entrySet()) {
            String className = entry.getKey();
            Throwable throwable = entry.getValue();
            if (throwable != null && throwable.getMessage() != null && throwable.getMessage().startsWith(APP_COMPAT_REQUIRED_MSG)) continue;
            listContainsElements = true;
            builder.listItem().add(className).add(" (").addLink("Open Class", this.myLinkManager.createOpenClassUrl(className));
            if (throwable != null && module != null) {
                builder.add(", ");
                ShowExceptionFix detailsFix = new ShowExceptionFix(module.getProject(), throwable);
                builder.addLink("Show Exception", this.myLinkManager.createRunnableLink(detailsFix));
            }
            builder.add(", ").addLink("Clear Cache", this.myLinkManager.createClearCacheUrl()).add(")");
            if (firstThrowable != null || throwable == null) continue;
            firstThrowable = throwable;
        }
        if (!listContainsElements) {
            return;
        }
        builder.endList().addIcon(HtmlBuilderHelper.getTipIconPath()).addLink("Tip: Use ", "View.isInEditMode()", " in your custom views to skip code or show sample data when shown in the IDE.", "http://developer.android.com/reference/android/view/View.html#isInEditMode()").newline().newline().add("If this is an unexpected error you can also try to ").addLink("", "build the project", ", then ", this.myLinkManager.createBuildProjectUrl()).addLink("manually ", "refresh the layout", ".", this.myLinkManager.createRefreshRenderUrl());
        if (firstThrowable != null) {
            builder.newline().newline().addHeading("Exception Details", HtmlBuilderHelper.getHeaderFontColor()).newline();
            this.reportThrowable(builder, firstThrowable, false);
            this.reportSandboxError(firstThrowable, true, false);
        }
        builder.newline().newline();
        this.addIssue().setSeverity(HighlightSeverity.ERROR, 100).setSummary("Failed to instantiate one or more classes").setHtmlContent(builder).build();
    }

    private void reportInstantiationProblems(@NotNull RenderLogger logger) {
        AndroidFacet facet;
        Map<String, Throwable> classesWithIncorrectFormat = logger.getClassesWithIncorrectFormat();
        if (classesWithIncorrectFormat.isEmpty()) {
            return;
        }
        HtmlBuilder builder = new HtmlBuilder();
        builder.add("Preview might be incorrect: unsupported class version.").newline().addIcon(HtmlBuilderHelper.getTipIconPath()).add("Tip: ");
        builder.add("You need to run the IDE with the highest JDK version that you are compiling custom views with. ");
        int highest = ClassConverter.findHighestMajorVersion(classesWithIncorrectFormat.values());
        if (highest > 0 && highest > ClassConverter.getCurrentClassVersion()) {
            String required = ClassConverter.classVersionToJdk(highest);
            builder.add("One or more views have been compiled with JDK ").add(required).add(", but you are running the IDE on JDK ").add(ClassConverter.getCurrentJdkVersion()).add(". ");
        } else {
            builder.add("For example, if you are compiling with sourceCompatibility 1.7, you must run the IDE with JDK 1.7. ");
        }
        builder.add("Running on a higher JDK is necessary such that these classes can be run in the layout renderer. (Or, extract your custom views into a library which you compile with a lower JDK version.)").newline().newline().addLink("If you have just accidentally built your code with a later JDK, try to ", "build", " the project.", this.myLinkManager.createBuildProjectUrl()).newline().newline().add("Classes with incompatible format:");
        builder.beginList();
        ArrayList names = Lists.newArrayList(classesWithIncorrectFormat.keySet());
        Collections.sort(names);
        for (String className : names) {
            builder.listItem();
            builder.add(className);
            Throwable throwable = classesWithIncorrectFormat.get(className);
            if (!(throwable instanceof InconvertibleClassError)) continue;
            InconvertibleClassError error = (InconvertibleClassError)throwable;
            builder.add(" (Compiled with ").add(ClassConverter.classVersionToJdk(error.getMajor())).add(")");
        }
        builder.endList();
        Module module = logger.getModule();
        if (module == null) {
            return;
        }
        List<Module> problemModules = RenderErrorContributor.getProblemModules(module);
        if (!problemModules.isEmpty()) {
            builder.add("The following modules are built with incompatible JDK:").newline();
            Iterator<Module> it = problemModules.iterator();
            while (it.hasNext()) {
                Module problemModule = it.next();
                builder.add(problemModule.getName());
                if (!it.hasNext()) continue;
                builder.add(", ");
            }
            builder.newline();
        }
        if ((facet = AndroidFacet.getInstance(logger.getModule())) != null && !facet.requiresAndroidModel()) {
            Project project = logger.getModule().getProject();
            builder.addLink("Rebuild project with '-target 1.6'", this.myLinkManager.createRunnableLink(new RebuildWith16Fix(project))).newline();
            if (!problemModules.isEmpty()) {
                builder.addLink("Change Java SDK to 1.6", this.myLinkManager.createRunnableLink(new SwitchTo16Fix(project, problemModules))).newline();
            }
        }
        this.addIssue().setSeverity(HighlightSeverity.WARNING).setSummary("Some classes have an unsupported version").setHtmlContent(builder).build();
    }

    private void reportUnknownFragments(@NotNull RenderLogger logger) {
        List<String> fragmentNames = logger.getMissingFragments();
        if (fragmentNames == null || fragmentNames.isEmpty()) {
            return;
        }
        HtmlBuilder builder = new HtmlBuilder();
        builder.add("A ").addHtml("<code>").add("<fragment>").addHtml("</code>").add(" tag allows a layout file to dynamically include different layouts at runtime. ").add("At layout editing time the specific layout to be used is not known. You can choose which layout you would like previewed while editing the layout.");
        builder.beginList();
        for (String className : fragmentNames) {
            boolean isActivityKnown;
            builder.listItem();
            boolean isIdentified = className != null && !className.isEmpty();
            boolean bl = isActivityKnown = isIdentified && !className.startsWith("@");
            if (isIdentified) {
                builder.add("<fragment ").addBold(className).add(" ...>");
            } else {
                builder.add("<fragment>");
            }
            builder.add(" (");
            if (isActivityKnown) {
                Module module = logger.getModule();
                ApplicationManager.getApplication().runReadAction(() -> {
                    assert (module != null);
                    Project project = module.getProject();
                    GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
                    PsiClass clz = JavaPsiFacade.getInstance((Project)project).findClass(className, scope);
                    String layoutName = this.myResult.getFile().getName();
                    boolean separate = false;
                    if (clz != null) {
                        String matchText = clz.getText();
                        Pattern LAYOUT_FIELD_PATTERN = Pattern.compile("R\\.layout\\.([a-z0-9_]+)");
                        Matcher matcher = LAYOUT_FIELD_PATTERN.matcher(matchText);
                        TreeSet layouts = Sets.newTreeSet();
                        int index = 0;
                        while (matcher.find(index)) {
                            layouts.add(matcher.group(1));
                            index = matcher.end();
                        }
                        for (String layout : layouts) {
                            if (layout.equals(layoutName)) continue;
                            if (separate) {
                                builder.add(", ");
                            }
                            builder.addLink("Use @layout/" + layout, this.myLinkManager.createAssignLayoutUrl(className, layout));
                            separate = true;
                        }
                    }
                    if (separate) {
                        builder.add(", ");
                    }
                    builder.addLink("Pick Layout...", this.myLinkManager.createPickLayoutUrl(className));
                });
            } else {
                builder.addLink("Choose Fragment Class...", this.myLinkManager.createAssignFragmentUrl(className));
            }
            builder.add(")");
        }
        builder.endList().newline().addLink("Do not warn about <fragment> tags in this session", this.myLinkManager.createIgnoreFragmentsUrl()).newline();
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("Unknown fragments").setHtmlContent(builder).build();
    }

    private void reportAppCompatRequired(@NotNull RenderLogger logger) {
        Map<String, Throwable> brokenClasses = logger.getBrokenClasses();
        if (brokenClasses.isEmpty()) {
            return;
        }
        brokenClasses.values().stream().filter(Objects::nonNull).filter(t -> t.getMessage() != null && t.getMessage().startsWith(APP_COMPAT_REQUIRED_MSG)).findAny().ifPresent(t -> this.addIssue().setSeverity(HighlightSeverity.ERROR, 101).setSummary("Using the design library requires using Theme.AppCompat or a descendant").setHtmlContent(new HtmlBuilder().add("Select ").addItalic("Theme.AppCompat").add(" or a descendant in the theme selector.")).build());
    }

    public Collection<RenderErrorModel.Issue> reportIssues() {
        RenderLogger logger = this.myResult.getLogger();
        RenderTask renderTask = this.myResult.getRenderTask();
        this.reportMissingStyles(logger);
        this.reportAppCompatRequired(logger);
        if (renderTask != null) {
            this.reportOldNinePathRenderLib(logger, renderTask);
            this.reportRelevantCompilationErrors(logger, renderTask);
            this.reportMissingSizeAttributes(logger, renderTask);
            this.reportMissingClasses(logger);
        }
        this.reportBrokenClasses(logger);
        this.reportInstantiationProblems(logger);
        this.reportOtherProblems(logger, renderTask);
        this.reportUnknownFragments(logger);
        if (renderTask != null) {
            this.reportRenderingFidelityProblems(logger, renderTask);
        }
        return this.getIssues();
    }

    protected RenderResult getResult() {
        return this.myResult;
    }

    protected HtmlLinkManager getLinkManager() {
        return this.myLinkManager;
    }

    protected Collection<RenderErrorModel.Issue> getIssues() {
        return Collections.unmodifiableCollection(this.myIssues);
    }

    public static class Provider {
        static final ExtensionPointName<Provider> EP_NAME = new ExtensionPointName("com.android.rendering.renderErrorContributor");

        public boolean isApplicable(Project project) {
            return true;
        }

        public RenderErrorContributor getContributor(@NotNull RenderResult result, @Nullable DataContext dataContext) {
            return new RenderErrorContributor(result, dataContext);
        }
    }

    private static class SwitchTo16Fix
    implements Runnable {
        final List<Module> myProblemModules;
        private final Project myProject;

        private SwitchTo16Fix(Project project, List<Module> problemModules) {
            this.myProject = project;
            this.myProblemModules = problemModules;
        }

        @Override
        public void run() {
            String moduleToSelect;
            Sdk sdk;
            Set sdkNames = RenderErrorContributor.getSdkNamesFromModules(this.myProblemModules);
            if (sdkNames.size() == 1 && (sdk = ProjectJdkTable.getInstance().findJdk((String)sdkNames.iterator().next())) != null && sdk.getSdkType() instanceof AndroidSdkType) {
                ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance((Project)this.myProject);
                if (ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, () -> config.select(sdk, true))) {
                    RenderErrorContributor.askAndRebuild(this.myProject);
                }
                return;
            }
            String string = moduleToSelect = !this.myProblemModules.isEmpty() ? this.myProblemModules.iterator().next().getName() : null;
            if (ModulesConfigurator.showDialog((Project)this.myProject, (String)moduleToSelect, (String)ClasspathEditor.NAME)) {
                RenderErrorContributor.askAndRebuild(this.myProject);
            }
        }
    }

    private static class RebuildWith16Fix
    implements Runnable {
        private final Project myProject;

        private RebuildWith16Fix(Project project) {
            this.myProject = project;
        }

        @Override
        public void run() {
            JpsJavaCompilerOptions settings = JavacConfiguration.getOptions((Project)this.myProject, JavacConfiguration.class);
            if (!settings.ADDITIONAL_OPTIONS_STRING.isEmpty()) {
                settings.ADDITIONAL_OPTIONS_STRING = settings.ADDITIONAL_OPTIONS_STRING + ' ';
            }
            settings.ADDITIONAL_OPTIONS_STRING = settings.ADDITIONAL_OPTIONS_STRING + "-target 1.6";
            CompilerManager.getInstance((Project)this.myProject).rebuild(null);
        }
    }
}

