/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.ShowExceptionFix;
import com.android.utils.HtmlBuilder;
import com.android.utils.XmlUtils;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenderProblem
implements Comparable<RenderProblem> {
    public static final int PRIORITY_UNEXPECTED = 10;
    public static final int PRIORITY_MISSING_CLASSES = 20;
    public static final int PRIORITY_BROKEN_CLASSES = 30;
    public static final int PRIORITY_MISSING_ATTRIBUTE = 40;
    public static final int PRIORITY_MISSING_STYLE = 50;
    public static final int PRIORITY_NINEPATCH_RENDER_ERROR = 60;
    public static final int PRIORITY_RENDERING_FIDELITY = 1000;
    @NotNull
    private final HighlightSeverity mySeverity;
    private final int myOrdinal;
    private int myPriority = 10;
    @Nullable
    private Throwable myThrowable;
    @Nullable
    private Object myClientData;
    @Nullable
    private String myTag;
    protected boolean myIsDefaultHtml;
    private static int ourNextOrdinal;

    @NotNull
    public static RenderProblem createPlain(@NotNull HighlightSeverity severity, @Nullable String message) {
        return new Plain(severity, ourNextOrdinal++, message != null ? XmlUtils.toXmlTextValue((String)message) : "");
    }

    @NotNull
    public static RenderProblem createPlain(@NotNull HighlightSeverity severity, @NotNull String message, @Nullable Project project, @NotNull HtmlLinkManager linkManager, @Nullable Throwable throwable) {
        Html problem = new Html(severity, ourNextOrdinal++);
        HtmlBuilder builder = problem.getHtmlBuilder();
        builder.add(message);
        if (throwable != null) {
            String url = linkManager.createRunnableLink(new ShowExceptionFix(project, throwable));
            builder.add(" (").addLink("Details", url).add(")");
            problem.throwable(throwable);
            if (message.equals(throwable.getMessage())) {
                problem.myIsDefaultHtml = true;
            }
        }
        return problem;
    }

    @NotNull
    public static Html create(@NotNull HighlightSeverity severity) {
        return new Html(severity, ourNextOrdinal++);
    }

    @NotNull
    public static RenderProblem createDeferred(@NotNull HighlightSeverity severity, @Nullable String tag, @NotNull String text, @Nullable Throwable throwable) {
        return new Deferred(severity, tag, text, throwable);
    }

    private RenderProblem(@NotNull HighlightSeverity severity, int ordinal) {
        this.mySeverity = severity;
        this.myOrdinal = ordinal;
    }

    public RenderProblem throwable(@Nullable Throwable throwable) {
        this.myThrowable = throwable;
        return this;
    }

    public RenderProblem priority(int priority) {
        this.myPriority = priority;
        return this;
    }

    public RenderProblem tag(@Nullable String tag) {
        this.myTag = tag;
        return this;
    }

    @Nullable
    public String getTag() {
        return this.myTag;
    }

    @NotNull
    public abstract String getHtml();

    public boolean isDefaultHtml() {
        return this.myIsDefaultHtml;
    }

    public void appendHtml(@NotNull StringBuilder stringBuilder) {
        stringBuilder.append(this.getHtml());
    }

    @Override
    public int compareTo(RenderProblem other) {
        if (this.mySeverity != other.mySeverity) {
            return this.mySeverity.compareTo(other.mySeverity);
        }
        if (this.myPriority != other.myPriority) {
            return this.myPriority - other.myPriority;
        }
        return this.myOrdinal - other.myOrdinal;
    }

    @NotNull
    public static String format(List<RenderProblem> messages) {
        StringBuilder sb = new StringBuilder();
        for (RenderProblem message : messages) {
            sb.append(message.getHtml());
            sb.append("<br/>\n");
        }
        return sb.toString();
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        return this.mySeverity;
    }

    @Nullable
    public Throwable getThrowable() {
        return this.myThrowable;
    }

    @Nullable
    public Object getClientData() {
        return this.myClientData;
    }

    public void setClientData(@Nullable Object clientData) {
        this.myClientData = clientData;
    }

    public static class Deferred
    extends RenderProblem {
        protected final String myText;

        protected Deferred(@NotNull HighlightSeverity severity, @Nullable String tag, @NotNull String text, @Nullable Throwable throwable) {
            super(severity, ourNextOrdinal++);
            this.myText = text;
            this.tag(tag);
            this.throwable(throwable);
        }

        @Override
        @NotNull
        public String getHtml() {
            return new HtmlBuilder().add(this.myText).getHtml();
        }
    }

    public static class Html
    extends RenderProblem {
        @NotNull
        private final HtmlBuilder myBuilder = new HtmlBuilder();

        private Html(@NotNull HighlightSeverity severity, int ordinal) {
            super(severity, ordinal);
        }

        @Override
        @NotNull
        public String getHtml() {
            return this.myBuilder.getHtml();
        }

        @NotNull
        public HtmlBuilder getHtmlBuilder() {
            this.myIsDefaultHtml = false;
            return this.myBuilder;
        }
    }

    public static class Plain
    extends RenderProblem {
        @NotNull
        private final String myHtml;

        private Plain(@NotNull HighlightSeverity severity, int ordinal, @NotNull String text) {
            super(severity, ordinal);
            this.myHtml = text;
        }

        @Override
        @NotNull
        public String getHtml() {
            return this.myHtml;
        }
    }
}

