/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderTask;
import com.android.util.PropertiesMap;
import com.google.common.base.MoreObjects;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderResult {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final List<ViewInfo> myRootViews;
    @NotNull
    private final List<ViewInfo> mySystemRootViews;
    @NotNull
    private final ImagePool.Image myImage;
    @Nullable
    private final RenderTask myRenderTask;
    @NotNull
    private final Result myRenderResult;
    @NotNull
    private final Map<Object, PropertiesMap> myDefaultProperties;
    @NotNull
    private final Module myModule;

    protected RenderResult(@NotNull PsiFile file, @NotNull Module module, @NotNull RenderLogger logger, @Nullable RenderTask renderTask, @NotNull Result renderResult, @NotNull List<ViewInfo> rootViews, @NotNull List<ViewInfo> systemRootViews, @NotNull ImagePool.Image image, @NotNull Map<Object, PropertiesMap> defaultProperties) {
        this.myRenderTask = renderTask;
        this.myModule = module;
        this.myFile = file;
        this.myLogger = logger;
        this.myRenderResult = renderResult;
        this.myRootViews = rootViews;
        this.mySystemRootViews = systemRootViews;
        this.myImage = image;
        this.myDefaultProperties = defaultProperties;
    }

    @NotNull
    public static RenderResult create(@NotNull RenderTask renderTask, @NotNull RenderSession session, @NotNull PsiFile file, @NotNull RenderLogger logger, @NotNull ImagePool.Image image) {
        List<ViewInfo> rootViews = session.getRootViews();
        List<ViewInfo> systemRootViews = session.getSystemRootViews();
        Map<Object, PropertiesMap> defaultProperties = session.getDefaultProperties();
        return new RenderResult(file, renderTask.getModule(), logger, renderTask, session.getResult(), rootViews != null ? rootViews : Collections.emptyList(), systemRootViews != null ? systemRootViews : Collections.emptyList(), image, defaultProperties != null ? defaultProperties : Collections.emptyMap());
    }

    @NotNull
    public static RenderResult createSessionInitializationError(@NotNull RenderTask renderTask, @NotNull PsiFile file, @NotNull RenderLogger logger, @Nullable Throwable throwable) {
        Module module = logger.getModule();
        assert (module != null);
        return new RenderResult(file, module, logger, renderTask, Result.Status.ERROR_UNKNOWN.createResult("Failed to initialize session", throwable), Collections.emptyList(), Collections.emptyList(), ImagePool.NULL_POOLED_IMAGE, Collections.emptyMap());
    }

    @NotNull
    public static RenderResult createBlank(@NotNull PsiFile file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        return new RenderResult(file, module, new RenderLogger(null, module), null, Result.Status.ERROR_UNKNOWN.createResult(""), Collections.emptyList(), Collections.emptyList(), ImagePool.NULL_POOLED_IMAGE, Collections.emptyMap());
    }

    @NotNull
    public Result getRenderResult() {
        return this.myRenderResult;
    }

    @NotNull
    public RenderLogger getLogger() {
        return this.myLogger;
    }

    @NotNull
    public ImagePool.Image getRenderedImage() {
        return this.myImage != null ? this.myImage : ImagePool.NULL_POOLED_IMAGE;
    }

    public boolean hasImage() {
        return this.myImage != null && this.myImage != ImagePool.NULL_POOLED_IMAGE;
    }

    @NotNull
    public PsiFile getFile() {
        return this.myFile;
    }

    @Nullable
    public RenderTask getRenderTask() {
        return this.myRenderTask;
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public List<ViewInfo> getRootViews() {
        return this.myRootViews;
    }

    @NotNull
    public List<ViewInfo> getSystemRootViews() {
        return this.mySystemRootViews;
    }

    @NotNull
    public Map<Object, PropertiesMap> getDefaultProperties() {
        return this.myDefaultProperties;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("renderResult", (Object)this.myRenderResult).add("psiFile", (Object)this.myFile).add("rootViews", this.myRootViews).add("systemViews", this.mySystemRootViews).toString();
    }
}

