/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.MergeCookie;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.diagnostics.crash.CrashReporter;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.layoutlib.UnsupportedJavaRuntimeException;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.rendering.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.LayoutPullParsers;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderService
extends AndroidFacetScopedService {
    private static final long DEFAULT_RENDER_THREAD_TIMEOUT_MS = Long.getLong("layoutlib.thread.timeout", TimeUnit.SECONDS.toMillis(ApplicationManager.getApplication().isUnitTestMode() ? 60L : 6L));
    private static final long RENDER_THREAD_IDLE_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
    @VisibleForTesting
    public static long ourRenderThreadTimeoutMs = DEFAULT_RENDER_THREAD_TIMEOUT_MS;
    private static final AtomicReference<Thread> ourRenderingThread = new AtomicReference();
    private static ExecutorService ourRenderingExecutor;
    private static final AtomicInteger ourTimeoutExceptionCounter;
    private static final Key<RenderService> KEY;
    private static final String JDK_INSTALL_URL = "https://developer.android.com/preview/setup-sdk.html#java8";
    private final Object myCredential = new Object();
    private final ImagePool myImagePool = new ImagePool();
    private static final int MEASURE_SPEC_MODE_SHIFT = 30;
    private static final int MAX_MAGNITUDE = 0x2000000;

    private static void innerInitializeRenderExecutor() {
        ourRenderingExecutor = new ThreadPoolExecutor(0, 1, RENDER_THREAD_IDLE_TIMEOUT_MS, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread renderingThread = new Thread(null, r, "Layoutlib Render Thread");
            renderingThread.setDaemon(true);
            ourRenderingThread.set(renderingThread);
            return renderingThread;
        });
    }

    public static void initializeRenderExecutor() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        RenderService.innerInitializeRenderExecutor();
    }

    private static void shutdownRenderExecutor() {
        ourRenderingExecutor.shutdownNow();
        Thread currentThread = ourRenderingThread.getAndSet(null);
        if (currentThread != null) {
            currentThread.interrupt();
        }
    }

    public static void shutdownRenderExecutor(long timeoutSeconds) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        if (timeoutSeconds > 0L) {
            try {
                ourRenderingExecutor.awaitTermination(timeoutSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        RenderService.shutdownRenderExecutor();
    }

    @NotNull
    public static RenderService getInstance(@NotNull AndroidFacet facet) {
        RenderService renderService = (RenderService)facet.getUserData(KEY);
        if (renderService == null) {
            renderService = new RenderService(facet);
            facet.putUserData(KEY, renderService);
        }
        return renderService;
    }

    public static void setForTesting(@NotNull AndroidFacet facet, @Nullable RenderService renderService) {
        facet.putUserData(KEY, renderService);
    }

    @VisibleForTesting
    protected RenderService(@NotNull AndroidFacet facet) {
        super(facet);
    }

    @Nullable
    public static LayoutLibrary getLayoutLibrary(@Nullable Module module, @Nullable IAndroidTarget target) {
        if (module == null || target == null) {
            return null;
        }
        Project project = module.getProject();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            try {
                return platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
            }
            catch (RenderingException | IOException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean supportsCapability(@NotNull Module module, @NotNull IAndroidTarget target, int capability) {
        Project project = module.getProject();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            try {
                LayoutLibrary library = platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
                if (library != null) {
                    return library.supports(capability);
                }
            }
            catch (RenderingException | IOException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean canRender(@Nullable PsiFile file) {
        return file != null && LayoutPullParsers.isSupported(file);
    }

    @NotNull
    public RenderLogger createLogger() {
        Module module = this.getModule();
        return new RenderLogger(module.getName(), module, this.myCredential);
    }

    @Nullable
    public RenderTask createTask(@Nullable PsiFile psiFile, @NotNull Configuration configuration, @NotNull RenderLogger logger, @Nullable EditorDesignSurface surface) {
        return this.createTask(psiFile, configuration, logger, surface, null);
    }

    @Nullable
    public RenderTask createTask(@Nullable PsiFile psiFile, @NotNull Configuration configuration, @NotNull RenderLogger logger, @Nullable EditorDesignSurface surface, @Nullable ILayoutPullParserFactory parserFactory) {
        LayoutLibrary layoutLib;
        Module module = this.getModule();
        AndroidPlatform platform = RenderService.getPlatform(module, logger);
        if (platform == null) {
            return null;
        }
        IAndroidTarget target = configuration.getTarget();
        if (target == null) {
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "No render target was chosen"));
            return null;
        }
        try {
            layoutLib = platform.getSdkData().getTargetData(target).getLayoutLibrary(this.getProject());
            if (layoutLib == null) {
                String message = AndroidBundle.message("android.layout.preview.cannot.load.library.error", new Object[0]);
                logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message));
                return null;
            }
        }
        catch (UnsupportedJavaRuntimeException e) {
            RenderProblem.Html javaVersionProblem = RenderProblem.create(HighlightSeverity.ERROR);
            javaVersionProblem.getHtmlBuilder().add(e.getPresentableMessage()).newline().addLink("Install a supported JDK", JDK_INSTALL_URL);
            logger.addMessage(javaVersionProblem);
            return null;
        }
        catch (RenderingException e) {
            String message = e.getPresentableMessage();
            message = message != null ? message : AndroidBundle.message("android.layout.preview.default.error.message", new Object[0]);
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message, module.getProject(), logger.getLinkManager(), e));
            return null;
        }
        catch (IOException e) {
            String message = e.getMessage();
            logger.error(null, "I/O error: " + (message != null ? ": " + message : ""), null, e);
            return null;
        }
        if (psiFile != null && "PreferenceScreen".equals(AndroidPsiUtils.getRootTagName(psiFile)) && !layoutLib.supports(14)) {
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "This version of the rendering library does not support rendering Preferences. Update it using the SDK Manager"));
            return null;
        }
        Device device = configuration.getDevice();
        if (device == null) {
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "No device selected"));
            return null;
        }
        try {
            RenderTask task = new RenderTask(this, configuration, logger, layoutLib, device, this.myCredential, CrashReporter.getInstance(), this.myImagePool, parserFactory);
            if (psiFile != null) {
                task.setPsiFile(psiFile);
            }
            task.setDesignSurface(surface);
            return task;
        }
        catch (IncorrectOperationException | AssertionError | IllegalStateException e) {
            assert (this.isDisposed() || this.getFacet().isDisposed());
            return null;
        }
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        facet.putUserData(KEY, null);
        this.myImagePool.dispose();
    }

    @NotNull
    public Project getProject() {
        return this.getModule().getProject();
    }

    @Nullable
    public AndroidPlatform getPlatform() {
        return AndroidPlatform.getInstance(this.getModule());
    }

    @Nullable
    private static AndroidPlatform getPlatform(@NotNull Module module, @Nullable RenderLogger logger) {
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null && logger != null) {
            if (!AndroidMavenUtil.isMavenizedModule(module)) {
                RenderProblem.Html message = RenderProblem.create(HighlightSeverity.ERROR);
                logger.addMessage(message);
                message.getHtmlBuilder().addLink("No Android SDK found. Please ", "configure", " an Android SDK.", logger.getLinkManager().createRunnableLink(() -> {
                    Project project = module.getProject();
                    ProjectSettingsService service = ProjectSettingsService.getInstance((Project)project);
                    if (AndroidProjectInfo.getInstance(project).requiresAndroidModel() && service instanceof AndroidProjectSettingsService) {
                        ((AndroidProjectSettingsService)service).openSdkSettings();
                        return;
                    }
                    AndroidSdkUtils.openModuleDependenciesConfigurable(module);
                }));
            } else {
                String message = AndroidBundle.message("android.maven.cannot.parse.android.sdk.error", module.getName());
                logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message));
            }
        }
        return platform;
    }

    public static void runRenderAction(@NotNull Runnable runnable) throws Exception {
        RenderService.runRenderAction(Executors.callable(runnable));
    }

    public static <T> T runRenderAction(@NotNull Callable<T> callable) throws Exception {
        try {
            if (ourTimeoutExceptionCounter.get() > 3) {
                ourRenderingExecutor.submit(() -> ourTimeoutExceptionCounter.set(0)).get(50L, TimeUnit.MILLISECONDS);
            }
            T result = ourRenderingExecutor.submit(callable).get(ourRenderThreadTimeoutMs, TimeUnit.MILLISECONDS);
            ourTimeoutExceptionCounter.set(0);
            return result;
        }
        catch (TimeoutException e) {
            ourTimeoutExceptionCounter.incrementAndGet();
            Thread renderingThread = ourRenderingThread.get();
            TimeoutException timeoutException = new TimeoutException("Preview timed out while rendering the layout.\nThis typically happens when there is an infinite loop or unbounded recursion in one of the custom views.");
            if (renderingThread != null) {
                timeoutException.setStackTrace(renderingThread.getStackTrace());
            }
            throw timeoutException;
        }
    }

    @NotNull
    public static <T> ListenableFuture<T> runAsyncRenderAction(@NotNull Callable<T> callable) {
        ListenableFutureTask future = ListenableFutureTask.create(callable);
        ourRenderingExecutor.submit((Runnable)future);
        return future;
    }

    public static void runAsyncRenderAction(@NotNull Runnable runnable) {
        ourRenderingExecutor.submit(runnable);
    }

    public static ViewInfo getSafeBounds(ViewInfo view) {
        int left = Math.abs(view.getLeft());
        int right = Math.abs(view.getRight());
        int top = Math.abs(view.getTop());
        int bottom = Math.abs(view.getBottom());
        if (left < 0x2000000 && right < 0x2000000 && top < 0x2000000 && bottom < 0x2000000) {
            return view;
        }
        return new ViewInfo(null, null, 0, 0, 0, 0);
    }

    @Nullable
    public static XmlTag getXmlTag(ViewInfo view) {
        Object cookie = view.getCookie();
        if (cookie != null) {
            if (cookie instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                return snapshot.tag;
            }
            if (cookie instanceof MergeCookie && (cookie = ((MergeCookie)cookie).getCookie()) instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                return snapshot.tag;
            }
            if (cookie instanceof XmlTag) {
                return (XmlTag)cookie;
            }
        }
        return null;
    }

    static {
        ourTimeoutExceptionCounter = new AtomicInteger(0);
        KEY = Key.create((String)RenderService.class.getName());
        RenderService.innerInitializeRenderExecutor();
        ShutDownTracker.getInstance().registerShutdownTask(RenderService::shutdownRenderExecutor);
    }
}

