/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.diagnostics.crash.CrashReport;
import com.android.tools.idea.diagnostics.crash.CrashReporter;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderParamsFlags;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.LayoutFilePullParser;
import com.android.tools.idea.rendering.LayoutPsiPullParser;
import com.android.tools.idea.rendering.LayoutPullParsers;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.RenderSecurityManagerFactory;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.AssetRepositoryImpl;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParserException;

public class RenderTask
implements IImageFactory {
    private static final Logger LOG = Logger.getInstance(RenderTask.class);
    @NotNull
    private final RenderService myRenderService;
    @NotNull
    private final ImagePool myImagePool;
    @Nullable
    private XmlFile myPsiFile;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final LayoutlibCallbackImpl myLayoutlibCallback;
    private final AndroidVersion myMinSdkVersion;
    private final AndroidVersion myTargetSdkVersion;
    @NotNull
    private final LayoutLibrary myLayoutLib;
    @NotNull
    private final HardwareConfigHelper myHardwareConfigHelper;
    @Nullable
    private IncludeReference myIncludedWithin;
    @NotNull
    private SessionParams.RenderingMode myRenderingMode = SessionParams.RenderingMode.NORMAL;
    @Nullable
    private Integer myOverrideBgColor;
    private boolean myShowDecorations = true;
    @NotNull
    private final Configuration myConfiguration;
    @NotNull
    private final AssetRepositoryImpl myAssetRepository;
    private long myTimeout;
    @Nullable
    private EditorDesignSurface mySurface;
    @NotNull
    private final Locale myLocale;
    private final Object myCredential;
    private ResourceFolderType myFolderType;
    private boolean myProvideCookiesForIncludedViews = false;
    private RenderSession myRenderSession;
    private IImageFactory myImageFactoryDelegate;
    private SoftReference<BufferedImage> myCachedImageReference;
    private boolean isSecurityManagerEnabled = true;
    private CrashReporter myCrashReporter;
    private final List<ListenableFuture<?>> myRunningFutures = new LinkedList();
    private AtomicBoolean isDisposed = new AtomicBoolean(false);

    RenderTask(@NotNull RenderService renderService, @NotNull Configuration configuration, @NotNull RenderLogger logger, @NotNull LayoutLibrary layoutLib, @NotNull Device device, @NotNull Object credential, @NotNull CrashReporter crashReporter, @NotNull ImagePool imagePool, @Nullable ILayoutPullParserFactory parserFactory) {
        this.myRenderService = renderService;
        this.myLogger = logger;
        this.myCredential = credential;
        this.myConfiguration = configuration;
        this.myCrashReporter = crashReporter;
        this.myImagePool = imagePool;
        AndroidFacet facet = renderService.getFacet();
        Module module = facet.getModule();
        this.myAssetRepository = new AssetRepositoryImpl(facet);
        this.myHardwareConfigHelper = new HardwareConfigHelper(device);
        ScreenOrientation orientation = configuration.getFullConfig().getScreenOrientationQualifier() != null ? configuration.getFullConfig().getScreenOrientationQualifier().getValue() : ScreenOrientation.PORTRAIT;
        this.myHardwareConfigHelper.setOrientation(orientation);
        this.myLayoutLib = layoutLib;
        AppResourceRepository appResources = AppResourceRepository.getOrCreateInstance(facet);
        ActionBarHandler actionBarHandler = new ActionBarHandler(this, this.myCredential);
        this.myLayoutlibCallback = new LayoutlibCallbackImpl(this, this.myLayoutLib, appResources, module, facet, this.myLogger, this.myCredential, actionBarHandler, parserFactory);
        this.myLayoutlibCallback.loadAndParseRClass();
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(facet);
        this.myMinSdkVersion = moduleInfo.getMinSdkVersion();
        this.myTargetSdkVersion = moduleInfo.getTargetSdkVersion();
        this.myLocale = configuration.getLocale();
    }

    public void setPsiFile(@NotNull PsiFile psiFile) {
        if (!(psiFile instanceof XmlFile)) {
            throw new IllegalArgumentException("Can only render XML files: " + psiFile.getClass().getName());
        }
        this.myPsiFile = (XmlFile)psiFile;
        ApplicationManager.getApplication().runReadAction(() -> {
            this.myFolderType = ResourceHelper.getFolderType((PsiFile)this.myPsiFile);
        });
    }

    @Nullable
    public AndroidPlatform getPlatform() {
        return this.myRenderService.getPlatform();
    }

    @Nullable
    public ResourceResolver getResourceResolver() {
        return this.myConfiguration.getResourceResolver();
    }

    @NotNull
    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    @Nullable
    public ResourceFolderType getFolderType() {
        return this.myFolderType;
    }

    public void setFolderType(@NotNull ResourceFolderType folderType) {
        this.myFolderType = folderType;
    }

    @NotNull
    public Module getModule() {
        return this.myRenderService.getFacet().getModule();
    }

    @NotNull
    public IRenderLogger getLogger() {
        return this.myLogger;
    }

    @NotNull
    public HardwareConfigHelper getHardwareConfigHelper() {
        return this.myHardwareConfigHelper;
    }

    public boolean getShowDecorations() {
        return this.myShowDecorations;
    }

    public boolean isDisposed() {
        return this.isDisposed.get();
    }

    public Future<?> dispose() {
        if (this.isDisposed.getAndSet(true)) {
            assert (false) : "RenderTask was already disposed";
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("RenderTask was already disposed"));
        }
        FutureTask<Void> disposeTask = new FutureTask<Void>(() -> {
            try {
                ImmutableList currentRunningFutures;
                List<ListenableFuture<?>> list = this.myRunningFutures;
                synchronized (list) {
                    currentRunningFutures = ImmutableList.copyOf(this.myRunningFutures);
                    this.myRunningFutures.clear();
                }
                Futures.successfulAsList((Iterable)currentRunningFutures).get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug((Throwable)e);
            }
            this.myLayoutlibCallback.setLogger(IRenderLogger.NULL_LOGGER);
            this.myLayoutlibCallback.setResourceResolver(null);
            if (this.myRenderSession != null) {
                try {
                    RenderService.runAsyncRenderAction(() -> ((RenderSession)this.myRenderSession).dispose());
                    this.myRenderSession = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.myImageFactoryDelegate = null;
            return null;
        });
        new Thread(disposeTask, "RenderTask dispose thread").start();
        return disposeTask;
    }

    @NotNull
    public RenderTask setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.myHardwareConfigHelper.setOverrideRenderSize(overrideRenderWidth, overrideRenderHeight);
        return this;
    }

    @NotNull
    public RenderTask setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.myHardwareConfigHelper.setMaxRenderSize(maxRenderWidth, maxRenderHeight);
        return this;
    }

    @NotNull
    public RenderTask setRenderingMode(@NotNull SessionParams.RenderingMode renderingMode) {
        this.myRenderingMode = renderingMode;
        return this;
    }

    @NotNull
    public RenderTask setTimeout(long timeout) {
        this.myTimeout = timeout;
        return this;
    }

    @NotNull
    public RenderTask setOverrideBgColor(@Nullable Integer overrideBgColor) {
        this.myOverrideBgColor = overrideBgColor;
        return this;
    }

    @NotNull
    public RenderTask setDecorations(boolean showDecorations) {
        this.myShowDecorations = showDecorations;
        return this;
    }

    @Nullable
    public EditorDesignSurface getDesignSurface() {
        return this.mySurface;
    }

    @NotNull
    public RenderTask setDesignSurface(@Nullable EditorDesignSurface surface) {
        this.mySurface = surface;
        return this;
    }

    public boolean getProvideCookiesForIncludedViews() {
        return this.myProvideCookiesForIncludedViews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RenderResult createRenderSession(@NotNull IImageFactory factory) {
        RenderSecurityManager securityManager;
        IAndroidTarget target;
        ILayoutPullParser includingParser;
        if (this.myPsiFile == null) {
            throw new IllegalStateException("createRenderSession shouldn't be called on RenderTask without PsiFile");
        }
        ResourceResolver resolver = ResourceResolver.copy((ResourceResolver)this.getResourceResolver());
        if (resolver == null) {
            return null;
        }
        ILayoutPullParser modelParser = LayoutPullParsers.create(this);
        if (modelParser == null) {
            return null;
        }
        this.myLayoutlibCallback.reset();
        if (modelParser instanceof LayoutPsiPullParser) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myRenderService.getFacet());
            boolean useSrcCompat = androidModel != null && GradleUtil.dependsOn(androidModel, "com.android.support:appcompat-v7");
            ((LayoutPsiPullParser)modelParser).setUseSrcCompat(useSrcCompat);
            this.myLayoutlibCallback.setAaptDeclaredResources((Map<String, TagSnapshot>)((LayoutPsiPullParser)modelParser).getAaptDeclaredAttrs());
        }
        if ((includingParser = this.getIncludingLayoutParser(resolver, modelParser)) != null) {
            modelParser = includingParser;
        }
        int simulatedPlatform = (target = this.myConfiguration.getTarget()) instanceof CompatibilityRenderTarget ? target.getVersion().getApiLevel() : 0;
        Module module = this.myRenderService.getFacet().getModule();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        SessionParams params = new SessionParams(modelParser, this.myRenderingMode, (Object)module, hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger, simulatedPlatform);
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        params.setFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG, (Object)AndroidPsiUtils.getRootTagName((PsiFile)this.myPsiFile));
        params.setFlag(RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING, (Object)true);
        params.setFlag(RenderParamsFlags.FLAG_DO_NOT_RENDER_ON_CREATE, (Object)true);
        params.setExtendedViewInfoMode(true);
        MergedManifest manifestInfo = MergedManifest.get(module);
        LayoutDirectionQualifier qualifier = this.myConfiguration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier != null && qualifier.getValue() == LayoutDirection.RTL && !this.getLayoutLib().isRtl(this.myLocale.toLocaleId())) {
            params.setLocale("ur");
        } else {
            params.setLocale(this.myLocale.toLocaleId());
        }
        try {
            params.setRtlSupport(manifestInfo.isRtlSupported());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Device device = this.myConfiguration.getDevice();
        if (!this.myShowDecorations || HardwareConfigHelper.isWear((Device)device)) {
            params.setForceNoDecor();
        } else {
            try {
                params.setAppLabel(manifestInfo.getApplicationLabel());
                params.setAppIcon(manifestInfo.getApplicationIcon());
                String activity = this.myConfiguration.getActivity();
                if (activity != null) {
                    params.setActivityName(activity);
                    MergedManifest.ActivityAttributes attributes = manifestInfo.getActivityAttributes(activity);
                    if (attributes != null) {
                        if (attributes.getLabel() != null) {
                            params.setAppLabel(attributes.getLabel());
                        }
                        if (attributes.getIcon() != null) {
                            params.setAppIcon(attributes.getIcon());
                        }
                    }
                }
            }
            catch (Exception activity) {
                // empty catch block
            }
        }
        if (this.myOverrideBgColor != null) {
            params.setOverrideBgColor(this.myOverrideBgColor.intValue());
        } else if (this.requiresTransparency()) {
            params.setOverrideBgColor(0);
        }
        params.setImageFactory(factory);
        if (this.myTimeout > 0L) {
            params.setTimeout(this.myTimeout);
        }
        this.myLayoutlibCallback.setLogger(this.myLogger);
        this.myLayoutlibCallback.setResourceResolver(resolver);
        RenderSecurityManager renderSecurityManager = securityManager = this.isSecurityManagerEnabled ? RenderSecurityManagerFactory.create(module, this.getPlatform()) : null;
        if (securityManager != null) {
            securityManager.setActive(true, this.myCredential);
        }
        try {
            RenderSession session = this.myLayoutLib.createSession(params);
            if (session.getResult().isSuccess()) {
                long now = System.nanoTime();
                session.setSystemBootTimeNanos(now);
                session.setSystemTimeNanos(now);
                session.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(500L));
            }
            RenderResult result = RenderResult.create(this, session, (PsiFile)this.myPsiFile, this.myLogger, this.myImagePool.copyOf(session.getImage()));
            this.myRenderSession = session;
            this.addDiagnostics(result.getRenderResult());
            RenderResult renderResult = result;
            if (securityManager != null) {
                securityManager.dispose(this.myCredential);
            }
            return renderResult;
        }
        catch (Throwable throwable) {
            try {
                if (securityManager != null) {
                    securityManager.dispose(this.myCredential);
                }
                throw throwable;
            }
            catch (RuntimeException t) {
                this.myLogger.error(null, t.getLocalizedMessage(), t, null, null);
                throw t;
            }
        }
    }

    @Nullable
    private ILayoutPullParser getIncludingLayoutParser(ResourceResolver resolver, ILayoutPullParser modelParser) {
        if (this.myPsiFile == null) {
            throw new IllegalStateException("getIncludingLayoutParser shouldn't be called on RenderTask without PsiFile");
        }
        if (this.myIncludedWithin == null) {
            String layout = IncludeReference.getIncludingLayout(this.myPsiFile);
            Module module = this.myRenderService.getFacet().getModule();
            IncludeReference includeReference = this.myIncludedWithin = layout != null ? IncludeReference.get(module, this.myPsiFile, (RenderResources)resolver) : IncludeReference.NONE;
        }
        if (this.myIncludedWithin != IncludeReference.NONE) {
            assert (Comparing.equal((Object)this.myIncludedWithin.getToFile(), (Object)this.myPsiFile.getVirtualFile()));
            VirtualFile layoutVirtualFile = this.myIncludedWithin.getFromFile();
            try {
                String queryLayoutName = ResourceHelper.getResourceName((PsiFile)this.myPsiFile);
                this.myLayoutlibCallback.setLayoutParser(queryLayoutName, modelParser);
                ILayoutPullParser topParser = null;
                PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(this.myRenderService.getProject(), layoutVirtualFile);
                if (psiFile instanceof XmlFile) {
                    LayoutPsiPullParser parser = LayoutPsiPullParser.create((XmlFile)psiFile, this.myLogger);
                    parser.setProvideViewCookies(this.myProvideCookiesForIncludedViews);
                    topParser = parser;
                }
                if (topParser == null) {
                    topParser = LayoutFilePullParser.create((LayoutlibCallback)this.myLayoutlibCallback, this.myIncludedWithin.getFromPath());
                }
                return topParser;
            }
            catch (IOException e) {
                this.myLogger.error(null, String.format("Could not read layout file %1$s", this.myIncludedWithin.getFromPath()), e, null, e);
            }
            catch (XmlPullParserException e) {
                this.myLogger.error(null, String.format("XML parsing error: %1$s", e.getMessage()), e, null, e.getDetail() != null ? e.getDetail() : e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    <V> ListenableFuture<V> runAsyncRenderAction(@NotNull Callable<V> callable) {
        if (this.isDisposed.get()) {
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("RenderTask was already disposed"));
        }
        List<ListenableFuture<?>> list = this.myRunningFutures;
        synchronized (list) {
            final ListenableFuture<V> newFuture = RenderService.runAsyncRenderAction(callable);
            Futures.addCallback(newFuture, (FutureCallback)new FutureCallback<V>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(@Nullable V result) {
                    List list = RenderTask.this.myRunningFutures;
                    synchronized (list) {
                        RenderTask.this.myRunningFutures.remove(newFuture);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(@Nullable Throwable ignored) {
                    List list = RenderTask.this.myRunningFutures;
                    synchronized (list) {
                        RenderTask.this.myRunningFutures.remove(newFuture);
                    }
                }
            });
            this.myRunningFutures.add(newFuture);
            return newFuture;
        }
    }

    @Nullable
    public RenderResult inflate() {
        if (this.myPsiFile == null) {
            throw new IllegalStateException("inflate shouldn't be called on RenderTask without PsiFile");
        }
        try {
            return RenderService.runRenderAction(() -> this.createRenderSession((width, height) -> {
                if (this.myImageFactoryDelegate != null) {
                    return this.myImageFactoryDelegate.getImage(width, height);
                }
                return new BufferedImage(width, height, 2);
            }));
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message, this.myLogger.getProject(), this.myLogger.getLinkManager(), e));
            return RenderResult.createSessionInitializationError(this, (PsiFile)this.myPsiFile, this.myLogger, e);
        }
    }

    @NotNull
    public ListenableFuture<RenderResult> layout() {
        if (this.myRenderSession == null) {
            return Futures.immediateFuture(null);
        }
        assert (this.myPsiFile != null);
        try {
            RenderSession renderSession = this.myRenderSession;
            XmlFile psiFile = this.myPsiFile;
            return this.runAsyncRenderAction(() -> this.lambda$layout$4(renderSession, (PsiFile)psiFile));
        }
        catch (Exception exception) {
            return Futures.immediateFuture(null);
        }
    }

    private void reportException(@NotNull Throwable e) {
        this.myCrashReporter.submit(CrashReport.Builder.createForException(e).build());
    }

    @NotNull
    private ListenableFuture<RenderResult> renderInner() {
        if (this.myRenderSession == null) {
            Result result;
            RenderResult renderResult = this.inflate();
            Result result2 = result = renderResult != null ? renderResult.getRenderResult() : null;
            if (result == null || !result.isSuccess()) {
                if (result != null) {
                    if (result.getException() != null) {
                        this.reportException(result.getException());
                    }
                    this.myLogger.error(null, result.getErrorMessage(), result.getException(), null, null);
                }
                return Futures.immediateFuture((Object)renderResult);
            }
        }
        assert (this.myPsiFile != null);
        try {
            return this.runAsyncRenderAction(() -> {
                this.myRenderSession.render();
                RenderResult result = RenderResult.create(this, this.myRenderSession, (PsiFile)this.myPsiFile, this.myLogger, this.myImagePool.copyOf(this.myRenderSession.getImage()));
                Result renderResult = result.getRenderResult();
                if (renderResult.getException() != null) {
                    this.reportException(renderResult.getException());
                    this.myLogger.error(null, renderResult.getErrorMessage(), renderResult.getException(), null, null);
                }
                return result;
            });
        }
        catch (Exception e) {
            this.reportException(e);
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message, this.myLogger.getProject(), this.myLogger.getLinkManager(), e));
            return Futures.immediateFuture((Object)RenderResult.createSessionInitializationError(this, (PsiFile)this.myPsiFile, this.myLogger, e));
        }
    }

    @NotNull
    public ListenableFuture<RenderResult> render(@NotNull IImageFactory factory) {
        this.myImageFactoryDelegate = factory;
        return this.renderInner();
    }

    @NotNull
    public ListenableFuture<RenderResult> render() {
        return this.render(this);
    }

    public void setElapsedFrameTimeNanos(long nanos) {
        if (this.myRenderSession != null) {
            this.myRenderSession.setElapsedFrameTimeNanos(nanos);
        }
    }

    private void addDiagnostics(@NotNull Result result) {
        ILayoutPullParser layoutEmbeddedParser;
        if (!this.myLogger.hasProblems() && !result.isSuccess()) {
            if (result.getException() != null || result.getErrorMessage() != null) {
                this.myLogger.error(null, result.getErrorMessage(), result.getException(), null, null);
            } else if (result.getStatus() == Result.Status.ERROR_TIMEOUT) {
                this.myLogger.error(null, "Rendering timed out.", null, null, null);
            } else {
                this.myLogger.error(null, "Unknown render problem: " + result.getStatus(), null, null, null);
            }
        } else if (this.myIncludedWithin != null && this.myIncludedWithin != IncludeReference.NONE && (layoutEmbeddedParser = this.myLayoutlibCallback.getLayoutEmbeddedParser()) != null) {
            this.myLogger.error(null, String.format("The surrounding layout (%1$s) did not actually include this layout. Remove tools:showIn=... from the root tag.", this.myIncludedWithin.getFromResourceUrl()), null, null, null);
        }
    }

    @NotNull
    public ListenableFuture<BufferedImage> renderDrawable(ResourceValue drawableResourceValue) {
        if (drawableResourceValue == null) {
            return Futures.immediateFuture(null);
        }
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        Module module = this.myRenderService.getFacet().getModule();
        DrawableParams params = new DrawableParams(drawableResourceValue, (Object)module, hardwareConfig, (RenderResources)this.getResourceResolver(), (LayoutlibCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger);
        params.setForceNoDecor();
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        ListenableFuture<Result> futureResult = this.runAsyncRenderAction(() -> this.myLayoutLib.renderDrawable(params));
        return Futures.transform(futureResult, result -> {
            Object data;
            if (result != null && result.isSuccess() && (data = result.getData()) instanceof BufferedImage) {
                return (BufferedImage)data;
            }
            return null;
        });
    }

    @NotNull
    public List<BufferedImage> renderDrawableAllStates(ResourceValue drawableResourceValue) {
        if (drawableResourceValue == null) {
            return Collections.emptyList();
        }
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        Module module = this.myRenderService.getFacet().getModule();
        DrawableParams params = new DrawableParams(drawableResourceValue, (Object)module, hardwareConfig, (RenderResources)this.getResourceResolver(), (LayoutlibCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger);
        params.setForceNoDecor();
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        boolean supportsMultipleStates = this.myLayoutLib.supports(15);
        if (supportsMultipleStates) {
            params.setFlag(RenderParamsFlags.FLAG_KEY_RENDER_ALL_DRAWABLE_STATES, (Object)Boolean.TRUE);
        }
        try {
            Result result = RenderService.runRenderAction(() -> this.myLayoutLib.renderDrawable(params));
            if (result != null && result.isSuccess()) {
                Object data = result.getData();
                if (supportsMultipleStates && data instanceof List) {
                    return (List)data;
                }
                if (!supportsMultipleStates && data instanceof BufferedImage) {
                    return Collections.singletonList((BufferedImage)data);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    @NotNull
    private LayoutLibrary getLayoutLib() {
        return this.myLayoutLib;
    }

    @NotNull
    public LayoutlibCallbackImpl getLayoutlibCallback() {
        return this.myLayoutlibCallback;
    }

    @Nullable
    public XmlFile getPsiFile() {
        return this.myPsiFile;
    }

    public boolean supportsCapability(int capability) {
        return this.myLayoutLib.supports(capability);
    }

    public boolean isNonRectangular() {
        return this.getFolderType() == ResourceFolderType.DRAWABLE || this.getFolderType() == ResourceFolderType.MIPMAP;
    }

    public boolean requiresTransparency() {
        return this.isNonRectangular();
    }

    public BufferedImage getImage(int width, int height) {
        BufferedImage cached;
        BufferedImage bufferedImage = cached = this.myCachedImageReference != null ? (BufferedImage)this.myCachedImageReference.get() : null;
        if (cached == null || cached.getWidth() != width || cached.getHeight() != height) {
            cached = new BufferedImage(width, height, 2);
            this.myCachedImageReference = new SoftReference((Object)cached);
        }
        return cached;
    }

    public void useDesignMode(@Nullable PsiFile file) {
        if (file == null) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            XmlTag root;
            if (file instanceof XmlFile && (root = ((XmlFile)file).getRootTag()) != null && (root = LayoutPsiPullParser.getRootTag(root)) != null) {
                return root.getName();
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Map<XmlTag, ViewInfo> measureChildren(XmlTag parent, AttributeFilter filter) {
        LayoutPsiPullParser modelParser = LayoutPsiPullParser.create(filter, parent, this.myLogger);
        HashMap map = Maps.newHashMap();
        RenderSession session = null;
        try {
            session = RenderService.runRenderAction(() -> this.measure(modelParser));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (session != null) {
            try {
                Result result = session.getResult();
                if (result != null && result.isSuccess()) {
                    assert (session.getRootViews().size() == 1);
                    ViewInfo root = (ViewInfo)session.getRootViews().get(0);
                    List children = root.getChildren();
                    for (ViewInfo info : children) {
                        XmlTag tag = RenderService.getXmlTag(info);
                        if (tag == null) continue;
                        map.put(tag, info);
                    }
                }
                HashMap hashMap = map;
                return hashMap;
            }
            finally {
                RenderService.runAsyncRenderAction(() -> ((RenderSession)session).dispose());
            }
        }
        return null;
    }

    @Nullable
    public ViewInfo measureChild(XmlTag tag, AttributeFilter filter) {
        Map<XmlTag, ViewInfo> map;
        XmlTag parent = tag.getParentTag();
        if (parent != null && (map = this.measureChildren(parent, filter)) != null) {
            for (Map.Entry<XmlTag, ViewInfo> entry : map.entrySet()) {
                if (entry.getKey() != tag) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @Nullable
    private RenderSession measure(ILayoutPullParser parser) {
        ResourceResolver resolver = this.getResourceResolver();
        if (resolver == null) {
            return null;
        }
        this.myLayoutlibCallback.reset();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        Module module = this.myRenderService.getFacet().getModule();
        SessionParams params = new SessionParams(parser, SessionParams.RenderingMode.NORMAL, (Object)module, hardwareConfig, (RenderResources)resolver, (LayoutlibCallback)this.myLayoutlibCallback, this.myMinSdkVersion.getApiLevel(), this.myTargetSdkVersion.getApiLevel(), (LayoutLog)this.myLogger);
        params.setLayoutOnly();
        params.setForceNoDecor();
        params.setExtendedViewInfoMode(true);
        params.setLocale(this.myLocale.toLocaleId());
        params.setAssetRepository((AssetRepository)this.myAssetRepository);
        params.setFlag(RenderParamsFlags.FLAG_KEY_RECYCLER_VIEW_SUPPORT, (Object)true);
        MergedManifest manifestInfo = MergedManifest.get(module);
        try {
            params.setRtlSupport(manifestInfo.isRtlSupported());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.myLayoutlibCallback.setLogger(this.myLogger);
            this.myLayoutlibCallback.setResourceResolver(resolver);
            return this.myLayoutLib.createSession(params);
        }
        catch (RuntimeException t) {
            this.myLogger.error(null, t.getLocalizedMessage(), t, null, null);
            throw t;
        }
    }

    void setCrashReporter(@NotNull CrashReporter crashReporter) {
        this.myCrashReporter = crashReporter;
    }

    public void disableSecurityManager() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException("This method can only be called in unit test mode");
        }
        LOG.debug("Security manager was disabled");
        this.isSecurityManagerEnabled = false;
    }

    private /* synthetic */ RenderResult lambda$layout$4(RenderSession renderSession, PsiFile psiFile) throws Exception {
        this.myRenderSession.measure();
        return RenderResult.create(this, renderSession, psiFile, this.myLogger, ImagePool.NULL_POOLED_IMAGE);
    }

    public static interface AttributeFilter {
        @Nullable
        public String getAttribute(@NotNull XmlTag var1, @Nullable String var2, @NotNull String var3);
    }
}

