/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.webp;

import com.android.tools.idea.rendering.webp.WebpImageWriteParam;
import com.android.tools.idea.rendering.webp.WebpMetadata;
import com.android.tools.idea.rendering.webp.WebpNativeLibHelper;
import com.google.webp.libwebp;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.jetbrains.annotations.NotNull;

public class WebpImageWriterSpi
extends ImageWriterSpi {
    WebpImageWriterSpi() {
        this.vendorName = "Google Inc.";
        this.version = WebpNativeLibHelper.getEncoderVersion();
        this.suffixes = WebpMetadata.WEBP_SUFFIXES;
        this.names = WebpMetadata.WEBP_FORMAT_NAMES;
        this.MIMETypes = WebpMetadata.WEBP_MIME_TYPES;
        this.pluginClassName = WebpWriter.class.getName();
        this.outputTypes = new Class[]{ImageOutputStream.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeImage(@NotNull BufferedImage image, @NotNull OutputStream outputStream, boolean lossless, int quality) throws IOException {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
        Iterator<ImageWriter> iterator = ImageIO.getImageWriters(type, "webp");
        if (iterator.hasNext()) {
            ImageWriter writer = iterator.next();
            try (ImageOutputStream stream = ImageIO.createImageOutputStream(outputStream);){
                writer.setOutput(stream);
                try {
                    WebpImageWriteParam param = new WebpImageWriteParam(writer.getLocale(), !lossless, (float)quality / 100.0f);
                    writer.write(null, new IIOImage(image, null, null), param);
                }
                finally {
                    writer.dispose();
                    stream.flush();
                }
            }
        }
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier type) {
        return WebpImageWriterSpi.canWriteImage(type);
    }

    public static boolean canWriteImage(ImageTypeSpecifier type) {
        SampleModel sm = type.getSampleModel();
        ColorModel cm = type.getColorModel();
        return (sm.getNumBands() >= 2 && sm.getNumBands() <= 4 || cm instanceof IndexColorModel) && sm.getSampleSize(0) <= 8 && sm.getWidth() <= 65535 && sm.getHeight() <= 65535 && (cm == null || cm.getComponentSize()[0] <= 8) && WebpNativeLibHelper.loadNativeLibraryIfNeeded();
    }

    @Override
    public ImageWriter createWriterInstance(Object extension) throws IOException {
        WebpNativeLibHelper.requireNativeLibrary();
        return new WebpWriter(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "WebP Image Encoder";
    }

    private static class WebpWriter
    extends ImageWriter {
        private ImageOutputStream stream = null;

        public WebpWriter(ImageWriterSpi originatingProvider) {
            super(originatingProvider);
        }

        @Override
        public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
            return new WebpMetadata();
        }

        @Override
        public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
            return new WebpMetadata();
        }

        @Override
        public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
            return null;
        }

        @Override
        public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
            return null;
        }

        @Override
        public void setOutput(Object output) {
            super.setOutput(output);
            if (output != null) {
                if (!(output instanceof ImageOutputStream)) {
                    throw new IllegalArgumentException("output is not an ImageOutputStream");
                }
                this.stream = (ImageOutputStream)output;
                this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.stream = null;
            }
        }

        @Override
        public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
            int y;
            if (this.stream == null) {
                throw new IllegalStateException("output == null!");
            }
            boolean lossless = true;
            float quality = 0.75f;
            if (param != null && param.canWriteCompressed()) {
                lossless = false;
                if (param.getCompressionMode() == 2) {
                    quality = param.getCompressionQuality();
                }
            }
            Raster srcRas = WebpWriter.getRaster(image);
            int minX = srcRas.getMinX();
            int minY = srcRas.getMinY();
            int width = srcRas.getWidth();
            int height = srcRas.getHeight();
            int maxX = minX + width;
            int maxY = minY + height;
            byte[] data = new byte[width * height * 4];
            int index = 0;
            SampleModel sampleModel = srcRas.getSampleModel();
            int bands = sampleModel.getNumBands();
            if (bands == 1) {
                return;
            }
            assert (bands >= 2 && bands <= 4);
            DataBuffer buffer = srcRas.getDataBuffer();
            if (bands >= 3) {
                for (y = minY; y < maxY; ++y) {
                    for (int x = minX; x < maxX; ++x) {
                        for (int band = 0; band < bands; ++band) {
                            int sample = sampleModel.getSample(x, y, band, buffer);
                            data[index++] = (byte)sample;
                        }
                        if (bands != 3) continue;
                        data[index++] = -1;
                    }
                }
            } else {
                assert (bands == 2);
                for (y = minY; y < maxY; ++y) {
                    for (int x = minX; x < maxX; ++x) {
                        byte sample = (byte)sampleModel.getSample(x, y, 0, buffer);
                        data[index++] = sample;
                        data[index++] = sample;
                        data[index++] = sample;
                        byte alpha = (byte)sampleModel.getSample(x, y, 1, buffer);
                        data[index++] = alpha;
                    }
                }
            }
            byte[] encoded = lossless ? libwebp.WebPEncodeLosslessRGBA((byte[])data, (int)width, (int)height, (int)(4 * width)) : libwebp.WebPEncodeRGBA((byte[])data, (int)width, (int)height, (int)(4 * width), (float)((int)(100.0f * quality)));
            this.stream.write(encoded);
        }

        private static Raster getRaster(IIOImage image) {
            boolean rasterOnly = image.hasRaster();
            if (rasterOnly) {
                return image.getRaster();
            }
            RenderedImage renderedImage = image.getRenderedImage();
            if (renderedImage instanceof BufferedImage) {
                BufferedImage bufferedImage = (BufferedImage)renderedImage;
                if (renderedImage.getColorModel() instanceof IndexColorModel) {
                    BufferedImage rgb = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
                    Graphics2D graphics = rgb.createGraphics();
                    graphics.drawImage((Image)bufferedImage, 0, 0, null);
                    graphics.dispose();
                    return rgb.getRaster();
                }
                return bufferedImage.getRaster();
            }
            if (renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1) {
                Raster raster = renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY());
                if (raster.getWidth() != renderedImage.getWidth() || raster.getHeight() != renderedImage.getHeight()) {
                    raster = raster.createChild(raster.getMinX(), raster.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), raster.getMinX(), raster.getMinY(), null);
                }
                return raster;
            }
            return renderedImage.getData();
        }
    }
}

