/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.Library;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.IntArrayWrapper;
import com.android.resources.ResourceType;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidProject;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.res.FileResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepositoryRootListener;
import com.android.tools.idea.res.RDotTxtParser;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.ResourceRepositories;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.util.Pair;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppResourceRepository
extends MultiResourceRepository {
    private static final Logger LOG = Logger.getInstance(AppResourceRepository.class);
    private static final Key<Boolean> TEMPORARY_RESOURCE_CACHE = Key.create((String)"TemporaryResourceCache");
    private final AndroidFacet myFacet;
    private List<FileResourceRepository> myLibraries;
    private long myIdsModificationCount;
    private final LinkedList<FileResourceRepository> myAarLibraries = Lists.newLinkedList();
    private Set<String> myIds;
    private final Object RESOURCE_MAP_LOCK = new Object();
    @Nullable
    private Multimap<String, VirtualFile> myResourceDirMap;
    private ResourceVisibilityLookup myResourceVisibility;
    private ResourceVisibilityLookup.Provider myResourceVisibilityProvider;
    private static final int DYNAMIC_ID_SEED_START = 0x7FFF0000;
    private Map<ResourceType, TObjectIntHashMap<String>> myResourceValueMap;
    private TIntObjectHashMap<Pair<ResourceType, String>> myResIdValueToNameMap;
    private Map<IntArrayWrapper, String> myStyleableValueToNameMap;
    private final TObjectIntHashMap<TypedResourceName> myName2DynamicIdMap = new TObjectIntHashMap();
    private final TIntObjectHashMap<TypedResourceName> myDynamicId2ResourceMap = new TIntObjectHashMap();
    private int myDynamicSeed = 0x7FFF0000;
    private final IntArrayWrapper myWrapper = new IntArrayWrapper(null);

    @Nullable
    public static AppResourceRepository getOrCreateInstance(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? AppResourceRepository.getOrCreateInstance(facet) : null;
    }

    @NotNull
    public static AppResourceRepository getOrCreateInstance(@NotNull AndroidFacet facet) {
        return AppResourceRepository.findAppResources(facet, true);
    }

    @Nullable
    public static AppResourceRepository findExistingInstance(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? AppResourceRepository.findExistingInstance(facet) : null;
    }

    @Nullable
    public static AppResourceRepository findExistingInstance(@NotNull AndroidFacet facet) {
        return AppResourceRepository.findAppResources(facet, false);
    }

    @Contract(value="_, true -> !null")
    @Nullable
    private static AppResourceRepository findAppResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        ResourceRepositories repositories = ResourceRepositories.getOrCreateInstance(facet);
        return repositories.getAppResources(createIfNecessary);
    }

    @NotNull
    static AppResourceRepository create(@NotNull AndroidFacet facet) {
        List<FileResourceRepository> libraries = AppResourceRepository.computeLibraries(facet);
        AppResourceRepository repository = new AppResourceRepository(facet, AppResourceRepository.computeRepositories(facet, libraries), libraries);
        ProjectResourceRepositoryRootListener.ensureSubscribed(facet.getModule().getProject());
        return repository;
    }

    public static boolean testAndClearTempResourceCached(@NotNull Project project) {
        if (project.getUserData(TEMPORARY_RESOURCE_CACHE) != Boolean.TRUE) {
            return false;
        }
        project.putUserData(TEMPORARY_RESOURCE_CACHE, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Multimap<String, VirtualFile> getAllResourceDirs() {
        Object object = this.RESOURCE_MAP_LOCK;
        synchronized (object) {
            if (this.myResourceDirMap == null) {
                this.myResourceDirMap = HashMultimap.create();
                for (LocalResourceRepository localResourceRepository : this.getChildren()) {
                    this.myResourceDirMap.putAll((Object)localResourceRepository.getLibraryName(), localResourceRepository.getResourceDirs());
                }
            }
            return this.myResourceDirMap;
        }
    }

    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet, List<FileResourceRepository> libraries) {
        ArrayList repositories = Lists.newArrayListWithExpectedSize((int)10);
        ProjectResourceRepository resources = ProjectResourceRepository.getOrCreateInstance(facet);
        repositories.addAll(libraries);
        repositories.add(resources);
        if (StudioFlags.NELE_SAMPLE_DATA.get().booleanValue()) {
            repositories.add(new SampleDataResourceRepository(facet));
        }
        return repositories;
    }

    private static List<FileResourceRepository> computeLibraries(@NotNull AndroidFacet facet) {
        List<AndroidFacet> dependentFacets;
        Map<File, String> aarDirs;
        if (LOG.isDebugEnabled()) {
            LOG.debug("computeLibraries");
        }
        if ((aarDirs = AppResourceRepository.findAarLibraries(facet, dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true))).isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  No AARs");
            }
            return Collections.emptyList();
        }
        ArrayList dirs = Lists.newArrayList(aarDirs.keySet());
        Collections.sort(dirs);
        if (LOG.isDebugEnabled()) {
            for (File root : dirs) {
                LOG.debug("  Dependency: " + LogAnonymizerUtil.anonymizeClassName(aarDirs.get(root)));
            }
        }
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)aarDirs.size());
        for (File root : dirs) {
            resources.add(FileResourceRepository.get(root, aarDirs.get(root)));
        }
        return resources;
    }

    @NotNull
    private static Map<File, String> findAarLibraries(@NotNull AndroidFacet facet, @NotNull List<AndroidFacet> dependentFacets) {
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet);
        if (androidModuleModel != null) {
            ArrayList libraries = Lists.newArrayList();
            AppResourceRepository.addGradleLibraries(libraries, androidModuleModel);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidModuleModel dependentGradleModel = AndroidModuleModel.get(dependentFacet);
                if (dependentGradleModel == null) continue;
                AppResourceRepository.addGradleLibraries(libraries, dependentGradleModel);
            }
            GradleVersion modelVersion = androidModuleModel.getModelVersion();
            assert (modelVersion != null);
            return AppResourceRepository.findAarLibrariesFromGradle(modelVersion, dependentFacets, libraries);
        }
        Project project = facet.getModule().getProject();
        if (GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            project.putUserData(TEMPORARY_RESOURCE_CACHE, (Object)true);
        }
        return AppResourceRepository.findAarLibrariesFromIntelliJ(facet, dependentFacets);
    }

    @NotNull
    public static Collection<Library> findAarLibraries(@NotNull AndroidFacet facet) {
        AndroidModuleModel androidModel;
        ArrayList libraries = Lists.newArrayList();
        if (facet.requiresAndroidModel() && (androidModel = AndroidModuleModel.get(facet)) != null) {
            List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
            AppResourceRepository.addGradleLibraries(libraries, androidModel);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidModuleModel dependentGradleModel = AndroidModuleModel.get(dependentFacet);
                if (dependentGradleModel == null) continue;
                AppResourceRepository.addGradleLibraries(libraries, dependentGradleModel);
            }
        }
        return libraries;
    }

    private static Map<File, String> findAarLibrariesFromIntelliJ(AndroidFacet facet, List<AndroidFacet> dependentFacets) {
        HashMap<File, String> dirs = new HashMap<File, String>();
        ResourceFolderManager.addAarsFromModuleLibraries(facet, dirs);
        for (AndroidFacet f : dependentFacets) {
            ResourceFolderManager.addAarsFromModuleLibraries(f, dirs);
        }
        return dirs;
    }

    @NotNull
    private static Map<File, String> findAarLibrariesFromGradle(@NotNull GradleVersion modelVersion, List<AndroidFacet> dependentFacets, List<Library> libraries) {
        HashMap<File, String> files = new HashMap<File, String>(libraries.size());
        HashSet moduleNames = Sets.newHashSet();
        for (AndroidFacet f : dependentFacets) {
            moduleNames.add(f.getModule().getName());
        }
        try {
            for (Library library : libraries) {
                File resFolder;
                String libraryName = library.getArtifactAddress();
                if (moduleNames.contains(libraryName) || !(resFolder = new File(library.getResFolder())).exists()) continue;
                files.put(resFolder, libraryName);
                moduleNames.add(libraryName);
            }
        }
        catch (UnsupportedMethodException e) {
            LOG.warn("Incompatibility found between the IDE's builder-model and the cached Gradle model", (Throwable)e);
        }
        return files;
    }

    private static void addGradleLibraries(List<Library> list, AndroidModuleModel androidModuleModel) {
        list.addAll(androidModuleModel.getSelectedMainCompileLevel2Dependencies().getAndroidLibraries());
    }

    protected AppResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates, @NotNull List<FileResourceRepository> libraries) {
        super(facet.getModule().getName() + " with modules and libraries", delegates);
        this.myFacet = facet;
        this.myLibraries = libraries;
        for (FileResourceRepository library : libraries) {
            if (library.getResourceTextFile() == null) continue;
            this.myAarLibraries.add(library);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @NotNull
    public List<FileResourceRepository> getLibraries() {
        return this.myLibraries;
    }

    @NotNull
    private Set<String> getAllIds() {
        long currentModCount = this.getModificationCount();
        if (this.myIdsModificationCount < currentModCount) {
            this.myIdsModificationCount = currentModCount;
            if (this.myIds == null) {
                int size = 0;
                for (FileResourceRepository library : this.myLibraries) {
                    if (library.getAllDeclaredIds() == null) continue;
                    size += library.getAllDeclaredIds().size();
                }
                this.myIds = Sets.newHashSetWithExpectedSize((int)size);
            } else {
                this.myIds.clear();
            }
            for (FileResourceRepository library : this.myLibraries) {
                if (library.getAllDeclaredIds() == null) continue;
                this.myIds.addAll(library.getAllDeclaredIds());
            }
            this.myIds.addAll(super.getItemsOfType(ResourceType.ID));
        }
        return this.myIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<String> getItemsOfType(@NotNull ResourceType type) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return type == ResourceType.ID ? this.getAllIds() : super.getItemsOfType(type);
        }
    }

    void updateRoots() {
        List<FileResourceRepository> libraries = AppResourceRepository.computeLibraries(this.myFacet);
        List<LocalResourceRepository> repositories = AppResourceRepository.computeRepositories(this.myFacet, libraries);
        this.updateRoots(repositories, libraries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRoots(List<LocalResourceRepository> resources, List<FileResourceRepository> libraries) {
        this.myResourceVisibility = null;
        this.myResourceVisibilityProvider = null;
        Iterator<FileResourceRepository> iterator = this.RESOURCE_MAP_LOCK;
        synchronized (iterator) {
            this.myResourceDirMap = null;
        }
        this.invalidateResourceDirs();
        if (resources.equals(this.getChildren())) {
            return;
        }
        this.myResourceVisibility = null;
        this.myLibraries = libraries;
        this.myAarLibraries.clear();
        for (FileResourceRepository library : this.myLibraries) {
            if (library.getResourceTextFile() == null) continue;
            this.myAarLibraries.add(library);
        }
        this.setChildren(resources);
        this.resetDynamicIds(true);
        ModuleClassLoader.clearCache(this.myFacet.getModule());
    }

    @NotNull
    static AppResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull List<LocalResourceRepository> modules, @NotNull List<FileResourceRepository> libraries) {
        assert (modules.containsAll(libraries));
        assert (modules.size() == libraries.size() + 1);
        return new AppResourceRepository(facet, modules, libraries);
    }

    @Nullable
    public FileResourceRepository findRepositoryFor(@NotNull File aarDirectory) {
        String aarPath = aarDirectory.getPath();
        for (LocalResourceRepository localResourceRepository : this.myLibraries) {
            if (localResourceRepository instanceof FileResourceRepository) {
                FileResourceRepository repository = (FileResourceRepository)localResourceRepository;
                if (!repository.getResourceDirectory().getPath().startsWith(aarPath)) continue;
                return repository;
            }
            assert (false) : ((Object)((Object)localResourceRepository)).getClass();
        }
        int exploded = aarPath.indexOf("exploded-aar");
        if (exploded != -1) {
            String string = aarPath.substring(exploded) + File.separator + "res";
            for (LocalResourceRepository localResourceRepository : this.myLibraries) {
                if (localResourceRepository instanceof FileResourceRepository) {
                    FileResourceRepository repository = (FileResourceRepository)localResourceRepository;
                    String path = repository.getResourceDirectory().getPath();
                    if (!path.endsWith(string)) continue;
                    return repository;
                }
                assert (false) : ((Object)((Object)localResourceRepository)).getClass();
            }
        }
        return null;
    }

    @Nullable
    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        if (this.myResourceVisibilityProvider == null) {
            if (!this.myFacet.requiresAndroidModel() || this.myFacet.getAndroidModel() == null) {
                return null;
            }
            this.myResourceVisibilityProvider = new ResourceVisibilityLookup.Provider();
        }
        return this.myResourceVisibilityProvider;
    }

    @NotNull
    public ResourceVisibilityLookup getResourceVisibility(@NotNull AndroidFacet facet) {
        ResourceVisibilityLookup.Provider provider;
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
        if (androidModel != null && (provider = this.getResourceVisibilityProvider()) != null) {
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            IdeVariant variant = androidModel.getSelectedVariant();
            return provider.get((AndroidProject)androidProject, (Variant)variant);
        }
        return ResourceVisibilityLookup.NONE;
    }

    public boolean isPrivate(@NotNull ResourceType type, @NotNull String name) {
        if (this.myResourceVisibility == null) {
            ResourceVisibilityLookup.Provider provider = this.getResourceVisibilityProvider();
            if (provider == null) {
                return false;
            }
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if (androidModel == null) {
                return false;
            }
            this.myResourceVisibility = provider.get((AndroidProject)androidModel.getAndroidProject(), (Variant)androidModel.getSelectedVariant());
        }
        return this.myResourceVisibility.isPrivate(type, name);
    }

    @Nullable
    public Pair<ResourceType, String> resolveResourceId(int id) {
        TypedResourceName pair;
        Pair<ResourceType, String> result = null;
        if (this.myResIdValueToNameMap != null) {
            result = (Pair<ResourceType, String>)this.myResIdValueToNameMap.get(id);
        }
        if (result == null && (pair = (TypedResourceName)this.myDynamicId2ResourceMap.get(id)) != null) {
            result = pair.toPair();
        }
        return result;
    }

    @Nullable
    public String resolveStyleable(int[] id) {
        if (this.myStyleableValueToNameMap != null) {
            this.myWrapper.set(id);
            return this.myStyleableValueToNameMap.get(this.myWrapper);
        }
        return null;
    }

    @NotNull
    public Integer getResourceId(ResourceType type, String name) {
        TObjectIntHashMap<String> map;
        TObjectIntHashMap<String> tObjectIntHashMap = map = this.myResourceValueMap != null ? this.myResourceValueMap.get(type) : null;
        if (map == null || !map.containsKey((Object)name)) {
            return this.getDynamicId(type, name);
        }
        return map.get((Object)name);
    }

    @Nullable
    Integer[] getDeclaredArrayValues(List<AttrResourceValue> attrs, String styleableName) {
        ListIterator iter = this.myAarLibraries.listIterator();
        while (iter.hasNext()) {
            FileResourceRepository repo = (FileResourceRepository)((Object)iter.next());
            File resourceTextFile = repo.getResourceTextFile();
            if (resourceTextFile == null) continue;
            Integer[] in = null;
            try {
                in = RDotTxtParser.getDeclareStyleableArray(resourceTextFile, attrs, styleableName);
            }
            catch (Throwable e) {
                assert (false) : e.getLocalizedMessage();
                LOG.warn("Error while parsing R.txt", e);
            }
            if (in == null) continue;
            iter.remove();
            this.myAarLibraries.addFirst(repo);
            return in;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDynamicId(ResourceType type, String name) {
        TypedResourceName key = new TypedResourceName(type, name);
        TObjectIntHashMap<TypedResourceName> tObjectIntHashMap = this.myName2DynamicIdMap;
        synchronized (tObjectIntHashMap) {
            if (this.myName2DynamicIdMap.containsKey((Object)key)) {
                return this.myName2DynamicIdMap.get((Object)key);
            }
            int value = ++this.myDynamicSeed;
            this.myName2DynamicIdMap.put((Object)key, value);
            this.myDynamicId2ResourceMap.put(value, (Object)key);
            return value;
        }
    }

    public void setCompiledResources(TIntObjectHashMap<Pair<ResourceType, String>> id2res, Map<IntArrayWrapper, String> styleableId2name, Map<ResourceType, TObjectIntHashMap<String>> res2id) {
        this.myResourceValueMap = res2id;
        this.myResIdValueToNameMap = id2res;
        this.myStyleableValueToNameMap = styleableId2name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDynamicIds(boolean clearResourceRegistry) {
        if (clearResourceRegistry) {
            ResourceClassRegistry.get(this.myFacet.getModule().getProject()).clearCache(this);
        }
        TObjectIntHashMap<TypedResourceName> tObjectIntHashMap = this.myName2DynamicIdMap;
        synchronized (tObjectIntHashMap) {
            this.myDynamicSeed = 0x7FFF0000;
            this.myName2DynamicIdMap.clear();
            this.myDynamicId2ResourceMap.clear();
        }
    }

    private static final class TypedResourceName {
        @Nullable
        final ResourceType myType;
        @NotNull
        final String myName;
        Pair<ResourceType, String> myPair;

        public TypedResourceName(@Nullable ResourceType type, @NotNull String name) {
            this.myType = type;
            this.myName = name;
        }

        public Pair<ResourceType, String> toPair() {
            if (this.myPair == null) {
                this.myPair = Pair.of((Object)this.myType, (Object)this.myName);
            }
            return this.myPair;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedResourceName that = (TypedResourceName)o;
            if (this.myType != that.myType) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result = this.myType != null ? this.myType.hashCode() : 0;
            result = 31 * result + this.myName.hashCode();
            return result;
        }

        public String toString() {
            return String.format("Type=%1$s, value=%2$s", this.myType, this.myName);
        }
    }
}

