/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.builder.model.level2.Library;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.res.AppResourceRepository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssetRepositoryImpl
extends AssetRepository
implements Disposable {
    private AndroidFacet myFacet;

    public AssetRepositoryImpl(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
        Disposer.register((Disposable)this.myFacet, (Disposable)this);
    }

    public boolean isSupported() {
        return true;
    }

    @Nullable
    public InputStream openAsset(@NotNull String path, int mode) throws IOException {
        assert (this.myFacet != null);
        return AssetRepositoryImpl.getDirectories(this.myFacet, IdeaSourceProvider::getAssetsDirectories, Library::getAssetsFolder).map(assetDir -> assetDir.findFileByRelativePath(path)).map(assetDir -> {
            if (assetDir == null) {
                return null;
            }
            try {
                return assetDir.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).findAny().orElse(null);
    }

    private static boolean isCachedFontFile(@NotNull VirtualFile file) {
        File fontCachePathFile = DownloadableFontCacheService.getInstance().getFontPath();
        if (fontCachePathFile == null) {
            return false;
        }
        VirtualFile fontCachePath = VirtualFileManager.getInstance().findFileByUrl("file://" + fontCachePathFile.getAbsolutePath());
        if (fontCachePath == null) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)fontCachePath, (VirtualFile)file, (boolean)true);
    }

    @Nullable
    public InputStream openNonAsset(int cookie, @NotNull String path, int mode) throws IOException {
        assert (this.myFacet != null);
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl("file://" + path);
        if (file == null) {
            return null;
        }
        return AssetRepositoryImpl.getDirectories(this.myFacet, IdeaSourceProvider::getResDirectories, Library::getResFolder).filter(resDir -> VfsUtilCore.isAncestor((VirtualFile)resDir, (VirtualFile)file, (boolean)true)).map(resDir -> {
            try {
                return file.getInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }).findAny().orElseGet(() -> {
            if (AssetRepositoryImpl.isCachedFontFile(file)) {
                try {
                    return file.getInputStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        });
    }

    @NotNull
    private static Stream<VirtualFile> getDirectories(@NotNull AndroidFacet facet, @NotNull Function<IdeaSourceProvider, Collection<VirtualFile>> sourceMapper, @NotNull Function<Library, String> aarMapper) {
        Stream dirsFromSources = Stream.concat(Stream.of(facet), AndroidUtils.getAllAndroidDependencies(facet.getModule(), true).stream()).flatMap(f -> IdeaSourceProvider.getAllIdeaSourceProviders(f).stream()).distinct().map(sourceMapper).flatMap(Collection::stream);
        VirtualFileManager manager = VirtualFileManager.getInstance();
        Stream<VirtualFile> dirsFromAars = AppResourceRepository.findAarLibraries(facet).stream().map(aarMapper).map(path -> manager.findFileByUrl("file://" + path)).filter(Objects::nonNull);
        return Stream.concat(dirsFromSources, dirsFromAars);
    }

    public void dispose() {
        this.myFacet = null;
    }
}

