/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ClassField;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceNamespaces;
import com.android.ide.common.res2.ResourceTable;
import com.android.resources.ResourceType;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.res.DynamicResourceValueItem;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicResourceValueRepository
extends LocalResourceRepository
implements GradleSyncListener,
BuildVariantView.BuildVariantSelectionChangeListener {
    private final AndroidFacet myFacet;
    private final ResourceTable myFullTable = new ResourceTable();
    private final String myNamespace;

    private DynamicResourceValueRepository(@NotNull AndroidFacet facet, @Nullable String namespace) {
        super("Gradle Dynamic");
        this.myFacet = facet;
        this.myNamespace = namespace;
        assert (facet.requiresAndroidModel());
        Module module = facet.getModule();
        MessageBusConnection parent = GradleSyncState.subscribe(module.getProject(), this, (Disposable)module);
        Disposer.register((Disposable)parent, (Disposable)this);
        BuildVariantView.getInstance(this.myFacet.getModule().getProject()).addListener(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        Project project = this.myFacet.getModule().getProject();
        if (!project.isDisposed()) {
            BuildVariantView.getInstance(project).removeListener(this);
        }
    }

    @NotNull
    public static DynamicResourceValueRepository create(@NotNull AndroidFacet facet) {
        return new DynamicResourceValueRepository(facet, null);
    }

    @NotNull
    @VisibleForTesting
    public static DynamicResourceValueRepository createForTest(@NotNull AndroidFacet facet, @Nullable String namespace, @NotNull Map<String, ClassField> values) {
        DynamicResourceValueRepository repository = new DynamicResourceValueRepository(facet, namespace);
        repository.addValues(values);
        return repository;
    }

    protected ResourceTable getFullTable() {
        if (this.myFullTable.isEmpty()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if (androidModel == null) {
                return this.myFullTable;
            }
            IdeVariant selectedVariant = androidModel.getSelectedVariant();
            BuildTypeContainer buildType = androidModel.findBuildType(selectedVariant.getBuildType());
            if (buildType != null) {
                this.addValues(buildType.getBuildType().getResValues());
            }
            this.addValues(selectedVariant.getMergedFlavor().getResValues());
        }
        return this.myFullTable;
    }

    private void notifyGradleSynced() {
        this.myFullTable.clear();
        super.invalidateParentCaches();
    }

    private void addValues(Map<String, ClassField> resValues) {
        for (Map.Entry<String, ClassField> entry : resValues.entrySet()) {
            ClassField field = entry.getValue();
            String name = field.getName();
            assert (entry.getKey().equals(name)) : entry.getKey() + " vs " + name;
            ResourceType type = ResourceType.getEnum((String)field.getType());
            if (type == null) {
                LOG.warn("Ignoring field " + name + "(" + field + "): unknown type " + field.getType());
                continue;
            }
            ListMultimap map = (ListMultimap)this.myFullTable.get((Object)this.myNamespace, (Object)type);
            if (map == null) {
                map = ArrayListMultimap.create();
                this.myFullTable.put(this.myNamespace, (Object)type, (Object)map);
            } else if (map.containsKey((Object)name)) continue;
            DynamicResourceValueItem item = new DynamicResourceValueItem(this.myNamespace, type, field);
            map.put((Object)name, (Object)item);
        }
    }

    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@Nullable String namespace, @NotNull ResourceType type, boolean create) {
        ListMultimap multimap;
        if (!ResourceNamespaces.isSameNamespace((String)namespace, (String)this.myNamespace)) {
            return create ? ArrayListMultimap.create() : null;
        }
        if (this.myFullTable.isEmpty()) {
            this.getFullTable();
        }
        if ((multimap = (ListMultimap)this.myFullTable.get((Object)namespace, (Object)type)) == null && create) {
            multimap = ArrayListMultimap.create();
            this.myFullTable.put(namespace, (Object)type, (Object)multimap);
        }
        return multimap;
    }

    @NotNull
    public Set<String> getNamespaces() {
        return Collections.singleton(this.myNamespace);
    }

    @Override
    public void syncStarted(@NotNull Project project) {
    }

    @Override
    public void setupStarted(@NotNull Project project) {
    }

    @Override
    public void syncSucceeded(@NotNull Project project) {
        this.notifyGradleSynced();
    }

    @Override
    public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
    }

    @Override
    public void syncSkipped(@NotNull Project project) {
    }

    @Override
    public void selectionChanged() {
        this.notifyGradleSynced();
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        return ImmutableSet.of();
    }
}

