/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.DuplicateDataException;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceMerger;
import com.android.ide.common.res2.ResourceSet;
import com.android.ide.common.res2.ResourceTable;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.RDotTxtParser;
import com.android.tools.log.LogWrapper;
import com.android.utils.ILogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.SoftValueHashMap;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileResourceRepository
extends LocalResourceRepository {
    private static final Logger LOG = Logger.getInstance(FileResourceRepository.class);
    protected final ResourceTable myFullTable = new ResourceTable();
    @Nullable
    protected Collection<String> myAarDeclaredIds;
    @NotNull
    private final File myFile;
    @Nullable
    private final String myNamespace;
    @Nullable
    private final String myLibraryName;
    @Nullable
    private File myResourceTextFile;
    private static final SoftValueHashMap<File, FileResourceRepository> ourCache = new SoftValueHashMap();

    private FileResourceRepository(@NotNull File file, @Nullable String namespace, @Nullable String libraryName) {
        super(file.getName());
        this.myFile = file;
        this.myNamespace = namespace;
        this.myLibraryName = libraryName;
    }

    @NotNull
    static synchronized FileResourceRepository get(@NotNull File file, @Nullable String libraryName) {
        FileResourceRepository repository = (FileResourceRepository)((Object)ourCache.get((Object)file));
        if (repository == null) {
            repository = FileResourceRepository.create(file, null, libraryName);
            ourCache.put((Object)file, (Object)repository);
        }
        return repository;
    }

    @Nullable
    static synchronized FileResourceRepository getCached(@NotNull File file) {
        return (FileResourceRepository)((Object)ourCache.get((Object)file));
    }

    @NotNull
    private static FileResourceRepository create(@NotNull File file, @Nullable String namespace, @Nullable String libraryName) {
        FileResourceRepository repository = new FileResourceRepository(file, namespace, libraryName);
        try {
            ResourceMerger resourceMerger = FileResourceRepository.createResourceMerger(file, namespace, libraryName);
            repository.getItems().update(resourceMerger);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize resources", (Throwable)e);
        }
        File rDotTxt = new File(file.getParentFile(), "R.txt");
        if (rDotTxt.exists()) {
            repository.myResourceTextFile = rDotTxt;
            repository.myAarDeclaredIds = RDotTxtParser.getIdNames(rDotTxt);
        }
        return repository;
    }

    @NotNull
    public static FileResourceRepository createForTest(@NotNull File file, @Nullable String namespace, @Nullable String libraryName) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        return FileResourceRepository.create(file, namespace, libraryName);
    }

    @Nullable
    File getResourceTextFile() {
        return this.myResourceTextFile;
    }

    public static synchronized void reset() {
        ourCache.clear();
    }

    @NotNull
    public File getResourceDirectory() {
        return this.myFile;
    }

    @Override
    @Nullable
    public String getLibraryName() {
        return this.myLibraryName;
    }

    private static ResourceMerger createResourceMerger(File file, String namespace, String libraryName) {
        LogWrapper logger = new LogWrapper(LOG).alwaysLogAsDebug(true).allowVerbose(false);
        ResourceMerger merger = new ResourceMerger(0);
        ResourceSet resourceSet = new ResourceSet(file.getName(), namespace, libraryName, false);
        resourceSet.addSource(file);
        resourceSet.setTrackSourcePositions(false);
        try {
            resourceSet.loadFromFiles((ILogger)logger);
        }
        catch (DuplicateDataException e) {
            assert (false);
        }
        catch (MergingException e) {
            LOG.warn((Throwable)e);
        }
        merger.addDataSet(resourceSet);
        return merger;
    }

    protected ResourceTable getFullTable() {
        return this.myFullTable;
    }

    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@Nullable String namespace, @NotNull ResourceType type, boolean create) {
        ListMultimap multimap = (ListMultimap)this.myFullTable.get((Object)namespace, (Object)type);
        if (multimap == null && create) {
            multimap = ArrayListMultimap.create();
            this.myFullTable.put(namespace, (Object)type, (Object)multimap);
        }
        return multimap;
    }

    @NotNull
    public Set<String> getNamespaces() {
        return this.myFullTable.rowKeySet();
    }

    @Nullable
    protected Collection<String> getAllDeclaredIds() {
        return this.myAarDeclaredIds;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " for " + this.myFile + ": @" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)this.myFile, (!ApplicationManager.getApplication().isReadAccessAllowed() ? 1 : 0) != 0);
        if (virtualFile == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.of((Object)virtualFile);
    }
}

