/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceTable;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.DynamicResourceValueRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceRepositories;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;
    private final ResourceFolderManager.ResourceFolderListener myResourceFolderListener = (facet, folders, added, removed) -> this.updateRoots();

    @Nullable
    public static LocalResourceRepository getOrCreateInstance(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? ModuleResourceRepository.getOrCreateInstance(facet) : null;
    }

    @NotNull
    public static LocalResourceRepository getOrCreateInstance(@NotNull AndroidFacet facet) {
        return ModuleResourceRepository.findModuleResources(facet, true);
    }

    @Nullable
    public static LocalResourceRepository findExistingInstance(@NotNull AndroidFacet facet) {
        return ModuleResourceRepository.findModuleResources(facet, false);
    }

    @Contract(value="_, true -> !null")
    @Nullable
    private static LocalResourceRepository findModuleResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        ResourceRepositories repositories = ResourceRepositories.getOrCreateInstance(facet);
        return repositories.getModuleResources(createIfNecessary);
    }

    @NotNull
    static LocalResourceRepository create(@NotNull AndroidFacet facet) {
        if (!facet.requiresAndroidModel()) {
            VirtualFile primaryResourceDir = facet.getPrimaryResourceDir();
            if (primaryResourceDir == null) {
                return new EmptyRepository();
            }
            return ResourceFolderRegistry.get(facet, primaryResourceDir);
        }
        ResourceFolderManager folderManager = facet.getResourceFolderManager();
        List<VirtualFile> resourceDirectories = folderManager.getFolders();
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)(resourceDirectories.size() + 1));
        for (VirtualFile resourceDirectory : resourceDirectories) {
            ResourceFolderRepository repository = ResourceFolderRegistry.get(facet, resourceDirectory);
            resources.add(repository);
        }
        DynamicResourceValueRepository dynamicResources = DynamicResourceValueRepository.create(facet);
        resources.add(dynamicResources);
        ModuleResourceRepository repository = new ModuleResourceRepository(facet, (List<? extends LocalResourceRepository>)resources);
        Disposer.register((Disposable)repository, (Disposable)dynamicResources);
        return repository;
    }

    private ModuleResourceRepository(@NotNull AndroidFacet facet2, @NotNull List<? extends LocalResourceRepository> delegates) {
        super(facet2.getModule().getName(), delegates);
        this.myFacet = facet2;
        this.myFacet.getResourceFolderManager().addListener(this.myResourceFolderListener);
    }

    private void updateRoots() {
        this.updateRoots(this.myFacet.getResourceFolderManager().getFolders());
    }

    void updateRoots(List<VirtualFile> resourceDirectories) {
        List other = null;
        HashMap map = Maps.newHashMap();
        for (LocalResourceRepository localResourceRepository : this.getChildren()) {
            if (localResourceRepository instanceof ResourceFolderRepository) {
                ResourceFolderRepository folderRepository = (ResourceFolderRepository)localResourceRepository;
                VirtualFile resourceDir = folderRepository.getResourceDir();
                map.put(resourceDir, folderRepository);
                continue;
            }
            assert (localResourceRepository instanceof DynamicResourceValueRepository);
            if (other == null) {
                other = Lists.newArrayList();
            }
            other.add(localResourceRepository);
        }
        HashSet newDirs = Sets.newHashSet(resourceDirectories);
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)(newDirs.size() + (other != null ? other.size() : 0)));
        for (VirtualFile dir : resourceDirectories) {
            ResourceFolderRepository repository = (ResourceFolderRepository)((Object)map.get(dir));
            if (repository == null) {
                repository = ResourceFolderRegistry.get(this.myFacet, dir);
            } else {
                map.remove(dir);
            }
            arrayList.add(repository);
        }
        if (other != null) {
            arrayList.addAll(other);
        }
        if (arrayList.equals(this.getChildren())) {
            assert (map.isEmpty());
            return;
        }
        for (ResourceFolderRepository removed : map.values()) {
            removed.removeParent(this);
        }
        this.setChildren(arrayList);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myFacet.getResourceFolderManager().removeListener(this.myResourceFolderListener);
    }

    @NotNull
    public static ModuleResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull Collection<VirtualFile> resourceDirectories) {
        return ModuleResourceRepository.createForTest(facet, resourceDirectories, null, null);
    }

    @NotNull
    public static ModuleResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull Collection<VirtualFile> resourceDirectories, @Nullable String namespace, @Nullable DynamicResourceValueRepository dynamicResourceValueRepository) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ArrayList<LocalResourceRepository> delegates = new ArrayList<LocalResourceRepository>(resourceDirectories.size() + 1);
        for (VirtualFile resourceDirectory : resourceDirectories) {
            delegates.add(ResourceFolderRegistry.get(facet, resourceDirectory, namespace));
        }
        if (dynamicResourceValueRepository != null) {
            delegates.add(dynamicResourceValueRepository);
        }
        return new ModuleResourceRepository(facet, delegates);
    }

    private static class EmptyRepository
    extends LocalResourceRepository {
        protected EmptyRepository() {
            super("");
        }

        @Override
        @NotNull
        protected Set<VirtualFile> computeResourceDirs() {
            return Collections.emptySet();
        }

        protected ResourceTable getFullTable() {
            return new ResourceTable();
        }

        protected ListMultimap<String, ResourceItem> getMap(String namespace, ResourceType type, boolean create) {
            return create ? ArrayListMultimap.create() : null;
        }

        public Set<String> getNamespaces() {
            return Collections.emptySet();
        }
    }
}

