/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceNamespaces;
import com.android.ide.common.res2.ResourceTable;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiResourceRepository
extends LocalResourceRepository {
    @GuardedBy(value="ITEM_MAP_LOCK")
    private List<? extends LocalResourceRepository> myChildren;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private long[] myModificationCounts;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private ResourceTable myFullTable;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private Set<String> myCachedNamespaces;
    @GuardedBy(value="ITEM_MAP_LOCK")
    private final ResourceTable myCachedMaps = new ResourceTable();
    @GuardedBy(value="ITEM_MAP_LOCK")
    private final Map<ResourceType, Boolean> myCachedHasResourcesOfType = Maps.newEnumMap(ResourceType.class);
    @GuardedBy(value="ITEM_MAP_LOCK")
    private Map<String, DataBindingInfo> myDataBindingResourceFiles = Maps.newHashMap();
    @GuardedBy(value="ITEM_MAP_LOCK")
    private long myDataBindingResourceFilesModificationCount = Long.MIN_VALUE;

    MultiResourceRepository(@NotNull String displayName, @NotNull List<? extends LocalResourceRepository> children) {
        super(displayName);
        this.setChildren(children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChildren(@NotNull List<? extends LocalResourceRepository> children) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            LocalResourceRepository resources;
            int i;
            if (this.myChildren != null) {
                for (i = this.myChildren.size() - 1; i >= 0; --i) {
                    resources = this.myChildren.get(i);
                    resources.removeParent(this);
                }
            }
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.myChildren = children;
            this.myModificationCounts = new long[children.size()];
            if (children.size() == 1) {
                LocalResourceRepository child = children.get(0);
                child.setModificationCount(this.getModificationCount());
            }
            for (i = this.myChildren.size() - 1; i >= 0; --i) {
                resources = this.myChildren.get(i);
                resources.addParent(this);
                this.myModificationCounts[i] = resources.getModificationCount();
            }
            this.myFullTable = null;
            this.myCachedMaps.clear();
            this.myCachedHasResourcesOfType.clear();
        }
        this.invalidateParentCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends LocalResourceRepository> getChildren() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return ImmutableList.copyOf(this.myChildren);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getModificationCount() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myChildren.size() == 1) {
                return this.myChildren.get(0).getModificationCount();
            }
            boolean changed = false;
            for (int i = this.myChildren.size() - 1; i >= 0; --i) {
                LocalResourceRepository resources = this.myChildren.get(i);
                long rev = resources.getModificationCount();
                if (rev == this.myModificationCounts[i]) continue;
                this.myModificationCounts[i] = rev;
                changed = true;
            }
            if (changed) {
                this.setModificationCount(ourModificationCounter.incrementAndGet());
            }
            return super.getModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DataBindingInfo getDataBindingInfoForLayout(String layoutName) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (LocalResourceRepository localResourceRepository : this.myChildren) {
                DataBindingInfo info = localResourceRepository.getDataBindingInfoForLayout(layoutName);
                if (info == null) continue;
                return info;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<String, DataBindingInfo> getDataBindingResourceFiles() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            long modificationCount = this.getModificationCount();
            if (this.myDataBindingResourceFilesModificationCount == modificationCount) {
                return this.myDataBindingResourceFiles;
            }
            HashMap selected = Maps.newHashMap();
            for (LocalResourceRepository localResourceRepository : this.myChildren) {
                Map<String, DataBindingInfo> childFiles = localResourceRepository.getDataBindingResourceFiles();
                if (childFiles == null) continue;
                selected.putAll(childFiles);
            }
            this.myDataBindingResourceFiles = Collections.unmodifiableMap(selected);
            this.myDataBindingResourceFilesModificationCount = modificationCount;
            return this.myDataBindingResourceFiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public synchronized Set<String> getNamespaces() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myCachedNamespaces == null) {
                if (this.myChildren.size() == 1) {
                    this.myCachedNamespaces = this.myChildren.get(0).getNamespaces();
                } else {
                    this.myCachedNamespaces = new SmartHashSet();
                    for (LocalResourceRepository localResourceRepository : this.myChildren) {
                        for (String namespace : localResourceRepository.getNamespaces()) {
                            this.myCachedNamespaces.add(ResourceNamespaces.normalizeNamespace((String)namespace));
                        }
                    }
                }
            }
            return this.myCachedNamespaces;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceTable getFullTable() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myFullTable == null) {
                if (this.myChildren.size() == 1) {
                    this.myFullTable = this.myChildren.get(0).getItems();
                } else {
                    this.myFullTable = new ResourceTable();
                    for (String namespace : this.getNamespaces()) {
                        for (ResourceType type : ResourceType.values()) {
                            ListMultimap<String, ResourceItem> map = this.getMap(namespace, type, false);
                            if (map == null) continue;
                            this.myFullTable.put(namespace, (Object)type, map);
                        }
                    }
                }
            }
            return this.myFullTable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@Nullable String namespace, ResourceType type, boolean create) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap map = (ListMultimap)this.myCachedMaps.get((Object)namespace, (Object)type);
            if (map != null) {
                return map;
            }
            if (this.myChildren.size() == 1) {
                LocalResourceRepository child = this.myChildren.get(0);
                if (child instanceof MultiResourceRepository) {
                    return ((MultiResourceRepository)child).getMap(namespace, type);
                }
                return (ListMultimap)child.getItems().get((Object)namespace, (Object)type);
            }
            map = ArrayListMultimap.create();
            HashSet visited = Sets.newHashSet();
            HashMultimap seenQualifiers = HashMultimap.create();
            this.merge(visited, namespace, type, (SetMultimap<String, String>)seenQualifiers, (ListMultimap<String, ResourceItem>)map);
            this.myCachedMaps.put(namespace, (Object)type, (Object)map);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doMerge(@NotNull Set<LocalResourceRepository> visited, @Nullable String namespace, @NotNull ResourceType type, @NotNull SetMultimap<String, String> seenQualifiers, @NotNull ListMultimap<String, ResourceItem> result) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (int i = this.myChildren.size() - 1; i >= 0; --i) {
                this.myChildren.get(i).merge(visited, namespace, type, seenQualifiers, result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResourcesOfType(@NotNull ResourceType type) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (this.myChildren.size() == 1) {
                return this.myChildren.get(0).hasResourcesOfType(type);
            }
            Boolean cachedResult = this.myCachedHasResourcesOfType.get(type);
            if (cachedResult != null) {
                return cachedResult;
            }
            HashSet visited = Sets.newHashSet();
            boolean result = this.computeHasResourcesOfType(type, visited);
            this.myCachedHasResourcesOfType.put(type, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean computeHasResourcesOfType(@NotNull ResourceType type, @NotNull Set<LocalResourceRepository> visited) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            if (!visited.add(this)) {
                return false;
            }
            for (LocalResourceRepository localResourceRepository : this.myChildren) {
                if (!localResourceRepository.computeHasResourcesOfType(type, visited)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            for (int i = this.myChildren.size() - 1; i >= 0; --i) {
                LocalResourceRepository resources = this.myChildren.get(i);
                resources.removeParent(this);
                Disposer.dispose((Disposable)resources);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(@NotNull LocalResourceRepository repository) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            assert (this.myChildren.contains((Object)repository)) : repository;
            this.myCachedNamespaces = null;
            this.myCachedMaps.clear();
            this.myCachedHasResourcesOfType.clear();
            this.myFullTable = null;
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(@NotNull LocalResourceRepository repository, @Nullable String namespace, ResourceType ... types) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            assert (this.myChildren.contains((Object)repository)) : repository;
            for (ResourceType type : types) {
                this.myCachedNamespaces = null;
                this.myCachedMaps.remove((Object)namespace, (Object)type);
                if (!ResourceNamespaces.isDefaultNamespace((String)namespace)) continue;
                this.myCachedHasResourcesOfType.remove(type);
            }
            this.myFullTable = null;
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches(namespace, types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isScanPending(PsiFile psiFile) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
            for (int i = this.myChildren.size() - 1; i >= 0; --i) {
                LocalResourceRepository resources = this.myChildren.get(i);
                if (!resources.isScanPending(psiFile)) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public void sync() {
        super.sync();
        for (LocalResourceRepository localResourceRepository : this.getChildren()) {
            localResourceRepository.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            HashSet result = Sets.newHashSet();
            for (LocalResourceRepository localResourceRepository : this.myChildren) {
                result.addAll(localResourceRepository.computeResourceDirs());
            }
            return result;
        }
    }
}

