/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepositoryRootListener;
import com.android.tools.idea.res.ResourceRepositories;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectResourceRepository
extends MultiResourceRepository {
    private AndroidFacet myFacet;

    @Nullable
    public static ProjectResourceRepository getOrCreateInstance(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? ProjectResourceRepository.getOrCreateInstance(facet) : null;
    }

    @NotNull
    public static ProjectResourceRepository getOrCreateInstance(@NotNull AndroidFacet facet) {
        return ProjectResourceRepository.findProjectResources(facet, true);
    }

    @Nullable
    public static ProjectResourceRepository findExistingInstance(@NotNull AndroidFacet facet) {
        return ProjectResourceRepository.findProjectResources(facet, false);
    }

    @Contract(value="_, true -> !null")
    @Nullable
    private static ProjectResourceRepository findProjectResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        ResourceRepositories repositories = ResourceRepositories.getOrCreateInstance(facet);
        return repositories.getProjectResources(createIfNecessary);
    }

    private ProjectResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates) {
        super(facet.getModule().getName() + " with modules", delegates);
        this.myFacet = facet;
    }

    @NotNull
    public static ProjectResourceRepository create(@NotNull AndroidFacet facet) {
        List<LocalResourceRepository> resources = ProjectResourceRepository.computeRepositories(facet);
        ProjectResourceRepository repository = new ProjectResourceRepository(facet, resources);
        ProjectResourceRepositoryRootListener.ensureSubscribed(facet.getModule().getProject());
        return repository;
    }

    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet) {
        LocalResourceRepository main = ModuleResourceRepository.getOrCreateInstance(facet);
        List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
        if (dependentFacets.isEmpty()) {
            return Collections.singletonList(main);
        }
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)dependentFacets.size());
        for (AndroidFacet f : dependentFacets) {
            LocalResourceRepository r = ModuleResourceRepository.getOrCreateInstance(f);
            resources.add(r);
        }
        resources.add(main);
        return resources;
    }

    @VisibleForTesting
    void updateRoots() {
        List<LocalResourceRepository> repositories = ProjectResourceRepository.computeRepositories(this.myFacet);
        this.updateRoots(repositories);
    }

    private void updateRoots(List<LocalResourceRepository> resourceDirectories) {
        this.invalidateResourceDirs();
        if (!resourceDirectories.equals(this.getChildren())) {
            this.setChildren(resourceDirectories);
        }
    }

    @Override
    public void dispose() {
        this.myFacet = null;
        super.dispose();
    }

    @VisibleForTesting
    @NotNull
    static ProjectResourceRepository createForTest(AndroidFacet facet, List<LocalResourceRepository> modules) {
        return new ProjectResourceRepository(facet, modules);
    }
}

