/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ProjectResourceRepositoryRootListener {
    private ProjectResourceRepositoryRootListener(final @NotNull Project project) {
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                ProjectResourceRepositoryRootListener.moduleRootsChanged(project);
            }
        });
    }

    public static void ensureSubscribed(@NotNull Project project) {
        ServiceManager.getService((Project)project, ProjectResourceRepositoryRootListener.class);
    }

    private static void moduleRootsChanged(final @NotNull Project project) {
        DumbService.getInstance((Project)project).queueTask(new DumbModeTask(){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                indicator.setText("Updating resource repository roots");
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                for (Module module : moduleManager.getModules()) {
                    ProjectResourceRepositoryRootListener.moduleRootsChanged(module);
                }
            }
        });
    }

    private static void moduleRootsChanged(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            if (facet.requiresAndroidModel() && facet.getAndroidModel() == null) {
                return;
            }
            facet.getResourceFolderManager().invalidate();
            ProjectResourceRepository projectResources = ProjectResourceRepository.findExistingInstance(facet);
            if (projectResources != null) {
                projectResources.updateRoots();
                AppResourceRepository appResources = AppResourceRepository.findExistingInstance(facet);
                if (appResources != null) {
                    appResources.invalidateCache(projectResources);
                    appResources.updateRoots();
                }
            }
        }
    }
}

