/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.DeclareStyleableResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.res.AppResourceRepository;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class ResourceClassGenerator {
    private static final Logger LOG = Logger.getInstance(ResourceClassGenerator.class);
    private Map<ResourceType, TObjectIntHashMap<String>> myCache;
    private Map<String, List<Integer>> myStyleableCache;
    @NotNull
    private final AppResourceRepository myAppResources;

    private ResourceClassGenerator(@NotNull AppResourceRepository appResources) {
        this.myAppResources = appResources;
    }

    @NotNull
    public static ResourceClassGenerator create(@NotNull AppResourceRepository appResources) {
        return new ResourceClassGenerator(appResources);
    }

    @Nullable
    public byte[] generate(String fqcn) {
        String className = fqcn.replace('.', '/');
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("generate(%s)", LogAnonymizerUtil.anonymizeClassName(className)));
        }
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 49, className, null, Type.getInternalName(Object.class), null);
        int index = className.lastIndexOf(36);
        if (index != -1) {
            String typeName = className.substring(index + 1);
            ResourceType type = ResourceType.getEnum((String)typeName);
            if (type == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("  type '%s' doesn't exist", typeName));
                }
                return null;
            }
            cw.visitInnerClass(className, className.substring(0, index), typeName, 25);
            if (this.myCache == null) {
                this.myCache = Maps.newHashMap();
            }
            if (type == ResourceType.STYLEABLE) {
                if (this.myStyleableCache == null) {
                    TObjectIntHashMap styleableIntCache = new TObjectIntHashMap();
                    this.myCache.put(type, (TObjectIntHashMap<String>)styleableIntCache);
                    this.myStyleableCache = Maps.newHashMap();
                    this.generateStyleable(cw, (TObjectIntHashMap<String>)styleableIntCache, className);
                } else {
                    TObjectIntHashMap<String> styleableIntCache = this.myCache.get(type);
                    assert (styleableIntCache != null);
                    ResourceClassGenerator.generateFields(cw, styleableIntCache);
                    ResourceClassGenerator.generateIntArrayFromCache(cw, className, this.myStyleableCache);
                }
            } else {
                TObjectIntHashMap typeCache = this.myCache.get(type);
                if (typeCache == null) {
                    typeCache = new TObjectIntHashMap();
                    this.myCache.put(type, (TObjectIntHashMap<String>)typeCache);
                    this.generateValuesForType(cw, type, (TObjectIntHashMap<String>)typeCache);
                } else {
                    ResourceClassGenerator.generateFields(cw, typeCache);
                }
            }
        } else {
            boolean styleableAdded = false;
            for (ResourceType t : this.myAppResources.getAvailableResourceTypes()) {
                if (t == ResourceType.DECLARE_STYLEABLE) {
                    t = ResourceType.STYLEABLE;
                }
                if (t == ResourceType.STYLEABLE) {
                    if (styleableAdded) continue;
                    styleableAdded = true;
                }
                cw.visitInnerClass(className + "$" + t.getName(), className, t.getName(), 25);
            }
        }
        ResourceClassGenerator.generateConstructor(cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void generateValuesForType(@NotNull ClassWriter cw, @NotNull ResourceType resType, @NotNull TObjectIntHashMap<String> cache) {
        Collection<String> keys = this.myAppResources.getItemsOfType(resType);
        for (String key : keys) {
            int initialValue = this.myAppResources.getResourceId(resType, key);
            key = AndroidResourceUtil.getFieldNameByResourceName(key);
            ResourceClassGenerator.generateField(cw, key, initialValue);
            cache.put((Object)key, initialValue);
        }
    }

    @NotNull
    private static List<AttrResourceValue> getStyleableAttributes(@NotNull ResourceItem item) {
        ResourceValue resourceValue = (ResourceValue)ApplicationManager.getApplication().runReadAction(() -> item.getResourceValue(false));
        assert (resourceValue instanceof DeclareStyleableResourceValue);
        DeclareStyleableResourceValue dv = (DeclareStyleableResourceValue)resourceValue;
        return dv.getAllAttributes();
    }

    private void generateStyleable(@NotNull ClassWriter cw, @NotNull TObjectIntHashMap<String> styleableIntCache, String className) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("generateStyleable(%s)", LogAnonymizerUtil.anonymizeClassName(className)));
        }
        boolean debug = LOG.isDebugEnabled() && LogAnonymizerUtil.isPublicClass(className);
        Collection<String> declaredStyleables = this.myAppResources.getItemsOfType(ResourceType.DECLARE_STYLEABLE);
        for (String styleableName : declaredStyleables) {
            List items = this.myAppResources.getResourceItem(ResourceType.DECLARE_STYLEABLE, styleableName);
            if (items == null || items.isEmpty()) {
                if (!debug) continue;
                LOG.debug("  No items for " + styleableName);
                continue;
            }
            String fieldName = AndroidResourceUtil.getFieldNameByResourceName(styleableName);
            cw.visitField(25, fieldName, "[I", null, null);
            if (debug) {
                LOG.debug("  Defined styleable " + fieldName);
            }
            ArrayList<AttrResourceValue> mergedAttributes = new ArrayList<AttrResourceValue>();
            for (ResourceItem item : items) {
                mergedAttributes.addAll(ResourceClassGenerator.getStyleableAttributes(item));
            }
            int idx = 0;
            HashSet<String> styleablesEntries = new HashSet<String>();
            for (AttrResourceValue value : mergedAttributes) {
                String styleableEntryName = ResourceClassGenerator.getResourceName(fieldName, value);
                if (!styleablesEntries.add(styleableEntryName)) continue;
                Integer initialValue = idx++;
                cw.visitField(25, styleableEntryName, "I", null, (Object)initialValue);
                styleableIntCache.put((Object)styleableEntryName, initialValue.intValue());
                if (!debug) continue;
                LOG.debug("  Defined styleable " + styleableEntryName);
            }
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        for (String styleableName : declaredStyleables) {
            List items = this.myAppResources.getResourceItem(ResourceType.DECLARE_STYLEABLE, styleableName);
            if (items == null || items.isEmpty()) continue;
            ArrayList<Integer> values = new ArrayList<Integer>();
            ArrayList<AttrResourceValue> mergedAttributes = new ArrayList<AttrResourceValue>();
            String fieldName = AndroidResourceUtil.getFieldNameByResourceName(styleableName);
            this.myStyleableCache.put(fieldName, values);
            for (ResourceItem item : items) {
                List<AttrResourceValue> attributes = ResourceClassGenerator.getStyleableAttributes(item);
                if (attributes.isEmpty()) continue;
                mergedAttributes.addAll(attributes);
                Integer[] valuesArray = this.myAppResources.getDeclaredArrayValues(attributes, styleableName);
                if (valuesArray == null) {
                    valuesArray = new Integer[attributes.size()];
                }
                Collections.addAll(values, valuesArray);
            }
            HashSet<String> styleableEntries = new HashSet<String>();
            int idx = -1;
            for (AttrResourceValue value : mergedAttributes) {
                if (values.get(++idx) != null && value.isFramework()) continue;
                String name = value.getName();
                if (!styleableEntries.add(name)) {
                    values.remove(idx);
                    --idx;
                    continue;
                }
                values.set(idx, this.myAppResources.getResourceId(ResourceType.ATTR, name));
            }
            ResourceClassGenerator.generateArrayInitialization(mv, className, fieldName, values);
        }
        mv.visitInsn(177);
        mv.visitMaxs(4, 0);
        mv.visitEnd();
    }

    private static void generateFields(final @NotNull ClassWriter cw, @NotNull TObjectIntHashMap<String> values) {
        values.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String name, int value) {
                ResourceClassGenerator.generateField(cw, name, value);
                return true;
            }
        });
    }

    private static void generateField(@NotNull ClassWriter cw, String name, int value) {
        cw.visitField(25, name, "I", null, (Object)value).visitEnd();
    }

    private static void generateIntArrayFromCache(@NotNull ClassWriter cw, String className, Map<String, List<Integer>> styleableCache) {
        for (String name : styleableCache.keySet()) {
            cw.visitField(25, name, "[I", null, null);
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        for (Map.Entry<String, List<Integer>> entry : styleableCache.entrySet()) {
            List<Integer> values = entry.getValue();
            if (values.isEmpty()) continue;
            ResourceClassGenerator.generateArrayInitialization(mv, className, entry.getKey(), values);
        }
        mv.visitInsn(177);
        mv.visitMaxs(4, 0);
        mv.visitEnd();
    }

    private static void generateArrayInitialization(@NotNull MethodVisitor mv, String className, String fieldName, @NotNull List<Integer> values) {
        if (values.isEmpty()) {
            return;
        }
        mv.visitIntInsn(16, values.size());
        mv.visitIntInsn(188, 10);
        int idx = 0;
        for (Integer value : values) {
            mv.visitInsn(89);
            switch (idx) {
                case 0: {
                    mv.visitInsn(3);
                    break;
                }
                case 1: {
                    mv.visitInsn(4);
                    break;
                }
                case 2: {
                    mv.visitInsn(5);
                    break;
                }
                case 3: {
                    mv.visitInsn(6);
                    break;
                }
                case 4: {
                    mv.visitInsn(7);
                    break;
                }
                case 5: {
                    mv.visitInsn(8);
                    break;
                }
                default: {
                    mv.visitIntInsn(16, idx);
                }
            }
            mv.visitLdcInsn((Object)value);
            mv.visitInsn(79);
            ++idx;
        }
        mv.visitFieldInsn(179, className, fieldName, "[I");
    }

    private static void generateConstructor(@NotNull ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public static String getResourceName(String styleableName, @NotNull AttrResourceValue value) {
        StringBuilder sb = new StringBuilder(30);
        sb.append(styleableName);
        sb.append('_');
        if (value.isFramework()) {
            sb.append("android_");
        }
        String v = value.getName();
        int n = v.length();
        for (int i = 0; i < n; ++i) {
            char c = v.charAt(i);
            if (c == '.' || c == ':' || c == '-') {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

