/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.FileResourceRepository;
import com.android.tools.idea.res.ResourceClassGenerator;
import com.android.xml.AndroidManifest;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceClassRegistry
implements ProjectComponent {
    private final Map<AppResourceRepository, ResourceClassGenerator> myGeneratorMap = Maps.newHashMap();
    private final Project myProject;
    private Collection<String> myPackages;

    public ResourceClassRegistry(Project project) {
        this.myProject = project;
    }

    public void addLibrary(@NotNull AppResourceRepository appResources, @Nullable String pkg) {
        if (pkg != null && !pkg.isEmpty()) {
            if (this.myPackages == null) {
                this.myPackages = new HashSet();
            }
            this.myPackages.add(pkg);
            if (!this.myGeneratorMap.containsKey((Object)appResources)) {
                ResourceClassGenerator generator = ResourceClassGenerator.create(appResources);
                this.myGeneratorMap.put(appResources, generator);
            }
        }
    }

    public void addAarLibrary(@NotNull AppResourceRepository appResources, @NotNull File aarDir) {
        FileResourceRepository repository;
        String path = aarDir.getPath();
        if ((path.endsWith(".aar") || path.contains("exploded-aar")) && (repository = appResources.findRepositoryFor(aarDir)) != null) {
            this.addLibrary(appResources, this.getAarPackage(aarDir));
        }
    }

    @Nullable
    public String getAarPackage(@NotNull File aarDir) {
        File manifest = new File(aarDir, "AndroidManifest.xml");
        if (manifest.exists()) {
            try {
                return AndroidManifest.getPackage((IAbstractFile)new FileWrapper(manifest));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public byte[] findClassDefinition(@NotNull String name, @NotNull AppResourceRepository appRepo) {
        int index = name.lastIndexOf(46);
        if (index != -1 && name.charAt(index + 1) == 'R' && (index == name.length() - 2 || name.charAt(index + 2) == '$') && index > 1) {
            ResourceClassGenerator generator;
            String pkg = name.substring(0, index);
            if (this.myPackages != null && this.myPackages.contains(pkg) && (generator = this.myGeneratorMap.get((Object)appRepo)) != null) {
                return generator.generate(name);
            }
        }
        return null;
    }

    public void clearCache() {
        this.myGeneratorMap.clear();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AppResourceRepository appResources = AppResourceRepository.findExistingInstance(module);
            if (appResources == null) continue;
            appResources.resetDynamicIds(false);
        }
    }

    void clearCache(AppResourceRepository appResources) {
        this.myGeneratorMap.remove((Object)appResources);
    }

    public static ResourceClassRegistry get(@NotNull Project project) {
        return (ResourceClassRegistry)project.getComponent(ResourceClassRegistry.class);
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        return ResourceClassRegistry.class.getName();
    }

    Collection<String> getPackages() {
        return this.myPackages;
    }

    Map<AppResourceRepository, ResourceClassGenerator> getGeneratorMap() {
        return this.myGeneratorMap;
    }
}

