/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceRepositories
implements Disposable {
    private static final Key<ResourceRepositories> KEY = Key.create((String)ResourceRepositories.class.getName());
    private static final Object APP_RESOURCES_LOCK = new Object();
    private static final Object PROJECT_RESOURCES_LOCK = new Object();
    private static final Object MODULE_RESOURCES_LOCK = new Object();
    private AndroidFacet myFacet;
    private AppResourceRepository myAppResources;
    private ProjectResourceRepository myProjectResources;
    private LocalResourceRepository myModuleResources;

    @NotNull
    public static ResourceRepositories getOrCreateInstance(@NotNull AndroidFacet facet) {
        ResourceRepositories repositories = (ResourceRepositories)facet.getUserData(KEY);
        if (repositories == null) {
            repositories = (ResourceRepositories)facet.putUserDataIfAbsent(KEY, new ResourceRepositories(facet));
        }
        return repositories;
    }

    private ResourceRepositories(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
        Disposer.register((Disposable)facet, (Disposable)this);
    }

    @Contract(value="true -> !null")
    @Nullable
    AppResourceRepository getAppResources(boolean createIfNecessary) {
        AndroidFacet facet = this.myFacet;
        return (AppResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = APP_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myAppResources == null && createIfNecessary) {
                    this.myAppResources = AppResourceRepository.create(facet);
                    Disposer.register((Disposable)this, (Disposable)this.myAppResources);
                }
                return this.myAppResources;
            }
        }));
    }

    @Contract(value="true -> !null")
    @Nullable
    ProjectResourceRepository getProjectResources(boolean createIfNecessary) {
        AndroidFacet facet = this.myFacet;
        return (ProjectResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = PROJECT_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myProjectResources == null && createIfNecessary) {
                    this.myProjectResources = ProjectResourceRepository.create(facet);
                    Disposer.register((Disposable)this, (Disposable)this.myProjectResources);
                }
                return this.myProjectResources;
            }
        }));
    }

    @Contract(value="true -> !null")
    @Nullable
    public LocalResourceRepository getModuleResources(boolean createIfNecessary) {
        AndroidFacet facet = this.myFacet;
        return (LocalResourceRepository)((Object)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = MODULE_RESOURCES_LOCK;
            synchronized (object) {
                if (this.myModuleResources == null && createIfNecessary) {
                    this.myModuleResources = ModuleResourceRepository.create(facet);
                    Disposer.register((Disposable)this, (Disposable)this.myModuleResources);
                }
                return this.myModuleResources;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshResources() {
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myModuleResources != null) {
                Disposer.dispose((Disposable)this.myModuleResources);
                this.myModuleResources = null;
            }
        }
        object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myProjectResources != null) {
                Disposer.dispose((Disposable)this.myProjectResources);
                this.myProjectResources = null;
            }
        }
        object = APP_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myAppResources != null) {
                Disposer.dispose((Disposable)this.myAppResources);
                this.myAppResources = null;
            }
        }
    }

    public void dispose() {
    }
}

