/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidBaseProgramRunner
extends GenericProgramRunner {
    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        boolean showRunContent = env.getRunProfile() instanceof AndroidTestRunConfiguration;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = env.getRunnerAndConfigurationSettings();
        if (runnerAndConfigurationSettings != null) {
            runnerAndConfigurationSettings.setActivateToolWindowBeforeRun(showRunContent);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ExecutionResult result = state.execute(env.getExecutor(), (ProgramRunner)this);
        RunContentDescriptor descriptor = DefaultProgramRunnerKt.showRunContent((ExecutionResult)result, (ExecutionEnvironment)env);
        if (descriptor != null) {
            ProcessHandler processHandler = descriptor.getProcessHandler();
            assert (processHandler != null);
            RunProfile runProfile = env.getRunProfile();
            int uniqueId = runProfile instanceof RunConfigurationBase ? ((RunConfigurationBase)runProfile).getUniqueID() : -1;
            AndroidSessionInfo sessionInfo = new AndroidSessionInfo(processHandler, descriptor, uniqueId, env.getExecutor().getId(), env.getExecutor().getActionName(), InstantRunUtils.isInstantRunEnabled(env));
            processHandler.putUserData(AndroidSessionInfo.KEY, (Object)sessionInfo);
        }
        return descriptor;
    }
}

