/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.fd.FlightRecorder;
import com.android.tools.idea.fd.InstantRunBuildAnalyzer;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.run.AndroidLaunchTasksProvider;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.tasks.LaunchTasksProviderFactory;
import com.android.tools.idea.run.tasks.UpdateSessionTasksProvider;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLaunchTasksProviderFactory
implements LaunchTasksProviderFactory {
    private final AndroidRunConfigurationBase myRunConfig;
    private final ExecutionEnvironment myEnv;
    private final AndroidFacet myFacet;
    private final ApplicationIdProvider myApplicationIdProvider;
    private final ApkProvider myApkProvider;
    private final DeviceFutures myDeviceFutures;
    private final LaunchOptions myLaunchOptions;
    private final ProcessHandler myPreviousSessionProcessHandler;
    private final InstantRunContext myInstantRunContext;

    public AndroidLaunchTasksProviderFactory(@NotNull AndroidRunConfigurationBase runConfig, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ApkProvider apkProvider, @NotNull DeviceFutures deviceFutures, @NotNull LaunchOptions launchOptions, @Nullable ProcessHandler processHandler, @Nullable InstantRunContext instantRunContext) {
        this.myRunConfig = runConfig;
        this.myEnv = env;
        this.myFacet = facet;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myApkProvider = apkProvider;
        this.myDeviceFutures = deviceFutures;
        this.myLaunchOptions = launchOptions;
        this.myPreviousSessionProcessHandler = processHandler;
        this.myInstantRunContext = instantRunContext;
    }

    @Override
    @NotNull
    public LaunchTasksProvider get() {
        InstantRunBuildInfo instantRunBuildInfo;
        Project project = this.myEnv.getProject();
        InstantRunStatsService.get(project).notifyDeployStarted();
        InstantRunBuildAnalyzer analyzer = null;
        InstantRunBuildInfo instantRunBuildInfo2 = instantRunBuildInfo = this.myInstantRunContext != null ? this.myInstantRunContext.getInstantRunBuildInfo() : null;
        if (instantRunBuildInfo != null) {
            analyzer = new InstantRunBuildAnalyzer(project, this.myInstantRunContext, this.myPreviousSessionProcessHandler, this.getApks(), InstantRunSettings.isRestartActivity());
            if (InstantRunSettings.isRecorderEnabled()) {
                if (!this.myDeviceFutures.getDevices().isEmpty()) {
                    FlightRecorder.get(project).setLaunchTarget(this.myDeviceFutures.getDevices().get(0));
                }
                FlightRecorder.get(project).saveBuildInfo(instantRunBuildInfo);
            }
        }
        if (analyzer != null && analyzer.canReuseProcessHandler()) {
            return new UpdateSessionTasksProvider(analyzer, this.myLaunchOptions);
        }
        return new AndroidLaunchTasksProvider(this.myRunConfig, this.myEnv, this.myFacet, analyzer, this.myApplicationIdProvider, this.myApkProvider, this.myLaunchOptions);
    }

    @NotNull
    private Collection<ApkInfo> getApks() {
        try {
            List<IDevice> devices = this.myDeviceFutures.getIfReady();
            if (devices != null && !devices.isEmpty()) {
                return this.myApkProvider.getApks(devices.get(0));
            }
        }
        catch (ApkProvisionException e) {
            InstantRunManager.LOG.warn("Unable to get APKs from APK Provider: ", (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }
}

